rule win_dizzyvoid_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dizzyvoid."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dizzyvoid"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488b8bd0000000 4885c9 7403 ff5350 }
            // n = 4, score = 400
            //   488b8bd0000000       | dec                 eax
            //   4885c9               | mov                 ecx, dword ptr [ebx + 0xd8]
            //   7403                 | dec                 eax
            //   ff5350               | mov                 ecx, dword ptr [ebx + 0xd0]

        $sequence_1 = { 41c1e11c c1e904 4403c9 498bc8 48c1e902 418bc1 48c1e802 }
            // n = 7, score = 400
            //   41c1e11c             | dec                 eax
            //   c1e904               | test                ecx, ecx
            //   4403c9               | je                  8
            //   498bc8               | call                dword ptr [ebx + 0x50]
            //   48c1e902             | inc                 ecx
            //   418bc1               | shl                 ecx, 0x1c
            //   48c1e802             | shr                 ecx, 4

        $sequence_2 = { 48b865210b59c84216b2 4c2bc1 49f7e8 4903d0 }
            // n = 4, score = 400
            //   48b865210b59c84216b2     | dec    eax
            //   4c2bc1               | imul                ecx
            //   49f7e8               | dec                 eax
            //   4903d0               | add                 edx, ecx

        $sequence_3 = { 48b865210b59c84216b2 48f7e9 4803d1 48c1fa07 }
            // n = 4, score = 400
            //   48b865210b59c84216b2     | inc    esp
            //   48f7e9               | add                 ecx, ecx
            //   4803d1               | dec                 ecx
            //   48c1fa07             | mov                 ecx, eax

        $sequence_4 = { 48895c2430 44897c2428 48896c2420 448bce }
            // n = 4, score = 400
            //   48895c2430           | mov                 eax, 0x590b2165
            //   44897c2428           | enter               0x1642, -0x4e
            //   48896c2420           | dec                 esp
            //   448bce               | sub                 eax, ecx

        $sequence_5 = { 4889442428 c7442420f8080000 4c8d8da0050000 41b806000000 }
            // n = 4, score = 400
            //   4889442428           | mov                 eax, 0x590b2165
            //   c7442420f8080000     | enter               0x1642, -0x4e
            //   4c8d8da0050000       | dec                 eax
            //   41b806000000         | imul                ecx

        $sequence_6 = { 488b8bc8000000 ff5350 90 488b8bd0000000 ff5350 90 488b8bd8000000 }
            // n = 7, score = 400
            // 
            //   ff5350               | call                dword ptr [ebx + 0x50]
            //   90                   | nop                 
            //   488b8bd0000000       | dec                 eax
            //   ff5350               | mov                 ecx, dword ptr [ebx + 0xd0]
            //   90                   | call                dword ptr [ebx + 0x50]
            //   488b8bd8000000       | nop                 

        $sequence_7 = { 0f118980000000 48898190000000 488d0557e5ffff 498b0b }
            // n = 4, score = 400
            //   0f118980000000       | dec                 eax
            //   48898190000000       | add                 edx, ecx
            //   488d0557e5ffff       | dec                 eax
            //   498b0b               | sar                 edx, 7

        $sequence_8 = { 8bec 81ec34040000 53 56 57 8dbdccfbffff b90d010000 }
            // n = 7, score = 200
            //   8bec                 | nop                 
            //   81ec34040000         | dec                 eax
            //   53                   | mov                 ecx, dword ptr [ebx + 0xd8]
            //   56                   | call                dword ptr [ebx + 0x50]
            //   57                   | nop                 
            //   8dbdccfbffff         | dec                 eax
            //   b90d010000           | mov                 ecx, dword ptr [ebx + 0xe0]

        $sequence_9 = { 8b8d90fcffff 51 e8???????? 83c40c 8bf4 }
            // n = 5, score = 200
            //   8b8d90fcffff         | dec                 eax
            //   51                   | shr                 eax, 0x3f
            //   e8????????           |                     
            //   83c40c               | dec                 eax
            //   8bf4                 | mov                 dword ptr [esp + 0x28], eax

        $sequence_10 = { 7320 8b859cfcffff 0fb68c05a8fcffff 83f104 8b959cfcffff }
            // n = 5, score = 200
            //   7320                 | mov                 ecx, dword ptr [ebx]
            //   8b859cfcffff         | dec                 eax
            //   0fb68c05a8fcffff     | mov                 ecx, dword ptr [ebx + 0xd0]
            //   83f104               | call                dword ptr [ebx + 0x50]
            //   8b959cfcffff         | nop                 

        $sequence_11 = { 8b4dfc 33cd e8???????? 81c434040000 3bec }
            // n = 5, score = 200
            //   8b4dfc               | call                dword ptr [ebx + 0x50]
            //   33cd                 | nop                 
            //   e8????????           |                     
            //   81c434040000         | dec                 eax
            //   3bec                 | mov                 ecx, dword ptr [ebx + 0xd8]

        $sequence_12 = { 8bf4 ff9590fcffff 3bf4 e8???????? 33c0 52 8bcd }
            // n = 7, score = 200
            //   8bf4                 | dec                 ecx
            //   ff9590fcffff         | add                 edx, eax
            //   3bf4                 | dec                 eax
            //   e8????????           |                     
            //   33c0                 | sar                 edx, 7
            //   52                   | dec                 eax
            //   8bcd                 | mov                 eax, edx

        $sequence_13 = { 8dbdccfbffff b90d010000 b8cccccccc f3ab a1???????? 33c5 8945fc }
            // n = 7, score = 200
            //   8dbdccfbffff         | mov                 dword ptr [esp + 0x20], 0x8f8
            //   b90d010000           | dec                 esp
            //   b8cccccccc           | lea                 ecx, [ebp + 0x5a0]
            //   f3ab                 | inc                 ecx
            //   a1????????           |                     
            //   33c5                 | mov                 eax, 6
            //   8945fc               | movups              xmmword ptr [ecx + 0x80], xmm1

        $sequence_14 = { a1???????? a3???????? a1???????? c705????????2a134100 }
            // n = 4, score = 200
            //   a1????????           |                     
            //   a3????????           |                     
            //   a1????????           |                     
            //   c705????????2a134100     |     

        $sequence_15 = { c705????????2a134100 8935???????? a3???????? ff15???????? a3???????? 83f8ff 0f84c1000000 }
            // n = 7, score = 200
            //   c705????????2a134100     |     
            //   8935????????         |                     
            //   a3????????           |                     
            //   ff15????????         |                     
            //   a3????????           |                     
            //   83f8ff               | mov                 dword ptr [esp + 0x20], ebp
            //   0f84c1000000         | inc                 esp

        $sequence_16 = { e8???????? c70016000000 e8???????? ebb4 c745e4700a4100 a1???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   c70016000000         | mov                 dword ptr [eax], 0x16
            //   e8????????           |                     
            //   ebb4                 | jmp                 0xffffffb6
            //   c745e4700a4100       | mov                 dword ptr [ebp - 0x1c], 0x410a70
            //   a1????????           |                     

        $sequence_17 = { 83e908 8d7608 660fd60f 8d7f08 8b048de81f4000 }
            // n = 5, score = 100
            //   83e908               | sub                 ecx, 8
            //   8d7608               | lea                 esi, [esi + 8]
            //   660fd60f             | movq                qword ptr [edi], xmm1
            //   8d7f08               | lea                 edi, [edi + 8]
            //   8b048de81f4000       | mov                 eax, dword ptr [ecx*4 + 0x401fe8]

        $sequence_18 = { 59 8365fc00 8b049d601c4100 f644380401 740b }
            // n = 5, score = 100
            //   59                   | pop                 ecx
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   8b049d601c4100       | mov                 eax, dword ptr [ebx*4 + 0x411c60]
            //   f644380401           | test                byte ptr [eax + edi + 4], 1
            //   740b                 | je                  0xd

        $sequence_19 = { c3 8b04c53cb04000 5d c3 55 8bec }
            // n = 6, score = 100
            //   c3                   | ret                 
            //   8b04c53cb04000       | mov                 eax, dword ptr [eax*8 + 0x40b03c]
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp

        $sequence_20 = { 33f6 e8???????? 83c404 8bf8 6800100000 }
            // n = 5, score = 100
            //   33f6                 | xor                 esi, esi
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8bf8                 | mov                 edi, eax
            //   6800100000           | push                0x1000

        $sequence_21 = { 8d44242c 50 57 46 ffd3 85c0 75f3 }
            // n = 7, score = 100
            //   8d44242c             | lea                 eax, [esp + 0x2c]
            //   50                   | push                eax
            //   57                   | push                edi
            //   46                   | inc                 esi
            //   ffd3                 | call                ebx
            //   85c0                 | test                eax, eax
            //   75f3                 | jne                 0xfffffff5

        $sequence_22 = { 888690f54000 46 ebe5 ff35???????? }
            // n = 4, score = 100
            //   888690f54000         | mov                 byte ptr [esi + 0x40f590], al
            //   46                   | inc                 esi
            //   ebe5                 | jmp                 0xffffffe7
            //   ff35????????         |                     

        $sequence_23 = { 8b04b5601c4100 0500080000 3bc8 7324 66c74104000a }
            // n = 5, score = 100
            //   8b04b5601c4100       | mov                 eax, dword ptr [esi*4 + 0x411c60]
            //   0500080000           | add                 eax, 0x800
            //   3bc8                 | cmp                 ecx, eax
            //   7324                 | jae                 0x26
            //   66c74104000a         | mov                 word ptr [ecx + 4], 0xa00

    condition:
        7 of them and filesize < 479232
}