rule win_dlrat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dlrat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dlrat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488d0de60b1600 e8???????? 488975b0 4989d9 4531c0 baaa020000 488d0dcb0b1600 }
            // n = 7, score = 100
            //   488d0de60b1600       | cmp                 dword ptr [ecx], eax
            //   e8????????           |                     
            //   488975b0             | cmp                 eax, 1
            //   4989d9               | jne                 0x12da
            //   4531c0               | dec                 eax
            //   baaa020000           | mov                 eax, dword ptr [ebp + 0x30]
            //   488d0dcb0b1600       | dec                 eax

        $sequence_1 = { 488d1df28e0500 48895dc8 48c745c011000000 488d55c0 488d0dcb8e0500 48894dd8 48c745d009000000 }
            // n = 7, score = 100
            //   488d1df28e0500       | dec                 eax
            //   48895dc8             | lea                 ecx, [0xb740f]
            //   48c745c011000000     | dec                 eax
            //   488d55c0             | sub                 ecx, edx
            //   488d0dcb8e0500       | dec                 eax
            //   48894dd8             | mov                 dword ptr [ebp - 0x10], ecx
            //   48c745d009000000     | dec                 esp

        $sequence_2 = { e8???????? 85c0 7818 3de4000000 7311 4898 488d0d723b0100 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   85c0                 | dec                 eax
            //   7818                 | lea                 ebx, [0x1642bb]
            //   3de4000000           | dec                 eax
            //   7311                 | mov                 dword ptr [ebp - 0x88], ebx
            //   4898                 | dec                 eax
            //   488d0d723b0100       | mov                 dword ptr [ebp - 0x90], 0x2c

        $sequence_3 = { e8???????? 83fb01 7754 488d05aa270b00 488945a8 48c745a000000000 488d55a0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83fb01               | lea                 ecx, [ebp - 0x90]
            //   7754                 | dec                 eax
            //   488d05aa270b00       | mov                 dword ptr [ebp - 0xa0], eax
            //   488945a8             | dec                 eax
            //   48c745a000000000     | mov                 dword ptr [ebp - 0x98], edx
            //   488d55a0             | dec                 eax

        $sequence_4 = { 48ffc0 482bd8 48899df0fcffff 488b9de8fcffff 4803d8 48899df8fcffff 488d0513701600 }
            // n = 7, score = 100
            //   48ffc0               | mov                 dword ptr [ebp - 0xe08], ecx
            //   482bd8               | dec                 eax
            //   48899df0fcffff       | mov                 dword ptr [ebp - 0xe10], 4
            //   488b9de8fcffff       | dec                 eax
            //   4803d8               | lea                 edx, [ebp - 0xe10]
            //   48899df8fcffff       | dec                 eax
            //   488d0513701600       | mov                 dword ptr [ebp - 0x1410], edx

        $sequence_5 = { 488b8d20ffffff 4883ec20 e8???????? 4883c420 4889c2 488d0de71f1800 4883ec20 }
            // n = 7, score = 100
            //   488b8d20ffffff       | lea                 ecx, [0x58ecb]
            //   4883ec20             | dec                 esp
            //   e8????????           |                     
            //   4883c420             | lea                 eax, [ebp - 0x50]
            //   4889c2               | dec                 eax
            //   488d0de71f1800       | lea                 ebx, [0x116cf9]
            //   4883ec20             | dec                 eax

        $sequence_6 = { 41c64424076c 41c644240863 41c644240979 41c644240a39 41c644240b6f 41c644240c5a 41c644240d57 }
            // n = 7, score = 100
            //   41c64424076c         | test                eax, eax
            //   41c644240863         | jne                 0x14b
            //   41c644240979         | dec                 eax
            //   41c644240a39         | mov                 dword ptr [ebp - 0x20], 0x48
            //   41c644240b6f         | inc                 ecx
            //   41c644240c5a         | mov                 ecx, 1
            //   41c644240d57         | dec                 eax

        $sequence_7 = { 488b03 488985a0fcffff 488995a8fcffff 488b3d???????? 488b97b0000000 488b87a8000000 488985b0fcffff }
            // n = 7, score = 100
            //   488b03               | add                 esp, 0x20
            //   488985a0fcffff       | dec                 esp
            //   488995a8fcffff       | mov                 eax, dword ptr [ebp - 0x130]
            //   488b3d????????       |                     
            //   488b97b0000000       | dec                 eax
            //   488b87a8000000       | mov                 dword ptr [ebp - 0x128], edx
            //   488985b0fcffff       | dec                 esp

        $sequence_8 = { e8???????? 48c745b000000000 4c8bce 4c8bc3 ba2f070000 488d0d5e411500 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   48c745b000000000     | add                 byte ptr [eax], al
            //   4c8bce               | add                 byte ptr [eax - 0x73], cl
            //   4c8bc3               | or                  eax, 0xd4f05
            //   ba2f070000           | dec                 esp
            //   488d0d5e411500       | mov                 edx, dword ptr [ebp - 0x1d8]
            //   e8????????           |                     

        $sequence_9 = { ffc1 e8???????? 48894580 48895588 488d4580 48898520ffffff 488d1d6a691000 }
            // n = 7, score = 100
            //   ffc1                 | lea                 ebx, [0x1030f9]
            //   e8????????           |                     
            //   48894580             | dec                 eax
            //   48895588             | mov                 dword ptr [ebp - 0xc8], ebx
            //   488d4580             | dec                 eax
            //   48898520ffffff       | mov                 dword ptr [ebp - 0xd0], 0x49
            //   488d1d6a691000       | dec                 esp

    condition:
        7 of them and filesize < 4121600
}