rule win_dma_locker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dma_locker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dma_locker"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8bf0 85f6 0f84ab000000 e8???????? }
            // n = 5, score = 200
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   0f84ab000000         | je                  0xb1
            //   e8????????           |                     

        $sequence_1 = { 83c404 83c310 ff4c2414 89470c 8b7c2410 758d }
            // n = 6, score = 200
            //   83c404               | add                 esp, 4
            //   83c310               | add                 ebx, 0x10
            //   ff4c2414             | dec                 dword ptr [esp + 0x14]
            //   89470c               | mov                 dword ptr [edi + 0xc], eax
            //   8b7c2410             | mov                 edi, dword ptr [esp + 0x10]
            //   758d                 | jne                 0xffffff8f

        $sequence_2 = { ff15???????? 85c0 7404 c6461801 }
            // n = 4, score = 200
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7404                 | je                  6
            //   c6461801             | mov                 byte ptr [esi + 0x18], 1

        $sequence_3 = { 50 6a00 56 6a19 68fe010000 6894020000 6854010000 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   6a00                 | push                0
            //   56                   | push                esi
            //   6a19                 | push                0x19
            //   68fe010000           | push                0x1fe
            //   6894020000           | push                0x294
            //   6854010000           | push                0x154

        $sequence_4 = { 6a01 6a00 6a00 6a00 688a020000 6a00 6a00 }
            // n = 7, score = 200
            //   6a01                 | push                1
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   688a020000           | push                0x28a
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_5 = { e8???????? 8bf8 83c408 85ff 7425 8b45e4 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   83c408               | add                 esp, 8
            //   85ff                 | test                edi, edi
            //   7425                 | je                  0x27
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]

        $sequence_6 = { 53 e8???????? 84c0 744f 686c060000 e8???????? 83c404 }
            // n = 7, score = 200
            //   53                   | push                ebx
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   744f                 | je                  0x51
            //   686c060000           | push                0x66c
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_7 = { eb0e 8b4810 8b7808 bb2b000000 894df8 33f6 56 }
            // n = 7, score = 200
            //   eb0e                 | jmp                 0x10
            //   8b4810               | mov                 ecx, dword ptr [eax + 0x10]
            //   8b7808               | mov                 edi, dword ptr [eax + 8]
            //   bb2b000000           | mov                 ebx, 0x2b
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   33f6                 | xor                 esi, esi
            //   56                   | push                esi

        $sequence_8 = { 6683f87f 8d642408 0f85be730000 eb00 f30f7e442404 }
            // n = 5, score = 200
            //   6683f87f             | cmp                 ax, 0x7f
            //   8d642408             | lea                 esp, [esp + 8]
            //   0f85be730000         | jne                 0x73c4
            //   eb00                 | jmp                 2
            //   f30f7e442404         | movq                xmm0, qword ptr [esp + 4]

        $sequence_9 = { 83c408 85f6 0f840e040000 56 32db e8???????? }
            // n = 6, score = 200
            //   83c408               | add                 esp, 8
            //   85f6                 | test                esi, esi
            //   0f840e040000         | je                  0x414
            //   56                   | push                esi
            //   32db                 | xor                 bl, bl
            //   e8????????           |                     

    condition:
        7 of them and filesize < 532480
}