rule win_dnwipe_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dnwipe."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dnwipe"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 1306 16 1307 2b22 1106 }
            // n = 5, score = 100
            //   1306                 | add                 byte ptr [edx], cl
            //   16                   | jb                  0xb
            //   1307                 | add                 byte ptr [eax], al
            //   2b22                 | jo                  0xc5
            //   1106                 | sub                 dword ptr [eax], eax

        $sequence_1 = { 00 2b37 00 7e01000004 281c00000a 720f000070 }
            // n = 6, score = 100
            //   00                   | push                ss
            //   2b37                 | add                 byte ptr [eax], al
            //   00                   | or                  ch, byte ptr [edi + 0x17]
            //   7e01000004           | add                 byte ptr [eax], al
            //   281c00000a           | or                  dh, byte ptr [edx + 7]
            //   720f000070           | add                 byte ptr [eax], al

        $sequence_2 = { 00 00 2b37 00 }
            // n = 4, score = 100
            //   00                   |                     
            //   00                   |                     
            //   2b37                 |                     
            //   00                   | sub                 esi, dword ptr [edi]

        $sequence_3 = { 58 0d 09 07 8e 69 fe04 }
            // n = 7, score = 100
            //   58                   | cmp                 dh, byte ptr [ebx]
            //   0d                   | add                 dword ptr [eax], eax
            //   09                   | add                 byte ptr [ecx], dl
            //   07                   | or                  dl, byte ptr [ecx]
            //   8e                   | or                  al, 0x9a
            //   69                   | outsd               dx, dword ptr [esi]
            //   fe04                 | and                 al, 0

        $sequence_4 = { 281b00000a 00 00 00 de04 }
            // n = 5, score = 100
            //   281b00000a           | sub                 byte ptr [eax + eax], dl
            //   00                   | add                 byte ptr [edx], cl
            //   00                   | adc                 eax, dword ptr [0x13051100]
            //   00                   | push                es
            //   de04                 | sub                 byte ptr [eax], bl

        $sequence_5 = { 110c 9a 6f2400000a 7285000070 6f2900000a 3a01010000 110a }
            // n = 7, score = 100
            //   110c                 | sub                 eax, 0x110a112c
            //   9a                   | or                  al, 0x9a
            //   6f2400000a           | outsd               dx, dword ptr [esi]
            //   7285000070           | and                 al, 0
            //   6f2900000a           | add                 byte ptr [edx], cl
            //   3a01010000           | jb                  0x56
            //   110a                 | add                 byte ptr [eax], al

        $sequence_6 = { 00 2b09 00 17 }
            // n = 4, score = 100
            //   00                   | or                  al, 0x12
            //   2b09                 |                     
            //   00                   | sub                 ecx, dword ptr [ecx]
            //   17                   |                     

        $sequence_7 = { 09 1304 16 1305 2b74 }
            // n = 5, score = 100
            //   09                   | add                 dword ptr [eax], eax
            //   1304                 | adc                 dword ptr [edi + edx], ecx
            //   16                   | add                 dh, bl
            //   1305                 | add                 al, 0x26
            //   2b74                 | add                 dh, bl

        $sequence_8 = { 8e 69 3284 00 de05 26 }
            // n = 6, score = 100
            //   8e                   | jo                  0xaa
            //   69                   | sbb                 byte ptr [eax], al
            //   3284                 | add                 byte ptr [edx], cl
            //   00                   | or                  eax, dword ptr [edi]
            //   de05                 | sub                 al, 0xa
            //   26                   | add                 byte ptr [edx + 0xf], dh

        $sequence_9 = { 09 9a 732200000a 1304 07 09 9a }
            // n = 7, score = 100
            //   09                   | pop                 es
            //   9a                   | mov                 gs, word ptr [ecx - 2]
            //   732200000a           | add                 al, 0x13
            //   1304                 | push                es
            //   07                   | adc                 dword ptr [esi], eax
            //   09                   | sub                 eax, 0x7110894
            //   9a                   | lcall               0x2870:0x6b72

    condition:
        7 of them and filesize < 50176
}