rule win_donex_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.donex."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.donex"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b55c8 33f6 8bf8 0facd012 c1e70e 0bf0 c1ea12 }
            // n = 7, score = 100
            //   8b55c8               | mov                 edx, dword ptr [ebp - 0x38]
            //   33f6                 | xor                 esi, esi
            //   8bf8                 | mov                 edi, eax
            //   0facd012             | shrd                eax, edx, 0x12
            //   c1e70e               | shl                 edi, 0xe
            //   0bf0                 | or                  esi, eax
            //   c1ea12               | shr                 edx, 0x12

        $sequence_1 = { 55 8bec 8b4508 53 bb01000000 85c0 7503 }
            // n = 7, score = 100
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   53                   | push                ebx
            //   bb01000000           | mov                 ebx, 1
            //   85c0                 | test                eax, eax
            //   7503                 | jne                 5

        $sequence_2 = { 894d18 c744b30400000000 3bce 72ae 8b4508 c1e602 56 }
            // n = 7, score = 100
            //   894d18               | mov                 dword ptr [ebp + 0x18], ecx
            //   c744b30400000000     | mov                 dword ptr [ebx + esi*4 + 4], 0
            //   3bce                 | cmp                 ecx, esi
            //   72ae                 | jb                  0xffffffb0
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   c1e602               | shl                 esi, 2
            //   56                   | push                esi

        $sequence_3 = { 33c8 8b45f4 c1e808 0fb6c0 c1e108 0fb680488d4300 33c8 }
            // n = 7, score = 100
            //   33c8                 | xor                 ecx, eax
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   c1e808               | shr                 eax, 8
            //   0fb6c0               | movzx               eax, al
            //   c1e108               | shl                 ecx, 8
            //   0fb680488d4300       | movzx               eax, byte ptr [eax + 0x438d48]
            //   33c8                 | xor                 ecx, eax

        $sequence_4 = { 03c2 894db0 8bd0 8945f4 c1cf02 8bcf c1c205 }
            // n = 7, score = 100
            //   03c2                 | add                 eax, edx
            //   894db0               | mov                 dword ptr [ebp - 0x50], ecx
            //   8bd0                 | mov                 edx, eax
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   c1cf02               | ror                 edi, 2
            //   8bcf                 | mov                 ecx, edi
            //   c1c205               | rol                 edx, 5

        $sequence_5 = { 8b5508 8b7a0c 8b7210 8b4a08 8b5214 }
            // n = 5, score = 100
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b7a0c               | mov                 edi, dword ptr [edx + 0xc]
            //   8b7210               | mov                 esi, dword ptr [edx + 0x10]
            //   8b4a08               | mov                 ecx, dword ptr [edx + 8]
            //   8b5214               | mov                 edx, dword ptr [edx + 0x14]

        $sequence_6 = { 85ff 0f85d4030000 8b7de8 8d45c8 50 57 }
            // n = 6, score = 100
            //   85ff                 | test                edi, edi
            //   0f85d4030000         | jne                 0x3da
            //   8b7de8               | mov                 edi, dword ptr [ebp - 0x18]
            //   8d45c8               | lea                 eax, [ebp - 0x38]
            //   50                   | push                eax
            //   57                   | push                edi

        $sequence_7 = { 33c9 83c408 668908 8b45ec 83f803 7405 83f804 }
            // n = 7, score = 100
            //   33c9                 | xor                 ecx, ecx
            //   83c408               | add                 esp, 8
            //   668908               | mov                 word ptr [eax], cx
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   83f803               | cmp                 eax, 3
            //   7405                 | je                  7
            //   83f804               | cmp                 eax, 4

        $sequence_8 = { c1e902 f3a5 8bca 83e103 f3a4 8b7df8 4f }
            // n = 7, score = 100
            //   c1e902               | shr                 ecx, 2
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8bca                 | mov                 ecx, edx
            //   83e103               | and                 ecx, 3
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   8b7df8               | mov                 edi, dword ptr [ebp - 8]
            //   4f                   | dec                 edi

        $sequence_9 = { 740f 83fe09 740a 83fe0d 7405 83fe0a 751a }
            // n = 7, score = 100
            //   740f                 | je                  0x11
            //   83fe09               | cmp                 esi, 9
            //   740a                 | je                  0xc
            //   83fe0d               | cmp                 esi, 0xd
            //   7405                 | je                  7
            //   83fe0a               | cmp                 esi, 0xa
            //   751a                 | jne                 0x1c

    condition:
        7 of them and filesize < 505856
}