rule win_donot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.donot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.donot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c745fc00000000 8d8d98fdffff 6a00 c78598fdffff00000000 68???????? c785a8fdffff00000000 c785acfdffff0f000000 }
            // n = 7, score = 100
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   8d8d98fdffff         | lea                 ecx, [ebp - 0x268]
            //   6a00                 | push                0
            //   c78598fdffff00000000     | mov    dword ptr [ebp - 0x268], 0
            //   68????????           |                     
            //   c785a8fdffff00000000     | mov    dword ptr [ebp - 0x258], 0
            //   c785acfdffff0f000000     | mov    dword ptr [ebp - 0x254], 0xf

        $sequence_1 = { 83e63f c1ff06 6bf638 8b04bd187b0410 807c302800 7d3c e8???????? }
            // n = 7, score = 100
            //   83e63f               | and                 esi, 0x3f
            //   c1ff06               | sar                 edi, 6
            //   6bf638               | imul                esi, esi, 0x38
            //   8b04bd187b0410       | mov                 eax, dword ptr [edi*4 + 0x10047b18]
            //   807c302800           | cmp                 byte ptr [eax + esi + 0x28], 0
            //   7d3c                 | jge                 0x3e
            //   e8????????           |                     

        $sequence_2 = { c785c0fdffff00000000 c785c4fdffff07000000 668985b0fdffff 83fa10 }
            // n = 4, score = 100
            //   c785c0fdffff00000000     | mov    dword ptr [ebp - 0x240], 0
            //   c785c4fdffff07000000     | mov    dword ptr [ebp - 0x23c], 7
            //   668985b0fdffff       | mov                 word ptr [ebp - 0x250], ax
            //   83fa10               | cmp                 edx, 0x10

        $sequence_3 = { 8d4904 8a80101c0410 8841fc 83ea01 75ec 47 83eb01 }
            // n = 7, score = 100
            //   8d4904               | lea                 ecx, [ecx + 4]
            //   8a80101c0410         | mov                 al, byte ptr [eax + 0x10041c10]
            //   8841fc               | mov                 byte ptr [ecx - 4], al
            //   83ea01               | sub                 edx, 1
            //   75ec                 | jne                 0xffffffee
            //   47                   | inc                 edi
            //   83eb01               | sub                 ebx, 1

        $sequence_4 = { c78584edffff00000000 c78588edffff0f000000 c68574edffff00 e8???????? 8d8de8edffff c645fc0f 8d5101 }
            // n = 7, score = 100
            //   c78584edffff00000000     | mov    dword ptr [ebp - 0x127c], 0
            //   c78588edffff0f000000     | mov    dword ptr [ebp - 0x1278], 0xf
            //   c68574edffff00       | mov                 byte ptr [ebp - 0x128c], 0
            //   e8????????           |                     
            //   8d8de8edffff         | lea                 ecx, [ebp - 0x1218]
            //   c645fc0f             | mov                 byte ptr [ebp - 4], 0xf
            //   8d5101               | lea                 edx, [ecx + 1]

        $sequence_5 = { 8d048502000000 0bc1 8bce 50 e8???????? 32c0 e9???????? }
            // n = 7, score = 100
            //   8d048502000000       | lea                 eax, [eax*4 + 2]
            //   0bc1                 | or                  eax, ecx
            //   8bce                 | mov                 ecx, esi
            //   50                   | push                eax
            //   e8????????           |                     
            //   32c0                 | xor                 al, al
            //   e9????????           |                     

        $sequence_6 = { c645fc1a 50 e8???????? c645fc1b b8ffffff7f 8b55c8 2bc2 }
            // n = 7, score = 100
            //   c645fc1a             | mov                 byte ptr [ebp - 4], 0x1a
            //   50                   | push                eax
            //   e8????????           |                     
            //   c645fc1b             | mov                 byte ptr [ebp - 4], 0x1b
            //   b8ffffff7f           | mov                 eax, 0x7fffffff
            //   8b55c8               | mov                 edx, dword ptr [ebp - 0x38]
            //   2bc2                 | sub                 eax, edx

        $sequence_7 = { 83ec18 c645fc06 8d85c8fdffff 8bcc 50 e8???????? 8d8580fdffff }
            // n = 7, score = 100
            //   83ec18               | sub                 esp, 0x18
            //   c645fc06             | mov                 byte ptr [ebp - 4], 6
            //   8d85c8fdffff         | lea                 eax, [ebp - 0x238]
            //   8bcc                 | mov                 ecx, esp
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d8580fdffff         | lea                 eax, [ebp - 0x280]

        $sequence_8 = { 8d8598fdffff 0f438598fdffff 03f0 56 e8???????? 8b8590fdffff }
            // n = 6, score = 100
            //   8d8598fdffff         | lea                 eax, [ebp - 0x268]
            //   0f438598fdffff       | cmovae              eax, dword ptr [ebp - 0x268]
            //   03f0                 | add                 esi, eax
            //   56                   | push                esi
            //   e8????????           |                     
            //   8b8590fdffff         | mov                 eax, dword ptr [ebp - 0x270]

        $sequence_9 = { 7269 81fbffffff3f 7349 8d041b 3dffffff7f 0f8741010000 }
            // n = 6, score = 100
            //   7269                 | jb                  0x6b
            //   81fbffffff3f         | cmp                 ebx, 0x3fffffff
            //   7349                 | jae                 0x4b
            //   8d041b               | lea                 eax, [ebx + ebx]
            //   3dffffff7f           | cmp                 eax, 0x7fffffff
            //   0f8741010000         | ja                  0x147

    condition:
        7 of them and filesize < 626688
}