rule win_doorme_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.doorme."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.doorme"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 817d0063736de0 7528 48833d????????00 741e 488d0d70e50100 e8???????? 85c0 }
            // n = 7, score = 100
            //   817d0063736de0       | mov                 ecx, ebx
            //   7528                 | dec                 esp
            //   48833d????????00     |                     
            //   741e                 | mov                 eax, ebx
            //   488d0d70e50100       | dec                 eax
            //   e8????????           |                     
            //   85c0                 | add                 ebx, 0x10

        $sequence_1 = { 488bd8 488d9530010000 4883bd4801000010 480f439530010000 498b07 4c8d85e8000000 }
            // n = 6, score = 100
            //   488bd8               | lea                 ecx, [0x33b31]
            //   488d9530010000       | dec                 eax
            //   4883bd4801000010     | sub                 esp, 0x28
            //   480f439530010000     | dec                 eax
            //   498b07               | test                ecx, ecx
            //   4c8d85e8000000       | je                  0x665

        $sequence_2 = { 483bf8 7730 488d041f 48894548 488d4538 4983fe10 480f434538 }
            // n = 7, score = 100
            //   483bf8               | mov                 byte ptr [eax + ecx], al
            //   7730                 | inc                 ecx
            //   488d041f             | lea                 eax, [ecx + 2]
            //   48894548             | inc                 esp
            //   488d4538             | mov                 byte ptr [eax + ecx], al
            //   4983fe10             | inc                 ecx
            //   480f434538           | lea                 eax, [ecx + 2]

        $sequence_3 = { e8???????? 49897f10 49c747180f000000 41c60700 498b5618 4883fa10 0f82adfeffff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   49897f10             | mov                 ecx, edi
            //   49c747180f000000     | shr                 ecx, 8
            //   41c60700             | inc                 ecx
            //   498b5618             | mov                 byte ptr [esi + 2], cl
            //   4883fa10             | dec                 eax
            //   0f82adfeffff         | cmp                 dword ptr [esi + 0x18], 0x10

        $sequence_4 = { 4532d1 44881408 418d4001 440fb60c08 8d4705 4432cd }
            // n = 6, score = 100
            //   4532d1               | int3                
            //   44881408             | inc                 eax
            //   418d4001             | push                ebx
            //   440fb60c08           | dec                 eax
            //   8d4705               | sub                 esp, 0x20
            //   4432cd               | dec                 eax

        $sequence_5 = { 488bd8 4885db 488d0571b80100 488d4f58 480f44d8 488bd3 488b5c2430 }
            // n = 7, score = 100
            //   488bd8               | mov                 dword ptr [esp + ecx + 0x60], eax
            //   4885db               | dec                 eax
            //   488d0571b80100       | mov                 eax, dword ptr [esp + 0x60]
            //   488d4f58             | dec                 eax
            //   480f44d8             | arpl                word ptr [eax + 4], cx
            //   488bd3               | lea                 edx, [ecx - 0x18]
            //   488b5c2430           | mov                 dword ptr [esp + ecx + 0x5c], edx

        $sequence_6 = { 48c7c03f000000 23c1 488d0d4abb0100 f20f5904c1 f20f5804c1 660f72e406 660f73f434 }
            // n = 7, score = 100
            //   48c7c03f000000       | dec                 eax
            //   23c1                 | cmova               esi, eax
            //   488d0d4abb0100       | dec                 eax
            //   f20f5904c1           | lea                 eax, [esi + 1]
            //   f20f5804c1           | dec                 eax
            //   660f72e406           | mov                 ebp, dword ptr [ebx + 0x10]
            //   660f73f434           | dec                 eax

        $sequence_7 = { e8???????? 488b5c2430 4883c420 5f c3 4883ec28 4c8d0d0d660100 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488b5c2430           | lea                 eax, [edi + 1]
            //   4883c420             | dec                 eax
            //   5f                   | mov                 ebx, eax
            //   c3                   | dec                 eax
            //   4883ec28             | cmp                 eax, -1
            //   4c8d0d0d660100       | jne                 0xafc

        $sequence_8 = { 488d0538030300 49894408f0 488b07 4c634004 }
            // n = 4, score = 100
            //   488d0538030300       | sub                 esp, 0x20
            //   49894408f0           | dec                 eax
            //   488b07               | lea                 ebx, [0x2e43b]
            //   4c634004             | dec                 eax

        $sequence_9 = { 48894308 48895e40 48897e48 48896e50 488bce e8???????? 884658 }
            // n = 7, score = 100
            //   48894308             | je                  0x15e
            //   48895e40             | dec                 eax
            //   48897e48             | dec                 ecx
            //   48896e50             | movzx               eax, byte ptr [ecx]
            //   488bce               | cmp                 byte ptr [esp + eax + 0x30], 0
            //   e8????????           |                     
            //   884658               | jne                 0x13f

    condition:
        7 of them and filesize < 580608
}