rule win_doplugs_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.doplugs."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.doplugs"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 01fe 21f3 f7d6 21d6 09de }
            // n = 5, score = 400
            //   01fe                 | add                 esi, edi
            //   21f3                 | and                 ebx, esi
            //   f7d6                 | not                 esi
            //   21d6                 | and                 esi, edx
            //   09de                 | or                  esi, ebx

        $sequence_1 = { 83e13f c1f806 6bc938 8b0485b0390a10 0fb6440828 83e040 5d }
            // n = 7, score = 400
            //   83e13f               | and                 ecx, 0x3f
            //   c1f806               | sar                 eax, 6
            //   6bc938               | imul                ecx, ecx, 0x38
            //   8b0485b0390a10       | mov                 eax, dword ptr [eax*4 + 0x100a39b0]
            //   0fb6440828           | movzx               eax, byte ptr [eax + ecx + 0x28]
            //   83e040               | and                 eax, 0x40
            //   5d                   | pop                 ebp

        $sequence_2 = { ff15???????? 8b04bdb0390a10 834c0318ff 33c0 eb16 e8???????? c70009000000 }
            // n = 7, score = 400
            //   ff15????????         |                     
            //   8b04bdb0390a10       | mov                 eax, dword ptr [edi*4 + 0x100a39b0]
            //   834c0318ff           | or                  dword ptr [ebx + eax + 0x18], 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   eb16                 | jmp                 0x18
            //   e8????????           |                     
            //   c70009000000         | mov                 dword ptr [eax], 9

        $sequence_3 = { 6bc938 8b0485b0390a10 f644082801 7406 8b440818 5d }
            // n = 6, score = 400
            //   6bc938               | imul                ecx, ecx, 0x38
            //   8b0485b0390a10       | mov                 eax, dword ptr [eax*4 + 0x100a39b0]
            //   f644082801           | test                byte ptr [eax + ecx + 0x28], 1
            //   7406                 | je                  8
            //   8b440818             | mov                 eax, dword ptr [eax + ecx + 0x18]
            //   5d                   | pop                 ebp

        $sequence_4 = { 89d3 83e2bf f7d3 83e340 09da }
            // n = 5, score = 400
            //   89d3                 | mov                 ebx, edx
            //   83e2bf               | and                 edx, 0xffffffbf
            //   f7d3                 | not                 ebx
            //   83e340               | and                 ebx, 0x40
            //   09da                 | or                  edx, ebx

        $sequence_5 = { 57 8db8a4350a10 57 ff15???????? ff0d???????? 83ef18 }
            // n = 6, score = 400
            //   57                   | push                edi
            //   8db8a4350a10         | lea                 edi, [eax + 0x100a35a4]
            //   57                   | push                edi
            //   ff15????????         |                     
            //   ff0d????????         |                     
            //   83ef18               | sub                 edi, 0x18

        $sequence_6 = { 31c0 8b4c2414 8b542438 8b521c 29d0 }
            // n = 5, score = 400
            //   31c0                 | xor                 eax, eax
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   8b542438             | mov                 edx, dword ptr [esp + 0x38]
            //   8b521c               | mov                 edx, dword ptr [edx + 0x1c]
            //   29d0                 | sub                 eax, edx

        $sequence_7 = { 8b0c24 89ca 80e1ad f6d2 80e252 08d1 }
            // n = 6, score = 400
            //   8b0c24               | mov                 ecx, dword ptr [esp]
            //   89ca                 | mov                 edx, ecx
            //   80e1ad               | and                 cl, 0xad
            //   f6d2                 | not                 dl
            //   80e252               | and                 dl, 0x52
            //   08d1                 | or                  cl, dl

    condition:
        7 of them and filesize < 1355776
}