rule win_doublefantasy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.doublefantasy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.doublefantasy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { bfd3360000 57 6a40 8b35???????? ffd6 }
            // n = 5, score = 200
            //   bfd3360000           | mov                 edi, 0x36d3
            //   57                   | push                edi
            //   6a40                 | push                0x40
            //   8b35????????         |                     
            //   ffd6                 | call                esi

        $sequence_1 = { 8b442404 0fb608 c1e902 8a91908c2700 8b4c2408 8811 33d2 }
            // n = 7, score = 200
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   0fb608               | movzx               ecx, byte ptr [eax]
            //   c1e902               | shr                 ecx, 2
            //   8a91908c2700         | mov                 dl, byte ptr [ecx + 0x278c90]
            //   8b4c2408             | mov                 ecx, dword ptr [esp + 8]
            //   8811                 | mov                 byte ptr [ecx], dl
            //   33d2                 | xor                 edx, edx

        $sequence_2 = { e8???????? 8bcb 2bc8 51 ff7514 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   8bcb                 | mov                 ecx, ebx
            //   2bc8                 | sub                 ecx, eax
            //   51                   | push                ecx
            //   ff7514               | push                dword ptr [ebp + 0x14]

        $sequence_3 = { 50 6a00 56 8907 e8???????? 83c40c }
            // n = 6, score = 200
            //   50                   | push                eax
            //   6a00                 | push                0
            //   56                   | push                esi
            //   8907                 | mov                 dword ptr [edi], eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_4 = { 66ab be???????? 8dbd9ffaffff a5 }
            // n = 4, score = 200
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   be????????           |                     
            //   8dbd9ffaffff         | lea                 edi, [ebp - 0x561]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]

        $sequence_5 = { ff15???????? eb72 56 6a00 ff75e0 e8???????? ff75e4 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   eb72                 | jmp                 0x74
            //   56                   | push                esi
            //   6a00                 | push                0
            //   ff75e0               | push                dword ptr [ebp - 0x20]
            //   e8????????           |                     
            //   ff75e4               | push                dword ptr [ebp - 0x1c]

        $sequence_6 = { 83e20f c1e202 0bd6 8a92908c2700 eb02 b23d 837c241002 }
            // n = 7, score = 200
            //   83e20f               | and                 edx, 0xf
            //   c1e202               | shl                 edx, 2
            //   0bd6                 | or                  edx, esi
            //   8a92908c2700         | mov                 dl, byte ptr [edx + 0x278c90]
            //   eb02                 | jmp                 4
            //   b23d                 | mov                 dl, 0x3d
            //   837c241002           | cmp                 dword ptr [esp + 0x10], 2

        $sequence_7 = { ff750c ff7508 e8???????? 83c414 8945e0 }
            // n = 5, score = 200
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax

        $sequence_8 = { 8a80ad8c2700 eb02 32c0 84c0 }
            // n = 4, score = 200
            //   8a80ad8c2700         | mov                 al, byte ptr [eax + 0x278cad]
            //   eb02                 | jmp                 4
            //   32c0                 | xor                 al, al
            //   84c0                 | test                al, al

        $sequence_9 = { 891485a4ab2700 40 3bc1 72f1 }
            // n = 4, score = 200
            //   891485a4ab2700       | mov                 dword ptr [eax*4 + 0x27aba4], edx
            //   40                   | inc                 eax
            //   3bc1                 | cmp                 eax, ecx
            //   72f1                 | jb                  0xfffffff3

        $sequence_10 = { 8a92908c2700 885101 7e1c 0fb67002 33d2 8a5001 c1ee06 }
            // n = 7, score = 200
            //   8a92908c2700         | mov                 dl, byte ptr [edx + 0x278c90]
            //   885101               | mov                 byte ptr [ecx + 1], dl
            //   7e1c                 | jle                 0x1e
            //   0fb67002             | movzx               esi, byte ptr [eax + 2]
            //   33d2                 | xor                 edx, edx
            //   8a5001               | mov                 dl, byte ptr [eax + 1]
            //   c1ee06               | shr                 esi, 6

        $sequence_11 = { 8a80908c2700 eb02 b03d 884103 }
            // n = 4, score = 200
            //   8a80908c2700         | mov                 al, byte ptr [eax + 0x278c90]
            //   eb02                 | jmp                 4
            //   b03d                 | mov                 al, 0x3d
            //   884103               | mov                 byte ptr [ecx + 3], al

        $sequence_12 = { 33c0 85c9 7616 8da42400000000 8d50fd 891485a4ab2700 40 }
            // n = 7, score = 200
            //   33c0                 | xor                 eax, eax
            //   85c9                 | test                ecx, ecx
            //   7616                 | jbe                 0x18
            //   8da42400000000       | lea                 esp, [esp]
            //   8d50fd               | lea                 edx, [eax - 3]
            //   891485a4ab2700       | mov                 dword ptr [eax*4 + 0x27aba4], edx
            //   40                   | inc                 eax

        $sequence_13 = { b9d2360000 51 52 48 }
            // n = 4, score = 200
            //   b9d2360000           | mov                 ecx, 0x36d2
            //   51                   | push                ecx
            //   52                   | push                edx
            //   48                   | dec                 eax

        $sequence_14 = { c68094a3270000 ff35???????? ff35???????? e8???????? 83c414 e8???????? }
            // n = 6, score = 200
            //   c68094a3270000       | mov                 byte ptr [eax + 0x27a394], 0
            //   ff35????????         |                     
            //   ff35????????         |                     
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   e8????????           |                     

        $sequence_15 = { ff37 ff750c 8b460c 03c3 50 e8???????? }
            // n = 6, score = 200
            //   ff37                 | push                dword ptr [edi]
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   8b460c               | mov                 eax, dword ptr [esi + 0xc]
            //   03c3                 | add                 eax, ebx
            //   50                   | push                eax
            //   e8????????           |                     

    condition:
        7 of them and filesize < 172032
}