rule win_downex_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.downex."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.downex"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0fb6443b47 4b 2bf0 8d0440 8d0c82 8b84b7ec000000 8901 }
            // n = 7, score = 100
            //   0fb6443b47           | movzx               eax, byte ptr [ebx + edi + 0x47]
            //   4b                   | dec                 ebx
            //   2bf0                 | sub                 esi, eax
            //   8d0440               | lea                 eax, [eax + eax*2]
            //   8d0c82               | lea                 ecx, [edx + eax*4]
            //   8b84b7ec000000       | mov                 eax, dword ptr [edi + esi*4 + 0xec]
            //   8901                 | mov                 dword ptr [ecx], eax

        $sequence_1 = { ffb0d8f24700 e8???????? 83c40c 85c0 7419 46 8d0476 }
            // n = 7, score = 100
            //   ffb0d8f24700         | push                dword ptr [eax + 0x47f2d8]
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   7419                 | je                  0x1b
            //   46                   | inc                 esi
            //   8d0476               | lea                 eax, [esi + esi*2]

        $sequence_2 = { e8???????? 8d8d58fdffff e8???????? 8b4da4 83c148 8d4601 50 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d8d58fdffff         | lea                 ecx, [ebp - 0x2a8]
            //   e8????????           |                     
            //   8b4da4               | mov                 ecx, dword ptr [ebp - 0x5c]
            //   83c148               | add                 ecx, 0x48
            //   8d4601               | lea                 eax, [esi + 1]
            //   50                   | push                eax

        $sequence_3 = { 297e04 83c40c 013e 017e08 8b4e04 83560c00 017e10 }
            // n = 7, score = 100
            //   297e04               | sub                 dword ptr [esi + 4], edi
            //   83c40c               | add                 esp, 0xc
            //   013e                 | add                 dword ptr [esi], edi
            //   017e08               | add                 dword ptr [esi + 8], edi
            //   8b4e04               | mov                 ecx, dword ptr [esi + 4]
            //   83560c00             | adc                 dword ptr [esi + 0xc], 0
            //   017e10               | add                 dword ptr [esi + 0x10], edi

        $sequence_4 = { eb2c b9???????? eb25 b9???????? eb1e 3ddec0c5b0 7412 }
            // n = 7, score = 100
            //   eb2c                 | jmp                 0x2e
            //   b9????????           |                     
            //   eb25                 | jmp                 0x27
            //   b9????????           |                     
            //   eb1e                 | jmp                 0x20
            //   3ddec0c5b0           | cmp                 eax, 0xb0c5c0de
            //   7412                 | je                  0x14

        $sequence_5 = { 7214 83c123 8b50fc 2bc2 83c0fc 83f81f 0f87d3030000 }
            // n = 7, score = 100
            //   7214                 | jb                  0x16
            //   83c123               | add                 ecx, 0x23
            //   8b50fc               | mov                 edx, dword ptr [eax - 4]
            //   2bc2                 | sub                 eax, edx
            //   83c0fc               | add                 eax, -4
            //   83f81f               | cmp                 eax, 0x1f
            //   0f87d3030000         | ja                  0x3d9

        $sequence_6 = { ff7508 e8???????? 83c414 33d2 85c0 b900100000 0f44d1 }
            // n = 7, score = 100
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   33d2                 | xor                 edx, edx
            //   85c0                 | test                eax, eax
            //   b900100000           | mov                 ecx, 0x1000
            //   0f44d1               | cmove               edx, ecx

        $sequence_7 = { 85c0 0f85a0050000 f6872802010010 0f8407010000 8b8eb4000000 8bd1 68b5070000 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   0f85a0050000         | jne                 0x5a6
            //   f6872802010010       | test                byte ptr [edi + 0x10228], 0x10
            //   0f8407010000         | je                  0x10d
            //   8b8eb4000000         | mov                 ecx, dword ptr [esi + 0xb4]
            //   8bd1                 | mov                 edx, ecx
            //   68b5070000           | push                0x7b5

        $sequence_8 = { 50 e8???????? 68???????? 6aff ffb5f0feffff e8???????? 8bb5f8feffff }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   68????????           |                     
            //   6aff                 | push                -1
            //   ffb5f0feffff         | push                dword ptr [ebp - 0x110]
            //   e8????????           |                     
            //   8bb5f8feffff         | mov                 esi, dword ptr [ebp - 0x108]

        $sequence_9 = { e8???????? 83c410 eb1f 81e7ffffdfff f7c200002000 7411 8d45e4 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   eb1f                 | jmp                 0x21
            //   81e7ffffdfff         | and                 edi, 0xffdfffff
            //   f7c200002000         | test                edx, 0x200000
            //   7411                 | je                  0x13
            //   8d45e4               | lea                 eax, [ebp - 0x1c]

    condition:
        7 of them and filesize < 1067008
}