rule win_dragonbreath_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dragonbreath."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dragonbreath"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c410 eb14 8d8590fdffff 50 }
            // n = 4, score = 100
            //   83c410               | add                 esp, 0x10
            //   eb14                 | jmp                 0x16
            //   8d8590fdffff         | lea                 eax, [ebp - 0x270]
            //   50                   | push                eax

        $sequence_1 = { 68???????? 8d4da8 51 e8???????? 8b7de4 }
            // n = 5, score = 100
            //   68????????           |                     
            //   8d4da8               | lea                 ecx, [ebp - 0x58]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8b7de4               | mov                 edi, dword ptr [ebp - 0x1c]

        $sequence_2 = { 8b5dd0 ebab c745e470820110 817de47c820110 7311 }
            // n = 5, score = 100
            //   8b5dd0               | mov                 ebx, dword ptr [ebp - 0x30]
            //   ebab                 | jmp                 0xffffffad
            //   c745e470820110       | mov                 dword ptr [ebp - 0x1c], 0x10018270
            //   817de47c820110       | cmp                 dword ptr [ebp - 0x1c], 0x1001827c
            //   7311                 | jae                 0x13

        $sequence_3 = { 33db 8945c8 895dcc 895dd0 c745e80f000000 895de4 885dd4 }
            // n = 7, score = 100
            //   33db                 | xor                 ebx, ebx
            //   8945c8               | mov                 dword ptr [ebp - 0x38], eax
            //   895dcc               | mov                 dword ptr [ebp - 0x34], ebx
            //   895dd0               | mov                 dword ptr [ebp - 0x30], ebx
            //   c745e80f000000       | mov                 dword ptr [ebp - 0x18], 0xf
            //   895de4               | mov                 dword ptr [ebp - 0x1c], ebx
            //   885dd4               | mov                 byte ptr [ebp - 0x2c], bl

        $sequence_4 = { 2bcf b879787878 f7e9 c1fa07 8bf2 }
            // n = 5, score = 100
            //   2bcf                 | sub                 ecx, edi
            //   b879787878           | mov                 eax, 0x78787879
            //   f7e9                 | imul                ecx
            //   c1fa07               | sar                 edx, 7
            //   8bf2                 | mov                 esi, edx

        $sequence_5 = { 8dbd84fcffff 68ff010000 f3a5 8d8df5fdffff 6a00 51 }
            // n = 6, score = 100
            //   8dbd84fcffff         | lea                 edi, [ebp - 0x37c]
            //   68ff010000           | push                0x1ff
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8d8df5fdffff         | lea                 ecx, [ebp - 0x20b]
            //   6a00                 | push                0
            //   51                   | push                ecx

        $sequence_6 = { c1e006 8b0c8d80fb0110 8d440104 8020fe ff36 e8???????? 59 }
            // n = 7, score = 100
            //   c1e006               | shl                 eax, 6
            //   8b0c8d80fb0110       | mov                 ecx, dword ptr [ecx*4 + 0x1001fb80]
            //   8d440104             | lea                 eax, [ecx + eax + 4]
            //   8020fe               | and                 byte ptr [eax], 0xfe
            //   ff36                 | push                dword ptr [esi]
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_7 = { e8???????? 85ff 7407 57 ff15???????? 8b8558fdffff 8b4df0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   85ff                 | test                edi, edi
            //   7407                 | je                  9
            //   57                   | push                edi
            //   ff15????????         |                     
            //   8b8558fdffff         | mov                 eax, dword ptr [ebp - 0x2a8]
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]

        $sequence_8 = { 51 ff15???????? 46 3bb424dc110000 72e8 e9???????? }
            // n = 6, score = 100
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   46                   | inc                 esi
            //   3bb424dc110000       | cmp                 esi, dword ptr [esp + 0x11dc]
            //   72e8                 | jb                  0xffffffea
            //   e9????????           |                     

        $sequence_9 = { 8bd6 69d200a4d9fa 03ca b8b17c2195 f7e1 8bda c1eb15 }
            // n = 7, score = 100
            //   8bd6                 | mov                 edx, esi
            //   69d200a4d9fa         | imul                edx, edx, 0xfad9a400
            //   03ca                 | add                 ecx, edx
            //   b8b17c2195           | mov                 eax, 0x95217cb1
            //   f7e1                 | mul                 ecx
            //   8bda                 | mov                 ebx, edx
            //   c1eb15               | shr                 ebx, 0x15

    condition:
        7 of them and filesize < 295936
}