rule win_dragonforce_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dragonforce."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dragonforce"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83ff01 7564 c745fc???????? bb???????? }
            // n = 4, score = 100
            //   83ff01               | cmp                 edi, 1
            //   7564                 | jne                 0x66
            //   c745fc????????       |                     
            //   bb????????           |                     

        $sequence_1 = { 83c608 897dec 8b0481 8bc8 }
            // n = 4, score = 100
            //   83c608               | add                 esi, 8
            //   897dec               | mov                 dword ptr [ebp - 0x14], edi
            //   8b0481               | mov                 eax, dword ptr [ecx + eax*4]
            //   8bc8                 | mov                 ecx, eax

        $sequence_2 = { 88943d09fdffff 47 83ff42 72d6 }
            // n = 4, score = 100
            //   88943d09fdffff       | mov                 byte ptr [ebp + edi - 0x2f7], dl
            //   47                   | inc                 edi
            //   83ff42               | cmp                 edi, 0x42
            //   72d6                 | jb                  0xffffffd8

        $sequence_3 = { 6690 85db 0f844ef4ffff 0fb607 }
            // n = 4, score = 100
            //   6690                 | nop                 
            //   85db                 | test                ebx, ebx
            //   0f844ef4ffff         | je                  0xfffff454
            //   0fb607               | movzx               eax, byte ptr [edi]

        $sequence_4 = { 8a85a9fcffff e8???????? 8985e0f5ffff 8d8d9cfcffff }
            // n = 4, score = 100
            //   8a85a9fcffff         | mov                 al, byte ptr [ebp - 0x357]
            //   e8????????           |                     
            //   8985e0f5ffff         | mov                 dword ptr [ebp - 0xa20], eax
            //   8d8d9cfcffff         | lea                 ecx, [ebp - 0x364]

        $sequence_5 = { 6a00 6a00 6a01 8d85dcfdffff }
            // n = 4, score = 100
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a01                 | push                1
            //   8d85dcfdffff         | lea                 eax, [ebp - 0x224]

        $sequence_6 = { c6459002 c6459173 c6459202 c6459365 }
            // n = 4, score = 100
            //   c6459002             | mov                 byte ptr [ebp - 0x70], 2
            //   c6459173             | mov                 byte ptr [ebp - 0x6f], 0x73
            //   c6459202             | mov                 byte ptr [ebp - 0x6e], 2
            //   c6459365             | mov                 byte ptr [ebp - 0x6d], 0x65

        $sequence_7 = { c644243145 c64424323c c644243369 c64424343c }
            // n = 4, score = 100
            //   c644243145           | mov                 byte ptr [esp + 0x31], 0x45
            //   c64424323c           | mov                 byte ptr [esp + 0x32], 0x3c
            //   c644243369           | mov                 byte ptr [esp + 0x33], 0x69
            //   c64424343c           | mov                 byte ptr [esp + 0x34], 0x3c

    condition:
        7 of them and filesize < 879616
}