rule win_dramnudge_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dramnudge."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dramnudge"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 014218 eb18 03c3 8bd3 }
            // n = 4, score = 100
            //   014218               | add                 dword ptr [edx + 0x18], eax
            //   eb18                 | jmp                 0x1a
            //   03c3                 | add                 eax, ebx
            //   8bd3                 | mov                 edx, ebx

        $sequence_1 = { 000c00 20b140005f5f 7277 7374 }
            // n = 4, score = 100
            //   000c00               | add                 byte ptr [eax + eax], cl
            //   20b140005f5f         | and                 byte ptr [ecx + 0x5f5f0040], dh
            //   7277                 | jb                  0x79
            //   7374                 | jae                 0x76

        $sequence_2 = { 014318 8b430c 2b4308 03c6 }
            // n = 4, score = 100
            //   014318               | add                 dword ptr [ebx + 0x18], eax
            //   8b430c               | mov                 eax, dword ptr [ebx + 0xc]
            //   2b4308               | sub                 eax, dword ptr [ebx + 8]
            //   03c6                 | add                 eax, esi

        $sequence_3 = { 000c00 e0d9 40 007374 }
            // n = 4, score = 100
            //   000c00               | add                 byte ptr [eax + eax], cl
            //   e0d9                 | loopne              0xffffffdb
            //   40                   | inc                 eax
            //   007374               | add                 byte ptr [ebx + 0x74], dh

        $sequence_4 = { 014318 8b4318 8b55f8 03d6 }
            // n = 4, score = 100
            //   014318               | add                 dword ptr [ebx + 0x18], eax
            //   8b4318               | mov                 eax, dword ptr [ebx + 0x18]
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   03d6                 | add                 edx, esi

        $sequence_5 = { 007374 643a3a 7275 6e }
            // n = 4, score = 100
            //   007374               | add                 byte ptr [ebx + 0x74], dh
            //   643a3a               | cmp                 bh, byte ptr fs:[edx]
            //   7275                 | jb                  0x77
            //   6e                   | outsb               dx, byte ptr [esi]

        $sequence_6 = { 0000 90 000c00 20b140005f5f }
            // n = 4, score = 100
            //   0000                 | add                 byte ptr [eax], al
            //   90                   | nop                 
            //   000c00               | add                 byte ptr [eax + eax], cl
            //   20b140005f5f         | and                 byte ptr [ecx + 0x5f5f0040], dh

        $sequence_7 = { 014318 eb5b 33f6 eb01 }
            // n = 4, score = 100
            //   014318               | add                 dword ptr [ebx + 0x18], eax
            //   eb5b                 | jmp                 0x5d
            //   33f6                 | xor                 esi, esi
            //   eb01                 | jmp                 3

    condition:
        7 of them and filesize < 1294336
}