rule win_dratzarus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dratzarus."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dratzarus"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c7850002000016bc0b71 c78504020000128aa4ac c785080200000fa52ff4 c7850c020000421880f6 c7851002000023121336 }
            // n = 5, score = 200
            //   c7850002000016bc0b71     | dec    eax
            //   c78504020000128aa4ac     | mov    ecx, edi
            //   c785080200000fa52ff4     | mov    dword ptr [esp + 0x44], 2
            //   c7850c020000421880f6     | dec    esp
            //   c7851002000023121336     | lea    ecx, [0x97e60]

        $sequence_1 = { c7852802000014a20b6d c7852c02000012d8a499 c785300200000fa32ffa c78534020000420d80c7 c78538020000230a133f 66c7853c0200003e85 }
            // n = 6, score = 200
            //   c7852802000014a20b6d     | jb    0xdb0
            //   c7852c02000012d8a499     | inc    ecx
            //   c785300200000fa32ffa     | cmp    ebp, 3
            //   c78534020000420d80c7     | jb    0xdd0
            //   c78538020000230a133f     | mov    edx, 1
            //   66c7853c0200003e85     | inc    esp

        $sequence_2 = { 894511 66894515 8b05???????? 894517 0fb705???????? 6689451b }
            // n = 6, score = 200
            //   894511               | xor                 edx, edx
            //   66894515             | inc                 ecx
            //   8b05????????         |                     
            //   894517               | mov                 eax, 0x101
            //   0fb705????????       |                     
            //   6689451b             | dec                 esp

        $sequence_3 = { 6689440afe 6685c0 75ef 33c0 4883c9ff 488dbc2480060000 }
            // n = 6, score = 200
            //   6689440afe           | test                eax, eax
            //   6685c0               | jne                 0x144a
            //   75ef                 | dec                 eax
            //   33c0                 | mov                 ecx, dword ptr [edi + 8]
            //   4883c9ff             | test                eax, eax
            //   488dbc2480060000     | jne                 0xb5b

        $sequence_4 = { 488d8de0000000 ba0f000000 488905???????? e8???????? 488bcb 488bd0 ff15???????? }
            // n = 7, score = 200
            //   488d8de0000000       | dec                 eax
            //   ba0f000000           | imul                ebx, ebx, 0x58
            //   488905????????       |                     
            //   e8????????           |                     
            //   488bcb               | dec                 ebx
            //   488bd0               | mov                 esi, dword ptr [esi]
            //   ff15????????         |                     

        $sequence_5 = { bf01000000 488bcb ff15???????? 8bc7 488b8c2460020000 4833cc e8???????? }
            // n = 7, score = 200
            //   bf01000000           | shr                 edx, cl
            //   488bcb               | test                dl, 1
            //   ff15????????         |                     
            //   8bc7                 | je                  0x7cb
            //   488b8c2460020000     | inc                 esp
            //   4833cc               | lea                 eax, [ecx + 0x41]
            //   e8????????           |                     

        $sequence_6 = { c74424306133dc18 c7442434679eb315 66c744243876d4 c785e0000000eb6cf5c3 }
            // n = 4, score = 200
            //   c74424306133dc18     | dec                 eax
            //   c7442434679eb315     | lea                 edx, [0x34e82]
            //   66c744243876d4       | inc                 esp
            //   c785e0000000eb6cf5c3     | mov    eax, eax

        $sequence_7 = { c7450c4b676e4a c745101d29ecd4 c745142daca8b6 c64518f2 c785800000005e7c6d4c c78584000000747e6447 c785880000003134f9ef }
            // n = 7, score = 200
            //   c7450c4b676e4a       | dec                 eax
            //   c745101d29ecd4       | mov                 edi, eax
            //   c745142daca8b6       | dec                 ebp
            //   c64518f2             | test                edi, edi
            //   c785800000005e7c6d4c     | jne    0x1f7a
            //   c78584000000747e6447     | inc    ebp
            //   c785880000003134f9ef     | mov    ecx, esp

        $sequence_8 = { 89842454020000 e8???????? b902000000 8d5701 4533c0 }
            // n = 5, score = 200
            //   89842454020000       | dec                 eax
            //   e8????????           |                     
            //   b902000000           | mov                 ebx, ecx
            //   8d5701               | dec                 eax
            //   4533c0               | mov                 ecx, dword ptr [edx]

        $sequence_9 = { 488bd0 ff15???????? 488d8da0020000 ba14000000 488905???????? e8???????? 488bd0 }
            // n = 7, score = 200
            //   488bd0               | dec                 esp
            //   ff15????????         |                     
            //   488d8da0020000       | mov                 esp, edx
            //   ba14000000           | dec                 eax
            //   488905????????       |                     
            //   e8????????           |                     
            //   488bd0               | lea                 edx, [0x43e64]

    condition:
        7 of them and filesize < 1606656
}