rule win_dridex_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dridex."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dridex"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffd6 85c0 7512 e8???????? eb03 }
            // n = 5, score = 4000
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   7512                 | jne                 0x14
            //   e8????????           |                     
            //   eb03                 | jmp                 5

        $sequence_1 = { e8???????? b910270000 e8???????? e8???????? }
            // n = 4, score = 4000
            //   e8????????           |                     
            //   b910270000           | mov                 ecx, 0x2710
            //   e8????????           |                     
            //   e8????????           |                     

        $sequence_2 = { c605????????01 c3 c605????????00 c3 }
            // n = 4, score = 3900
            //   c605????????01       |                     
            //   c3                   | ret                 
            //   c605????????00       |                     
            //   c3                   | ret                 

        $sequence_3 = { 83f8ff 7505 e8???????? 3d34270000 }
            // n = 4, score = 3900
            //   83f8ff               | cmp                 eax, -1
            //   7505                 | jne                 7
            //   e8????????           |                     
            //   3d34270000           | cmp                 eax, 0x2734

        $sequence_4 = { ffd0 e8???????? 85c0 74de }
            // n = 4, score = 3800
            //   ffd0                 | call                eax
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   74de                 | je                  0xffffffe0

        $sequence_5 = { ffd0 85c0 751f e8???????? }
            // n = 4, score = 3800
            //   ffd0                 | call                eax
            //   85c0                 | test                eax, eax
            //   751f                 | jne                 0x21
            //   e8????????           |                     

        $sequence_6 = { 740c b9e8030000 e8???????? b301 }
            // n = 4, score = 3800
            //   740c                 | je                  0xe
            //   b9e8030000           | mov                 ecx, 0x3e8
            //   e8????????           |                     
            //   b301                 | mov                 bl, 1

        $sequence_7 = { 53 53 53 6a01 53 ffd0 }
            // n = 6, score = 3500
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   6a01                 | push                1
            //   53                   | push                ebx
            //   ffd0                 | call                eax

        $sequence_8 = { eb0a e8???????? eb03 6a7f }
            // n = 4, score = 3000
            //   eb0a                 | jmp                 0xc
            //   e8????????           |                     
            //   eb03                 | jmp                 5
            //   6a7f                 | push                0x7f

        $sequence_9 = { c3 31c0 c3 50 }
            // n = 4, score = 2500
            //   c3                   | ret                 
            //   31c0                 | xor                 eax, eax
            //   c3                   | ret                 
            //   50                   | push                eax

        $sequence_10 = { e8???????? 85c0 7407 56 ffd0 }
            // n = 5, score = 2400
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7407                 | je                  9
            //   56                   | push                esi
            //   ffd0                 | call                eax

        $sequence_11 = { 807c241400 7409 8d4c2410 e8???????? }
            // n = 4, score = 2400
            //   807c241400           | cmp                 byte ptr [esp + 0x14], 0
            //   7409                 | je                  0xb
            //   8d4c2410             | lea                 ecx, [esp + 0x10]
            //   e8????????           |                     

        $sequence_12 = { e8???????? 6880000000 53 53 }
            // n = 4, score = 2300
            //   e8????????           |                     
            //   6880000000           | push                0x80
            //   53                   | push                ebx
            //   53                   | push                ebx

        $sequence_13 = { e8???????? 85c0 7408 6a00 ffd0 }
            // n = 5, score = 2300
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7408                 | je                  0xa
            //   6a00                 | push                0
            //   ffd0                 | call                eax

        $sequence_14 = { 85c0 7407 685a040000 ffd0 }
            // n = 4, score = 2200
            //   85c0                 | test                eax, eax
            //   7407                 | je                  9
            //   685a040000           | push                0x45a
            //   ffd0                 | call                eax

        $sequence_15 = { e8???????? 85c0 7404 6a7f }
            // n = 4, score = 2200
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7404                 | je                  6
            //   6a7f                 | push                0x7f

        $sequence_16 = { e8???????? 3db20d7897 7508 c70350000000 eb0d 3da665f63e 7506 }
            // n = 7, score = 2200
            //   e8????????           |                     
            //   3db20d7897           | cmp                 eax, 0x97780db2
            //   7508                 | jne                 0xa
            //   c70350000000         | mov                 dword ptr [ebx], 0x50
            //   eb0d                 | jmp                 0xf
            //   3da665f63e           | cmp                 eax, 0x3ef665a6
            //   7506                 | jne                 8

        $sequence_17 = { ffd0 5b c3 33c0 }
            // n = 4, score = 2200
            //   ffd0                 | call                eax
            //   5b                   | pop                 ebx
            //   c3                   | ret                 
            //   33c0                 | xor                 eax, eax

        $sequence_18 = { e8???????? 6a00 8d4e1c e8???????? }
            // n = 4, score = 2200
            //   e8????????           |                     
            //   6a00                 | push                0
            //   8d4e1c               | lea                 ecx, [esi + 0x1c]
            //   e8????????           |                     

        $sequence_19 = { e8???????? eb0a b9d0070000 e8???????? }
            // n = 4, score = 2200
            //   e8????????           |                     
            //   eb0a                 | jmp                 0xc
            //   b9d0070000           | mov                 ecx, 0x7d0
            //   e8????????           |                     

        $sequence_20 = { e8???????? 6a29 8bc8 e8???????? }
            // n = 4, score = 2100
            //   e8????????           |                     
            //   6a29                 | push                0x29
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     

        $sequence_21 = { 7411 c7461003000000 e8???????? 894614 }
            // n = 4, score = 2100
            //   7411                 | je                  0x13
            //   c7461003000000       | mov                 dword ptr [esi + 0x10], 3
            //   e8????????           |                     
            //   894614               | mov                 dword ptr [esi + 0x14], eax

        $sequence_22 = { e8???????? 8d4dc4 e8???????? 5e }
            // n = 4, score = 2100
            //   e8????????           |                     
            //   8d4dc4               | lea                 ecx, [ebp - 0x3c]
            //   e8????????           |                     
            //   5e                   | pop                 esi

        $sequence_23 = { 85c0 7415 6a01 6a00 6a00 }
            // n = 5, score = 2100
            //   85c0                 | test                eax, eax
            //   7415                 | je                  0x17
            //   6a01                 | push                1
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_24 = { 8bc8 e8???????? 6a74 8bc8 e8???????? 6a70 }
            // n = 6, score = 2100
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   6a74                 | push                0x74
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   6a70                 | push                0x70

        $sequence_25 = { 6a70 8bc8 e8???????? 6a73 8bc8 e8???????? }
            // n = 6, score = 2100
            //   6a70                 | push                0x70
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   6a73                 | push                0x73
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     

        $sequence_26 = { eb08 83ca20 eb03 83ca10 }
            // n = 4, score = 2100
            //   eb08                 | jmp                 0xa
            //   83ca20               | or                  edx, 0x20
            //   eb03                 | jmp                 5
            //   83ca10               | or                  edx, 0x10

        $sequence_27 = { 6a00 8bcf e8???????? 50 ffd6 }
            // n = 5, score = 2100
            //   6a00                 | push                0
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   50                   | push                eax
            //   ffd6                 | call                esi

        $sequence_28 = { e8???????? e9???????? 807c245000 740a }
            // n = 4, score = 2100
            //   e8????????           |                     
            //   e9????????           |                     
            //   807c245000           | cmp                 byte ptr [esp + 0x50], 0
            //   740a                 | je                  0xc

        $sequence_29 = { 46 e8???????? c1e802 3bf0 }
            // n = 4, score = 2100
            //   46                   | inc                 esi
            //   e8????????           |                     
            //   c1e802               | shr                 eax, 2
            //   3bf0                 | cmp                 esi, eax

        $sequence_30 = { 6a00 6a00 8d4dfc 51 6aff }
            // n = 5, score = 2100
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8d4dfc               | lea                 ecx, [ebp - 4]
            //   51                   | push                ecx
            //   6aff                 | push                -1

        $sequence_31 = { 890424 894c2404 75dd 8b0424 }
            // n = 4, score = 2000
            //   890424               | mov                 dword ptr [esp], eax
            //   894c2404             | mov                 dword ptr [esp + 4], ecx
            //   75dd                 | jne                 0xffffffdf
            //   8b0424               | mov                 eax, dword ptr [esp]

        $sequence_32 = { 89c1 8b442424 88c2 8854240f }
            // n = 4, score = 2000
            //   89c1                 | mov                 ecx, eax
            //   8b442424             | mov                 eax, dword ptr [esp + 0x24]
            //   88c2                 | mov                 dl, al
            //   8854240f             | mov                 byte ptr [esp + 0xf], dl

        $sequence_33 = { 8b442428 6689c1 66894c2458 66894c245a }
            // n = 4, score = 2000
            //   8b442428             | mov                 eax, dword ptr [esp + 0x28]
            //   6689c1               | mov                 cx, ax
            //   66894c2458           | mov                 word ptr [esp + 0x58], cx
            //   66894c245a           | mov                 word ptr [esp + 0x5a], cx

        $sequence_34 = { 6a64 59 e8???????? 33c9 }
            // n = 4, score = 2000
            //   6a64                 | push                0x64
            //   59                   | pop                 ecx
            //   e8????????           |                     
            //   33c9                 | xor                 ecx, ecx

        $sequence_35 = { 33c0 803900 7411 ffc0 }
            // n = 4, score = 2000
            //   33c0                 | xor                 eax, eax
            //   803900               | cmp                 byte ptr [ecx], 0
            //   7411                 | je                  0x13
            //   ffc0                 | inc                 eax

        $sequence_36 = { c7461002000000 eb0f c7461003000000 e8???????? }
            // n = 4, score = 2000
            //   c7461002000000       | mov                 dword ptr [esi + 0x10], 2
            //   eb0f                 | jmp                 0x11
            //   c7461003000000       | mov                 dword ptr [esi + 0x10], 3
            //   e8????????           |                     

        $sequence_37 = { 8a442427 a801 7534 eb00 31c0 }
            // n = 5, score = 2000
            //   8a442427             | mov                 al, byte ptr [esp + 0x27]
            //   a801                 | test                al, 1
            //   7534                 | jne                 0x36
            //   eb00                 | jmp                 2
            //   31c0                 | xor                 eax, eax

        $sequence_38 = { 7414 31c0 89c1 8b442424 }
            // n = 4, score = 2000
            //   7414                 | je                  0x16
            //   31c0                 | xor                 eax, eax
            //   89c1                 | mov                 ecx, eax
            //   8b442424             | mov                 eax, dword ptr [esp + 0x24]

        $sequence_39 = { eb0a b988130000 e8???????? 33d2 }
            // n = 4, score = 2000
            //   eb0a                 | jmp                 0xc
            //   b988130000           | mov                 ecx, 0x1388
            //   e8????????           |                     
            //   33d2                 | xor                 edx, edx

        $sequence_40 = { 85c0 7406 6a02 ff36 ffd0 }
            // n = 5, score = 2000
            //   85c0                 | test                eax, eax
            //   7406                 | je                  8
            //   6a02                 | push                2
            //   ff36                 | push                dword ptr [esi]
            //   ffd0                 | call                eax

        $sequence_41 = { 6802100000 68ffff0000 ff36 ffd0 }
            // n = 4, score = 2000
            //   6802100000           | push                0x1002
            //   68ffff0000           | push                0xffff
            //   ff36                 | push                dword ptr [esi]
            //   ffd0                 | call                eax

        $sequence_42 = { eb00 8b442404 89c1 89ca }
            // n = 4, score = 2000
            //   eb00                 | jmp                 2
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   89c1                 | mov                 ecx, eax
            //   89ca                 | mov                 edx, ecx

        $sequence_43 = { 8954242c 8b44242c 89c1 89ca }
            // n = 4, score = 2000
            //   8954242c             | mov                 dword ptr [esp + 0x2c], edx
            //   8b44242c             | mov                 eax, dword ptr [esp + 0x2c]
            //   89c1                 | mov                 ecx, eax
            //   89ca                 | mov                 edx, ecx

        $sequence_44 = { 89442408 7598 8a442407 a801 }
            // n = 4, score = 2000
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   7598                 | jne                 0xffffff9a
            //   8a442407             | mov                 al, byte ptr [esp + 7]
            //   a801                 | test                al, 1

        $sequence_45 = { c20400 55 8bec 83ec34 8365fc00 }
            // n = 5, score = 2000
            //   c20400               | ret                 4
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec34               | sub                 esp, 0x34
            //   8365fc00             | and                 dword ptr [ebp - 4], 0

        $sequence_46 = { 6a01 6a02 ffd0 8906 }
            // n = 4, score = 2000
            //   6a01                 | push                1
            //   6a02                 | push                2
            //   ffd0                 | call                eax
            //   8906                 | mov                 dword ptr [esi], eax

        $sequence_47 = { ff7508 ffd0 85c0 750e }
            // n = 4, score = 2000
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ffd0                 | call                eax
            //   85c0                 | test                eax, eax
            //   750e                 | jne                 0x10

        $sequence_48 = { 51 6880000000 68ffff0000 ff36 }
            // n = 4, score = 2000
            //   51                   | push                ecx
            //   6880000000           | push                0x80
            //   68ffff0000           | push                0xffff
            //   ff36                 | push                dword ptr [esi]

        $sequence_49 = { 50 56 8bcb e8???????? 50 e8???????? }
            // n = 6, score = 2000
            //   50                   | push                eax
            //   56                   | push                esi
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_50 = { 7404 33c9 ffd0 33c0 }
            // n = 4, score = 2000
            //   7404                 | je                  6
            //   33c9                 | xor                 ecx, ecx
            //   ffd0                 | call                eax
            //   33c0                 | xor                 eax, eax

        $sequence_51 = { e8???????? 84c0 740f 6a05 }
            // n = 4, score = 1900
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   740f                 | je                  0x11
            //   6a05                 | push                5

        $sequence_52 = { e8???????? 6880000000 55 55 }
            // n = 4, score = 1800
            //   e8????????           |                     
            //   6880000000           | push                0x80
            //   55                   | push                ebp
            //   55                   | push                ebp

        $sequence_53 = { c3 55 8bec 837d0800 7422 }
            // n = 5, score = 1700
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   837d0800             | cmp                 dword ptr [ebp + 8], 0
            //   7422                 | je                  0x24

        $sequence_54 = { ff7508 ffd0 33c0 40 5d }
            // n = 5, score = 1700
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ffd0                 | call                eax
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   5d                   | pop                 ebp

        $sequence_55 = { 8d4de0 51 68???????? ffd0 }
            // n = 4, score = 1600
            //   8d4de0               | lea                 ecx, [ebp - 0x20]
            //   51                   | push                ecx
            //   68????????           |                     
            //   ffd0                 | call                eax

        $sequence_56 = { 6a00 6a02 ffd0 50 }
            // n = 4, score = 1500
            //   6a00                 | push                0
            //   6a02                 | push                2
            //   ffd0                 | call                eax
            //   50                   | push                eax

        $sequence_57 = { 6a73 e8???????? 833f00 7523 }
            // n = 4, score = 1500
            //   6a73                 | push                0x73
            //   e8????????           |                     
            //   833f00               | cmp                 dword ptr [edi], 0
            //   7523                 | jne                 0x25

        $sequence_58 = { e8???????? 8bc8 a1???????? ff30 }
            // n = 4, score = 1400
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax
            //   a1????????           |                     
            //   ff30                 | push                dword ptr [eax]

        $sequence_59 = { 7403 c60000 b840000000 83fa40 0f4ed0 }
            // n = 5, score = 1300
            //   7403                 | je                  5
            //   c60000               | mov                 byte ptr [eax], 0
            //   b840000000           | mov                 eax, 0x40
            //   83fa40               | cmp                 edx, 0x40
            //   0f4ed0               | cmovle              edx, eax

        $sequence_60 = { 890424 e8???????? 31c0 83c420 5e }
            // n = 5, score = 1100
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   31c0                 | xor                 eax, eax
            //   83c420               | add                 esp, 0x20
            //   5e                   | pop                 esi

        $sequence_61 = { e8???????? 50 ffd7 85c0 7512 }
            // n = 5, score = 900
            //   e8????????           |                     
            //   50                   | push                eax
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax
            //   7512                 | jne                 0x14

        $sequence_62 = { eb0c e8???????? 8bf0 eb03 }
            // n = 4, score = 900
            //   eb0c                 | jmp                 0xe
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   eb03                 | jmp                 5

        $sequence_63 = { e8???????? 50 53 8d4dd0 e8???????? 50 }
            // n = 6, score = 700
            //   e8????????           |                     
            //   50                   | push                eax
            //   53                   | push                ebx
            //   8d4dd0               | lea                 ecx, [ebp - 0x30]
            //   e8????????           |                     
            //   50                   | push                eax

        $sequence_64 = { 8b45cc 31c9 8b55d0 39c2 }
            // n = 4, score = 700
            //   8b45cc               | mov                 eax, dword ptr [ebp - 0x34]
            //   31c9                 | xor                 ecx, ecx
            //   8b55d0               | mov                 edx, dword ptr [ebp - 0x30]
            //   39c2                 | cmp                 edx, eax

        $sequence_65 = { 8038e9 89c1 8945d0 894dcc }
            // n = 4, score = 700
            //   8038e9               | cmp                 byte ptr [eax], 0xe9
            //   89c1                 | mov                 ecx, eax
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax
            //   894dcc               | mov                 dword ptr [ebp - 0x34], ecx

        $sequence_66 = { 8b4838 8b5034 891424 894c2404 e8???????? 8b44241c }
            // n = 6, score = 600
            //   8b4838               | mov                 ecx, dword ptr [eax + 0x38]
            //   8b5034               | mov                 edx, dword ptr [eax + 0x34]
            //   891424               | mov                 dword ptr [esp], edx
            //   894c2404             | mov                 dword ptr [esp + 4], ecx
            //   e8????????           |                     
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]

        $sequence_67 = { 01ca 83c205 807c0805e9 891424 74e9 }
            // n = 5, score = 600
            //   01ca                 | add                 edx, ecx
            //   83c205               | add                 edx, 5
            //   807c0805e9           | cmp                 byte ptr [eax + ecx + 5], 0xe9
            //   891424               | mov                 dword ptr [esp], edx
            //   74e9                 | je                  0xffffffeb

        $sequence_68 = { 8b442408 8038e9 890424 7517 8b0424 8b4801 89c2 }
            // n = 7, score = 600
            //   8b442408             | mov                 eax, dword ptr [esp + 8]
            //   8038e9               | cmp                 byte ptr [eax], 0xe9
            //   890424               | mov                 dword ptr [esp], eax
            //   7517                 | jne                 0x19
            //   8b0424               | mov                 eax, dword ptr [esp]
            //   8b4801               | mov                 ecx, dword ptr [eax + 1]
            //   89c2                 | mov                 edx, eax

        $sequence_69 = { 6681394d5a 8945b8 894dc4 0f85b6000000 }
            // n = 4, score = 600
            //   6681394d5a           | cmp                 word ptr [ecx], 0x5a4d
            //   8945b8               | mov                 dword ptr [ebp - 0x48], eax
            //   894dc4               | mov                 dword ptr [ebp - 0x3c], ecx
            //   0f85b6000000         | jne                 0xbc

        $sequence_70 = { 8b45e8 05ffff0000 25ffff0000 83c001 }
            // n = 4, score = 600
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   05ffff0000           | add                 eax, 0xffff
            //   25ffff0000           | and                 eax, 0xffff
            //   83c001               | add                 eax, 1

        $sequence_71 = { 83797c00 8b7dbc 8945b4 8955b0 8975ac }
            // n = 5, score = 600
            //   83797c00             | cmp                 dword ptr [ecx + 0x7c], 0
            //   8b7dbc               | mov                 edi, dword ptr [ebp - 0x44]
            //   8945b4               | mov                 dword ptr [ebp - 0x4c], eax
            //   8955b0               | mov                 dword ptr [ebp - 0x50], edx
            //   8975ac               | mov                 dword ptr [ebp - 0x54], esi

        $sequence_72 = { 31c9 8b54241c 8b723c 8b7e3c 89f3 01fb }
            // n = 6, score = 600
            //   31c9                 | xor                 ecx, ecx
            //   8b54241c             | mov                 edx, dword ptr [esp + 0x1c]
            //   8b723c               | mov                 esi, dword ptr [edx + 0x3c]
            //   8b7e3c               | mov                 edi, dword ptr [esi + 0x3c]
            //   89f3                 | mov                 ebx, esi
            //   01fb                 | add                 ebx, edi

        $sequence_73 = { 5e c3 53 57 56 83ec20 8b442430 }
            // n = 7, score = 600
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   53                   | push                ebx
            //   57                   | push                edi
            //   56                   | push                esi
            //   83ec20               | sub                 esp, 0x20
            //   8b442430             | mov                 eax, dword ptr [esp + 0x30]

        $sequence_74 = { c3 55 89e5 68???????? e8???????? 83c404 }
            // n = 6, score = 600
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   68????????           |                     
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_75 = { 894dc4 0f85a1000000 8b45b8 83c018 8b4db8 8b5178 }
            // n = 6, score = 600
            //   894dc4               | mov                 dword ptr [ebp - 0x3c], ecx
            //   0f85a1000000         | jne                 0xa7
            //   8b45b8               | mov                 eax, dword ptr [ebp - 0x48]
            //   83c018               | add                 eax, 0x18
            //   8b4db8               | mov                 ecx, dword ptr [ebp - 0x48]
            //   8b5178               | mov                 edx, dword ptr [ecx + 0x78]

        $sequence_76 = { 890424 8944241c e8???????? 89442418 e8???????? 83f800 }
            // n = 6, score = 600
            //   890424               | mov                 dword ptr [esp], eax
            //   8944241c             | mov                 dword ptr [esp + 0x1c], eax
            //   e8????????           |                     
            //   89442418             | mov                 dword ptr [esp + 0x18], eax
            //   e8????????           |                     
            //   83f800               | cmp                 eax, 0

        $sequence_77 = { 8b55bc 8955c4 776a 31c0 8b4dac 8b510c 8b75bc }
            // n = 7, score = 600
            //   8b55bc               | mov                 edx, dword ptr [ebp - 0x44]
            //   8955c4               | mov                 dword ptr [ebp - 0x3c], edx
            //   776a                 | ja                  0x6c
            //   31c0                 | xor                 eax, eax
            //   8b4dac               | mov                 ecx, dword ptr [ebp - 0x54]
            //   8b510c               | mov                 edx, dword ptr [ecx + 0xc]
            //   8b75bc               | mov                 esi, dword ptr [ebp - 0x44]

        $sequence_78 = { 56 57 53 55 81ec88010000 8bd8 }
            // n = 6, score = 500
            //   56                   | push                esi
            //   57                   | push                edi
            //   53                   | push                ebx
            //   55                   | push                ebp
            //   81ec88010000         | sub                 esp, 0x188
            //   8bd8                 | mov                 ebx, eax

        $sequence_79 = { 25ffff0000 83c001 8b4da8 01c1 }
            // n = 4, score = 500
            //   25ffff0000           | and                 eax, 0xffff
            //   83c001               | add                 eax, 1
            //   8b4da8               | mov                 ecx, dword ptr [ebp - 0x58]
            //   01c1                 | add                 ecx, eax

        $sequence_80 = { c3 55 89e5 57 56 53 83ec54 }
            // n = 7, score = 500
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   57                   | push                edi
            //   56                   | push                esi
            //   53                   | push                ebx
            //   83ec54               | sub                 esp, 0x54

        $sequence_81 = { 89c6 8945f8 894df4 8975f0 7418 8b45f4 05ffff0000 }
            // n = 7, score = 500
            //   89c6                 | mov                 esi, eax
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   894df4               | mov                 dword ptr [ebp - 0xc], ecx
            //   8975f0               | mov                 dword ptr [ebp - 0x10], esi
            //   7418                 | je                  0x1a
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   05ffff0000           | add                 eax, 0xffff

        $sequence_82 = { 83c454 5b 5e 5f 5d c3 55 }
            // n = 7, score = 500
            //   83c454               | add                 esp, 0x54
            //   5b                   | pop                 ebx
            //   5e                   | pop                 esi
            //   5f                   | pop                 edi
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   55                   | push                ebp

        $sequence_83 = { 25ffff0000 83c001 8b4df0 01c1 894de4 }
            // n = 5, score = 500
            //   25ffff0000           | and                 eax, 0xffff
            //   83c001               | add                 eax, 1
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   01c1                 | add                 ecx, eax
            //   894de4               | mov                 dword ptr [ebp - 0x1c], ecx

        $sequence_84 = { c7424800b00400 8b7de4 c787cc00000000000000 c787c800000000000000 }
            // n = 4, score = 500
            //   c7424800b00400       | mov                 dword ptr [edx + 0x48], 0x4b000
            //   8b7de4               | mov                 edi, dword ptr [ebp - 0x1c]
            //   c787cc00000000000000     | mov    dword ptr [edi + 0xcc], 0
            //   c787c800000000000000     | mov    dword ptr [edi + 0xc8], 0

        $sequence_85 = { 5b 5e 5d c3 55 89e5 6a00 }
            // n = 7, score = 500
            //   5b                   | pop                 ebx
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   6a00                 | push                0

        $sequence_86 = { 894df0 8b45f0 83c40c 5e 5d c3 }
            // n = 6, score = 500
            //   894df0               | mov                 dword ptr [ebp - 0x10], ecx
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   83c40c               | add                 esp, 0xc
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   c3                   | ret                 

        $sequence_87 = { 8b4df8 01c1 894df0 8b45f0 }
            // n = 4, score = 500
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   01c1                 | add                 ecx, eax
            //   894df0               | mov                 dword ptr [ebp - 0x10], ecx
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]

        $sequence_88 = { 890c24 c744240400000000 8945f0 8955ec e8???????? 8b483c 6689ce }
            // n = 7, score = 500
            //   890c24               | mov                 dword ptr [esp], ecx
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   8955ec               | mov                 dword ptr [ebp - 0x14], edx
            //   e8????????           |                     
            //   8b483c               | mov                 ecx, dword ptr [eax + 0x3c]
            //   6689ce               | mov                 si, cx

        $sequence_89 = { 7418 8b45e4 05ffff0000 25ffff0000 }
            // n = 4, score = 500
            //   7418                 | je                  0x1a
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   05ffff0000           | add                 eax, 0xffff
            //   25ffff0000           | and                 eax, 0xffff

        $sequence_90 = { 89c7 8945f0 894dec 8955e8 897de4 }
            // n = 5, score = 500
            //   89c7                 | mov                 edi, eax
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   894dec               | mov                 dword ptr [ebp - 0x14], ecx
            //   8955e8               | mov                 dword ptr [ebp - 0x18], edx
            //   897de4               | mov                 dword ptr [ebp - 0x1c], edi

        $sequence_91 = { 8b4de8 81c1ffff0000 81e1ffff0000 83c101 }
            // n = 4, score = 500
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   81c1ffff0000         | add                 ecx, 0xffff
            //   81e1ffff0000         | and                 ecx, 0xffff
            //   83c101               | add                 ecx, 1

        $sequence_92 = { 53 57 83ec5c 8b450c }
            // n = 4, score = 400
            //   53                   | push                ebx
            //   57                   | push                edi
            //   83ec5c               | sub                 esp, 0x5c
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_93 = { 894de0 7505 e9???????? 8b45e0 83c438 5f }
            // n = 6, score = 400
            //   894de0               | mov                 dword ptr [ebp - 0x20], ecx
            //   7505                 | jne                 7
            //   e9????????           |                     
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   83c438               | add                 esp, 0x38
            //   5f                   | pop                 edi

        $sequence_94 = { 57 83ec38 8b450c 8b4d08 8945f0 }
            // n = 5, score = 400
            //   57                   | push                edi
            //   83ec38               | sub                 esp, 0x38
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax

        $sequence_95 = { 5b 5d c3 8b45d0 8b4dd4 668b55d8 }
            // n = 6, score = 400
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8b45d0               | mov                 eax, dword ptr [ebp - 0x30]
            //   8b4dd4               | mov                 ecx, dword ptr [ebp - 0x2c]
            //   668b55d8             | mov                 dx, word ptr [ebp - 0x28]

        $sequence_96 = { e9???????? 8b45e0 83c45c 5f 5b 5e }
            // n = 6, score = 400
            //   e9????????           |                     
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   83c45c               | add                 esp, 0x5c
            //   5f                   | pop                 edi
            //   5b                   | pop                 ebx
            //   5e                   | pop                 esi

        $sequence_97 = { 68???????? 50 50 ffd2 }
            // n = 4, score = 400
            //   68????????           |                     
            //   50                   | push                eax
            //   50                   | push                eax
            //   ffd2                 | call                edx

        $sequence_98 = { 8945c4 894dc0 885dbf 8975b8 }
            // n = 4, score = 400
            //   8945c4               | mov                 dword ptr [ebp - 0x3c], eax
            //   894dc0               | mov                 dword ptr [ebp - 0x40], ecx
            //   885dbf               | mov                 byte ptr [ebp - 0x41], bl
            //   8975b8               | mov                 dword ptr [ebp - 0x48], esi

        $sequence_99 = { 8945a0 8955cc 74bc 8b45cc 83c454 5b 5e }
            // n = 7, score = 300
            //   8945a0               | mov                 dword ptr [ebp - 0x60], eax
            //   8955cc               | mov                 dword ptr [ebp - 0x34], edx
            //   74bc                 | je                  0xffffffbe
            //   8b45cc               | mov                 eax, dword ptr [ebp - 0x34]
            //   83c454               | add                 esp, 0x54
            //   5b                   | pop                 ebx
            //   5e                   | pop                 esi

        $sequence_100 = { 89e5 57 53 56 83ec38 }
            // n = 5, score = 300
            //   89e5                 | mov                 ebp, esp
            //   57                   | push                edi
            //   53                   | push                ebx
            //   56                   | push                esi
            //   83ec38               | sub                 esp, 0x38

        $sequence_101 = { 53 83ec74 8b450c 8b4d08 31d2 8b713c 89cf }
            // n = 7, score = 300
            //   53                   | push                ebx
            //   83ec74               | sub                 esp, 0x74
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   31d2                 | xor                 edx, edx
            //   8b713c               | mov                 esi, dword ptr [ecx + 0x3c]
            //   89cf                 | mov                 edi, ecx

        $sequence_102 = { 83c438 5e 5b 5f }
            // n = 4, score = 300
            //   83c438               | add                 esp, 0x38
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   5f                   | pop                 edi

        $sequence_103 = { eb06 83c414 5b 5d c3 8b45f0 8b0c8504406e00 }
            // n = 7, score = 300
            //   eb06                 | jmp                 8
            //   83c414               | add                 esp, 0x14
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   8b0c8504406e00       | mov                 ecx, dword ptr [eax*4 + 0x6e4004]

        $sequence_104 = { 57 83ec20 8b4508 890424 }
            // n = 4, score = 300
            //   57                   | push                edi
            //   83ec20               | sub                 esp, 0x20
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   890424               | mov                 dword ptr [esp], eax

        $sequence_105 = { 8b7dcc 39f8 8945c8 75e4 83c448 5e 5f }
            // n = 7, score = 300
            //   8b7dcc               | mov                 edi, dword ptr [ebp - 0x34]
            //   39f8                 | cmp                 eax, edi
            //   8945c8               | mov                 dword ptr [ebp - 0x38], eax
            //   75e4                 | jne                 0xffffffe6
            //   83c448               | add                 esp, 0x48
            //   5e                   | pop                 esi
            //   5f                   | pop                 edi

        $sequence_106 = { 85d2 7412 33c0 50 50 56 }
            // n = 6, score = 300
            //   85d2                 | test                edx, edx
            //   7412                 | je                  0x14
            //   33c0                 | xor                 eax, eax
            //   50                   | push                eax
            //   50                   | push                eax
            //   56                   | push                esi

        $sequence_107 = { c3 8b45f0 8b0c8504406e00 8b55f8 39d1 8945ec 894de8 }
            // n = 7, score = 300
            //   c3                   | ret                 
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   8b0c8504406e00       | mov                 ecx, dword ptr [eax*4 + 0x6e4004]
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   39d1                 | cmp                 ecx, edx
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   894de8               | mov                 dword ptr [ebp - 0x18], ecx

        $sequence_108 = { c605????????00 e8???????? 8bd0 85d2 7412 }
            // n = 5, score = 300
            //   c605????????00       |                     
            //   e8????????           |                     
            //   8bd0                 | mov                 edx, eax
            //   85d2                 | test                edx, edx
            //   7412                 | je                  0x14

        $sequence_109 = { 83ec20 a1???????? 85c0 7416 8b0d???????? e8???????? 84c0 }
            // n = 7, score = 300
            //   83ec20               | sub                 esp, 0x20
            //   a1????????           |                     
            //   85c0                 | test                eax, eax
            //   7416                 | je                  0x18
            //   8b0d????????         |                     
            //   e8????????           |                     
            //   84c0                 | test                al, al

        $sequence_110 = { 0f85dafeffff 8b45e4 83c474 5b }
            // n = 4, score = 300
            //   0f85dafeffff         | jne                 0xfffffee0
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   83c474               | add                 esp, 0x74
            //   5b                   | pop                 ebx

        $sequence_111 = { 895c2414 660fd6442418 660fd6442420 e8???????? 84c0 }
            // n = 5, score = 300
            //   895c2414             | mov                 dword ptr [esp + 0x14], ebx
            //   660fd6442418         | movq                qword ptr [esp + 0x18], xmm0
            //   660fd6442420         | movq                qword ptr [esp + 0x20], xmm0
            //   e8????????           |                     
            //   84c0                 | test                al, al

        $sequence_112 = { e9???????? 8bcd 8d8424a8010000 50 }
            // n = 4, score = 300
            //   e9????????           |                     
            //   8bcd                 | mov                 ecx, ebp
            //   8d8424a8010000       | lea                 eax, [esp + 0x1a8]
            //   50                   | push                eax

        $sequence_113 = { 53 81ecb0000000 8b4508 8d4dd8 c745d800000000 }
            // n = 5, score = 300
            //   53                   | push                ebx
            //   81ecb0000000         | sub                 esp, 0xb0
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   c745d800000000       | mov                 dword ptr [ebp - 0x28], 0

        $sequence_114 = { 8955dc e8???????? 8d0de8306e00 890424 894c2404 e8???????? 8d0d44306e00 }
            // n = 7, score = 200
            //   8955dc               | mov                 dword ptr [ebp - 0x24], edx
            //   e8????????           |                     
            //   8d0de8306e00         | lea                 ecx, [0x6e30e8]
            //   890424               | mov                 dword ptr [esp], eax
            //   894c2404             | mov                 dword ptr [esp + 4], ecx
            //   e8????????           |                     
            //   8d0d44306e00         | lea                 ecx, [0x6e3044]

        $sequence_115 = { 8855af 8975cc 751c 8b45a4 8a4daf 31d2 8a2c0575306e00 }
            // n = 7, score = 200
            //   8855af               | mov                 byte ptr [ebp - 0x51], dl
            //   8975cc               | mov                 dword ptr [ebp - 0x34], esi
            //   751c                 | jne                 0x1e
            //   8b45a4               | mov                 eax, dword ptr [ebp - 0x5c]
            //   8a4daf               | mov                 cl, byte ptr [ebp - 0x51]
            //   31d2                 | xor                 edx, edx
            //   8a2c0575306e00       | mov                 ch, byte ptr [eax + 0x6e3075]

        $sequence_116 = { 83c470 5b 5f 5e 5d c3 }
            // n = 6, score = 200
            //   83c470               | add                 esp, 0x70
            //   5b                   | pop                 ebx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   c3                   | ret                 

        $sequence_117 = { c3 55 89e5 56 53 57 83ec54 }
            // n = 7, score = 200
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   56                   | push                esi
            //   53                   | push                ebx
            //   57                   | push                edi
            //   83ec54               | sub                 esp, 0x54

        $sequence_118 = { e9???????? 8b45e0 83c45c 5e 5f 5b }
            // n = 6, score = 200
            //   e9????????           |                     
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   83c45c               | add                 esp, 0x5c
            //   5e                   | pop                 esi
            //   5f                   | pop                 edi
            //   5b                   | pop                 ebx

        $sequence_119 = { 897dd8 8b45d8 83c444 5b 5e }
            // n = 5, score = 200
            //   897dd8               | mov                 dword ptr [ebp - 0x28], edi
            //   8b45d8               | mov                 eax, dword ptr [ebp - 0x28]
            //   83c444               | add                 esp, 0x44
            //   5b                   | pop                 ebx
            //   5e                   | pop                 esi

        $sequence_120 = { 57 53 83ec70 8b450c }
            // n = 4, score = 200
            //   57                   | push                edi
            //   53                   | push                ebx
            //   83ec70               | sub                 esp, 0x70
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_121 = { 74bc 8b45cc 83c454 5f 5b 5e 5d }
            // n = 7, score = 200
            //   74bc                 | je                  0xffffffbe
            //   8b45cc               | mov                 eax, dword ptr [ebp - 0x34]
            //   83c454               | add                 esp, 0x54
            //   5f                   | pop                 edi
            //   5b                   | pop                 ebx
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp

        $sequence_122 = { 57 56 83ec5c 8b450c 8b4d08 31d2 8b7008 }
            // n = 7, score = 200
            //   57                   | push                edi
            //   56                   | push                esi
            //   83ec5c               | sub                 esp, 0x5c
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   31d2                 | xor                 edx, edx
            //   8b7008               | mov                 esi, dword ptr [eax + 8]

        $sequence_123 = { 89e5 53 56 57 83ec38 }
            // n = 5, score = 200
            //   89e5                 | mov                 ebp, esp
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   83ec38               | sub                 esp, 0x38

        $sequence_124 = { 8d0d44306e00 31d2 890c24 c744240400000000 }
            // n = 4, score = 200
            //   8d0d44306e00         | lea                 ecx, [0x6e3044]
            //   31d2                 | xor                 edx, edx
            //   890c24               | mov                 dword ptr [esp], ecx
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0

        $sequence_125 = { 89723c c7424004000000 c742442c0c0200 c7424800b00400 8b7de4 }
            // n = 5, score = 200
            //   89723c               | mov                 dword ptr [edx + 0x3c], esi
            //   c7424004000000       | mov                 dword ptr [edx + 0x40], 4
            //   c742442c0c0200       | mov                 dword ptr [edx + 0x44], 0x20c2c
            //   c7424800b00400       | mov                 dword ptr [edx + 0x48], 0x4b000
            //   8b7de4               | mov                 edi, dword ptr [ebp - 0x1c]

        $sequence_126 = { 8a2c0575306e00 83c001 38e9 8945a0 }
            // n = 4, score = 200
            //   8a2c0575306e00       | mov                 ch, byte ptr [eax + 0x6e3075]
            //   83c001               | add                 eax, 1
            //   38e9                 | cmp                 cl, ch
            //   8945a0               | mov                 dword ptr [ebp - 0x60], eax

        $sequence_127 = { 57 83ec54 8d055a232700 31c9 8d55d8 803d????????e9 }
            // n = 6, score = 100
            //   57                   | push                edi
            //   83ec54               | sub                 esp, 0x54
            //   8d055a232700         | lea                 eax, [0x27235a]
            //   31c9                 | xor                 ecx, ecx
            //   8d55d8               | lea                 edx, [ebp - 0x28]
            //   803d????????e9       |                     

        $sequence_128 = { 52 8bd6 e8???????? 8bcf 53 }
            // n = 5, score = 100
            //   52                   | push                edx
            //   8bd6                 | mov                 edx, esi
            //   e8????????           |                     
            //   8bcf                 | mov                 ecx, edi
            //   53                   | push                ebx

        $sequence_129 = { 8945d0 74e4 31c0 8d0d5a238400 8b55c8 39ca }
            // n = 6, score = 100
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax
            //   74e4                 | je                  0xffffffe6
            //   31c0                 | xor                 eax, eax
            //   8d0d5a238400         | lea                 ecx, [0x84235a]
            //   8b55c8               | mov                 edx, dword ptr [ebp - 0x38]
            //   39ca                 | cmp                 edx, ecx

        $sequence_130 = { 8a4daf 31d2 8a2c0575308400 83c001 }
            // n = 4, score = 100
            //   8a4daf               | mov                 cl, byte ptr [ebp - 0x51]
            //   31d2                 | xor                 edx, edx
            //   8a2c0575308400       | mov                 ch, byte ptr [eax + 0x843075]
            //   83c001               | add                 eax, 1

        $sequence_131 = { c744240400000000 8955e0 e8???????? 8d0dd8308400 }
            // n = 4, score = 100
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0
            //   8955e0               | mov                 dword ptr [ebp - 0x20], edx
            //   e8????????           |                     
            //   8d0dd8308400         | lea                 ecx, [0x8430d8]

        $sequence_132 = { 8b4d08 8d155e302f00 83ec04 891424 8945e8 }
            // n = 5, score = 100
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8d155e302f00         | lea                 edx, [0x2f305e]
            //   83ec04               | sub                 esp, 4
            //   891424               | mov                 dword ptr [esp], edx
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax

        $sequence_133 = { 8d0d44308400 31d2 8b75f8 89461c 890c24 c744240400000000 8955e4 }
            // n = 7, score = 100
            //   8d0d44308400         | lea                 ecx, [0x843044]
            //   31d2                 | xor                 edx, edx
            //   8b75f8               | mov                 esi, dword ptr [ebp - 8]
            //   89461c               | mov                 dword ptr [esi + 0x1c], eax
            //   890c24               | mov                 dword ptr [esp], ecx
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0
            //   8955e4               | mov                 dword ptr [ebp - 0x1c], edx

    condition:
        7 of them and filesize < 1040384
}