rule win_dripion_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dripion."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dripion"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffd6 0faff8 ffd6 0faff8 }
            // n = 4, score = 400
            //   ffd6                 | call                esi
            //   0faff8               | imul                edi, eax
            //   ffd6                 | call                esi
            //   0faff8               | imul                edi, eax

        $sequence_1 = { ffd6 0faff8 8d3c7f ffd6 }
            // n = 4, score = 400
            //   ffd6                 | call                esi
            //   0faff8               | imul                edi, eax
            //   8d3c7f               | lea                 edi, [edi + edi*2]
            //   ffd6                 | call                esi

        $sequence_2 = { 740f 3ccf 740b 34cf }
            // n = 4, score = 400
            //   740f                 | je                  0x11
            //   3ccf                 | cmp                 al, 0xcf
            //   740b                 | je                  0xd
            //   34cf                 | xor                 al, 0xcf

        $sequence_3 = { ffd6 03f8 ffd6 8bd8 ffd6 0fafd8 }
            // n = 6, score = 400
            //   ffd6                 | call                esi
            //   03f8                 | add                 edi, eax
            //   ffd6                 | call                esi
            //   8bd8                 | mov                 ebx, eax
            //   ffd6                 | call                esi
            //   0fafd8               | imul                ebx, eax

        $sequence_4 = { ffd6 03f8 8d3c7f ffd6 }
            // n = 4, score = 400
            //   ffd6                 | call                esi
            //   03f8                 | add                 edi, eax
            //   8d3c7f               | lea                 edi, [edi + edi*2]
            //   ffd6                 | call                esi

        $sequence_5 = { 8bf8 ffd6 0faff8 8d3c7f ffd6 }
            // n = 5, score = 400
            //   8bf8                 | mov                 edi, eax
            //   ffd6                 | call                esi
            //   0faff8               | imul                edi, eax
            //   8d3c7f               | lea                 edi, [edi + edi*2]
            //   ffd6                 | call                esi

        $sequence_6 = { 7513 6a64 ff15???????? 68???????? ff15???????? }
            // n = 5, score = 400
            //   7513                 | jne                 0x15
            //   6a64                 | push                0x64
            //   ff15????????         |                     
            //   68????????           |                     
            //   ff15????????         |                     

        $sequence_7 = { 8bf8 ffd6 0faff8 8d3c7f }
            // n = 4, score = 400
            //   8bf8                 | mov                 edi, eax
            //   ffd6                 | call                esi
            //   0faff8               | imul                edi, eax
            //   8d3c7f               | lea                 edi, [edi + edi*2]

        $sequence_8 = { ffd6 8bf8 ffd6 0faff8 8d3c7f ffd6 }
            // n = 6, score = 400
            //   ffd6                 | call                esi
            //   8bf8                 | mov                 edi, eax
            //   ffd6                 | call                esi
            //   0faff8               | imul                edi, eax
            //   8d3c7f               | lea                 edi, [edi + edi*2]
            //   ffd6                 | call                esi

        $sequence_9 = { ffd6 8bf8 ffd6 0faff8 8d3c7f }
            // n = 5, score = 400
            //   ffd6                 | call                esi
            //   8bf8                 | mov                 edi, eax
            //   ffd6                 | call                esi
            //   0faff8               | imul                edi, eax
            //   8d3c7f               | lea                 edi, [edi + edi*2]

    condition:
        7 of them and filesize < 90112
}