rule win_duqu_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.duqu."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.duqu"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8d8df8fdffff 51 ff9088000000 8bd6 8bc8 }
            // n = 6, score = 400
            //   e8????????           |                     
            //   8d8df8fdffff         | lea                 ecx, [ebp - 0x208]
            //   51                   | push                ecx
            //   ff9088000000         | call                dword ptr [eax + 0x88]
            //   8bd6                 | mov                 edx, esi
            //   8bc8                 | mov                 ecx, eax

        $sequence_1 = { 5e 5b 8be5 5d c3 8b4718 ebf4 }
            // n = 7, score = 400
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8b4718               | mov                 eax, dword ptr [edi + 0x18]
            //   ebf4                 | jmp                 0xfffffff6

        $sequence_2 = { ba78978b33 89869c000000 8bcb e8???????? ba5859004e }
            // n = 5, score = 400
            //   ba78978b33           | mov                 edx, 0x338b9778
            //   89869c000000         | mov                 dword ptr [esi + 0x9c], eax
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   ba5859004e           | mov                 edx, 0x4e005958

        $sequence_3 = { 744d 8b4c2414 8a442413 8b5c2418 85c9 7e30 0fb6c8 }
            // n = 7, score = 400
            //   744d                 | je                  0x4f
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   8a442413             | mov                 al, byte ptr [esp + 0x13]
            //   8b5c2418             | mov                 ebx, dword ptr [esp + 0x18]
            //   85c9                 | test                ecx, ecx
            //   7e30                 | jle                 0x32
            //   0fb6c8               | movzx               ecx, al

        $sequence_4 = { 85c0 7465 e8???????? 85c0 }
            // n = 4, score = 400
            //   85c0                 | test                eax, eax
            //   7465                 | je                  0x67
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_5 = { 56 51 8bf2 e8???????? }
            // n = 4, score = 400
            //   56                   | push                esi
            //   51                   | push                ecx
            //   8bf2                 | mov                 esi, edx
            //   e8????????           |                     

        $sequence_6 = { 8b5c242c 741a 40 83c704 8944241c 3b4218 }
            // n = 6, score = 400
            //   8b5c242c             | mov                 ebx, dword ptr [esp + 0x2c]
            //   741a                 | je                  0x1c
            //   40                   | inc                 eax
            //   83c704               | add                 edi, 4
            //   8944241c             | mov                 dword ptr [esp + 0x1c], eax
            //   3b4218               | cmp                 eax, dword ptr [edx + 0x18]

        $sequence_7 = { baec8ce154 8bcb e8???????? ba8eacac75 894628 }
            // n = 5, score = 400
            //   baec8ce154           | mov                 edx, 0x54e18cec
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   ba8eacac75           | mov                 edx, 0x75acac8e
            //   894628               | mov                 dword ptr [esi + 0x28], eax

        $sequence_8 = { ba1225339c 89462c 8bcb e8???????? 89466c 85c0 }
            // n = 6, score = 400
            //   ba1225339c           | mov                 edx, 0x9c332512
            //   89462c               | mov                 dword ptr [esi + 0x2c], eax
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   89466c               | mov                 dword ptr [esi + 0x6c], eax
            //   85c0                 | test                eax, eax

        $sequence_9 = { 8b4c2414 40 49 89442420 }
            // n = 4, score = 400
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   40                   | inc                 eax
            //   49                   | dec                 ecx
            //   89442420             | mov                 dword ptr [esp + 0x20], eax

        $sequence_10 = { 8bec 81ec0c020000 56 ff7508 8bf2 }
            // n = 5, score = 200
            //   8bec                 | mov                 ebp, esp
            //   81ec0c020000         | sub                 esp, 0x20c
            //   56                   | push                esi
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8bf2                 | mov                 esi, edx

        $sequence_11 = { 8bec 81ec04020000 53 8b5d08 56 57 6af0 }
            // n = 7, score = 200
            //   8bec                 | mov                 ebp, esp
            //   81ec04020000         | sub                 esp, 0x204
            //   53                   | push                ebx
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   56                   | push                esi
            //   57                   | push                edi
            //   6af0                 | push                -0x10

        $sequence_12 = { 8bec 81ec10080000 8365fc00 b800010000 }
            // n = 4, score = 200
            //   8bec                 | mov                 ebp, esp
            //   81ec10080000         | sub                 esp, 0x810
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   b800010000           | mov                 eax, 0x100

        $sequence_13 = { 8bec 53 56 8bd8 8d732c 57 8bce }
            // n = 7, score = 200
            //   8bec                 | mov                 ebp, esp
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8bd8                 | mov                 ebx, eax
            //   8d732c               | lea                 esi, [ebx + 0x2c]
            //   57                   | push                edi
            //   8bce                 | mov                 ecx, esi

        $sequence_14 = { 8bec 56 57 8b7d08 33f6 3b7d0c }
            // n = 6, score = 200
            //   8bec                 | mov                 ebp, esp
            //   56                   | push                esi
            //   57                   | push                edi
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   33f6                 | xor                 esi, esi
            //   3b7d0c               | cmp                 edi, dword ptr [ebp + 0xc]

        $sequence_15 = { 8bec 81ec0c020000 8365fc00 833d????????ff }
            // n = 4, score = 200
            //   8bec                 | mov                 ebp, esp
            //   81ec0c020000         | sub                 esp, 0x20c
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   833d????????ff       |                     

    condition:
        7 of them and filesize < 18759680
}