rule win_dusttrap_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dusttrap."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dusttrap"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4133c0 c1e008 33c2 4389848c40ec0200 c1c008 }
            // n = 5, score = 100
            //   4133c0               | dec                 ecx
            //   c1e008               | mov                 eax, 0xffffffff
            //   33c2                 | nop                 dword ptr [eax + eax]
            //   4389848c40ec0200     | dec                 ebp
            //   c1c008               | mov                 eax, esi

        $sequence_1 = { 492bf4 75a9 488b9c24b80a0000 488bbc24a80a0000 4c8bbc24980a0000 4c8bac24a00a0000 488bb424b00a0000 }
            // n = 7, score = 100
            //   492bf4               | mov                 dword ptr [esp + 0x30], ebp
            //   75a9                 | dec                 eax
            //   488b9c24b80a0000     | mov                 ecx, dword ptr [ecx + 0x198]
            //   488bbc24a80a0000     | inc                 esp
            //   4c8bbc24980a0000     | lea                 eax, [edx + 6]
            //   4c8bac24a00a0000     | mov                 dword ptr [esp + 0x28], 4
            //   488bb424b00a0000     | dec                 esp

        $sequence_2 = { 478b9c8240dc0200 48c1e918 45339c9240e80200 41c1ef08 410fb6d7 4c8d3d5257ffff 45339c8a40d80200 }
            // n = 7, score = 100
            //   478b9c8240dc0200     | mov                 dword ptr [esp + 0x58], edi
            //   48c1e918             | xorps               xmm0, xmm0
            //   45339c9240e80200     | dec                 esp
            //   41c1ef08             | mov                 dword ptr [esp + 0x50], edi
            //   410fb6d7             | dec                 esp
            //   4c8d3d5257ffff       | mov                 ecx, ebx
            //   45339c8a40d80200     | dec                 eax

        $sequence_3 = { 4c8bf9 33d2 488b0d???????? 8bf5 488b89f8000000 e8???????? }
            // n = 6, score = 100
            //   4c8bf9               | dec                 eax
            //   33d2                 | add                 esi, esi
            //   488b0d????????       |                     
            //   8bf5                 | dec                 ecx
            //   488b89f8000000       | arpl                word ptr [edi + esi*8 + 0x237d8], ax
            //   e8????????           |                     

        $sequence_4 = { 488bbc24a80a0000 4c8bbc24980a0000 4c8bac24a00a0000 488bb424b00a0000 4d85f6 743f 488b0d???????? }
            // n = 7, score = 100
            //   488bbc24a80a0000     | dec                 eax
            //   4c8bbc24980a0000     | lea                 ecx, [ebp - 0x3c]
            //   4c8bac24a00a0000     | dec                 esp
            //   488bb424b00a0000     | lea                 ecx, [ebp - 0x40]
            //   4d85f6               | xor                 edx, edx
            //   743f                 | dec                 eax
            //   488b0d????????       |                     

        $sequence_5 = { e8???????? 8bf0 85c0 0f85f4000000 0f57c0 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   8bf0                 | pop                 esi
            //   85c0                 | inc                 ecx
            //   0f85f4000000         | pop                 esp
            //   0f57c0               | pop                 edi

        $sequence_6 = { 498d4e30 4533c0 baa00f0000 e8???????? 488b05???????? 4c8d0539810100 488bd5 }
            // n = 7, score = 100
            //   498d4e30             | dec                 eax
            //   4533c0               | add                 esp, 0x110
            //   baa00f0000           | pop                 ebp
            //   e8????????           |                     
            //   488b05????????       |                     
            //   4c8d0539810100       | ret                 
            //   488bd5               | dec                 esp

        $sequence_7 = { 448bf6 4903df 4981c600ffffff 33d2 41b820030000 4c03f3 e8???????? }
            // n = 7, score = 100
            //   448bf6               | mov                 ecx, dword ptr [ecx + 0x188]
            //   4903df               | dec                 eax
            //   4981c600ffffff       | lea                 eax, [esp + 0x60]
            //   33d2                 | dec                 eax
            //   41b820030000         | mov                 dword ptr [esp + 0x58], ebp
            //   4c03f3               | dec                 eax
            //   e8????????           |                     

        $sequence_8 = { 89442420 488b8988010000 448d4204 e8???????? 488b0d???????? 488d8424d0000000 48896c2458 }
            // n = 7, score = 100
            //   89442420             | mov                 edx, 0x28
            //   488b8988010000       | inc                 esp
            //   448d4204             | mov                 dword ptr [esp + 0x38], eax
            //   e8????????           |                     
            //   488b0d????????       |                     
            //   488d8424d0000000     | dec                 esp
            //   48896c2458           | lea                 eax, [0x23160]

        $sequence_9 = { 488b4108 488d4908 488902 488d5208 }
            // n = 4, score = 100
            //   488b4108             | xor                 eax, edx
            //   488d4908             | inc                 ecx
            //   488902               | mov                 eax, eax
            //   488d5208             | inc                 ebp

    condition:
        7 of them and filesize < 421888
}