rule win_duuzer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.duuzer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.duuzer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83f804 7408 83c8ff e9???????? }
            // n = 4, score = 200
            //   83f804               | cmp                 eax, 4
            //   7408                 | je                  0xa
            //   83c8ff               | or                  eax, 0xffffffff
            //   e9????????           |                     

        $sequence_1 = { 5e c3 397170 74e4 83b9f800000008 48895c2458 }
            // n = 6, score = 100
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   397170               | cmp                 dword ptr [ecx + 0x70], esi
            //   74e4                 | je                  0xffffffe6
            //   83b9f800000008       | cmp                 dword ptr [ecx + 0xf8], 8
            //   48895c2458           | dec                 eax

        $sequence_2 = { c78598fdffff288c3a55 c7859cfdffff83a89c49 c785a0fdffff9ace29e0 c785a4fdffff5652b72b }
            // n = 4, score = 100
            //   c78598fdffff288c3a55     | mov    dword ptr [ebp - 0x268], 0x553a8c28
            //   c7859cfdffff83a89c49     | mov    dword ptr [ebp - 0x264], 0x499ca883
            //   c785a0fdffff9ace29e0     | mov    dword ptr [ebp - 0x260], 0xe029ce9a
            //   c785a4fdffff5652b72b     | mov    dword ptr [ebp - 0x25c], 0x2bb75256

        $sequence_3 = { b8a2000000 5e 8b4dfc 33cd }
            // n = 4, score = 100
            //   b8a2000000           | mov                 eax, 0xa2
            //   5e                   | pop                 esi
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   33cd                 | xor                 ecx, ebp

        $sequence_4 = { 5f c3 4585ff 74d9 4489a70c170000 }
            // n = 5, score = 100
            //   5f                   | je                  0xffffffeb
            //   c3                   | cmp                 dword ptr [ecx + 0xf8], 8
            //   4585ff               | dec                 eax
            //   74d9                 | mov                 dword ptr [esp + 0x58], ebx
            //   4489a70c170000       | pop                 edi

        $sequence_5 = { c785f0fefeff20964000 c785f4fefeff40964000 c785f8fefeff60964000 c785fcfefeff80964000 c78500fffeffd0964000 }
            // n = 5, score = 100
            //   c785f0fefeff20964000     | mov    dword ptr [ebp - 0x10110], 0x409620
            //   c785f4fefeff40964000     | mov    dword ptr [ebp - 0x1010c], 0x409640
            //   c785f8fefeff60964000     | mov    dword ptr [ebp - 0x10108], 0x409660
            //   c785fcfefeff80964000     | mov    dword ptr [ebp - 0x10104], 0x409680
            //   c78500fffeffd0964000     | mov    dword ptr [ebp - 0x10100], 0x4096d0

        $sequence_6 = { 5f 5d c3 488d0529230100 }
            // n = 4, score = 100
            //   5f                   | dec                 esp
            //   5d                   | mov                 dword ptr [esp + 0x20], edi
            //   c3                   | dec                 eax
            //   488d0529230100       | cmp                 dword ptr [esi + 0x20], edi

        $sequence_7 = { 51 56 e8???????? 6a78 8d4de8 }
            // n = 5, score = 100
            //   51                   | push                ecx
            //   56                   | push                esi
            //   e8????????           |                     
            //   6a78                 | push                0x78
            //   8d4de8               | lea                 ecx, [ebp - 0x18]

        $sequence_8 = { ffd6 a3???????? 85c0 7413 8d8509ffffff }
            // n = 5, score = 100
            //   ffd6                 | call                esi
            //   a3????????           |                     
            //   85c0                 | test                eax, eax
            //   7413                 | je                  0x15
            //   8d8509ffffff         | lea                 eax, [ebp - 0xf7]

        $sequence_9 = { 8d86a4000000 c7465000000100 89464c 837dfc00 752f }
            // n = 5, score = 100
            //   8d86a4000000         | lea                 eax, [esi + 0xa4]
            //   c7465000000100       | mov                 dword ptr [esi + 0x50], 0x10000
            //   89464c               | mov                 dword ptr [esi + 0x4c], eax
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0
            //   752f                 | jne                 0x31

        $sequence_10 = { 5f 5e 5d c3 488d542470 8bcb }
            // n = 6, score = 100
            //   5f                   | dec                 eax
            //   5e                   | mov                 dword ptr [ecx], eax
            //   5d                   | dec                 eax
            //   c3                   | mov                 eax, dword ptr [edx]
            //   488d542470           | mov                 byte ptr [ecx + 0x10], 0
            //   8bcb                 | pop                 edi

        $sequence_11 = { 5e c3 488b4e38 48895c2468 }
            // n = 4, score = 100
            //   5e                   | mov                 dword ptr [esp + 0x58], ebx
            //   c3                   | inc                 esp
            //   488b4e38             | mov                 dword ptr [ecx + 0x80], edi
            //   48895c2468           | pop                 esi

        $sequence_12 = { 5f c3 4585f6 74db }
            // n = 4, score = 100
            //   5f                   | mov                 dword ptr [esp + 0x40], ebx
            //   c3                   | dec                 esp
            //   4585f6               | mov                 dword ptr [esp + 0x48], esp
            //   74db                 | pop                 edi

        $sequence_13 = { 50 8d0c1e 51 52 }
            // n = 4, score = 100
            //   50                   | push                eax
            //   8d0c1e               | lea                 ecx, [esi + ebx]
            //   51                   | push                ecx
            //   52                   | push                edx

        $sequence_14 = { 5f 5d 5b c3 33c9 4c897c2460 }
            // n = 6, score = 100
            //   5f                   | mov                 dword ptr [esp + 0x68], ebx
            //   5d                   | dec                 ecx
            //   5b                   | mov                 edx, esp
            //   c3                   | dec                 esp
            //   33c9                 | mov                 dword ptr [esp + 0x20], edi
            //   4c897c2460           | pop                 esi

    condition:
        7 of them and filesize < 491520
}