rule win_eagerbee_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.eagerbee."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.eagerbee"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3986f4160000 0f8576ffffff 8b8684000000 85c0 7809 488bd0 }
            // n = 6, score = 100
            //   3986f4160000         | call                dword ptr [eax + 0x58]
            //   0f8576ffffff         | dec                 eax
            //   8b8684000000         | lea                 edx, [esp + 0x28]
            //   85c0                 | dec                 ecx
            //   7809                 | mov                 ecx, dword ptr [eax + 8]
            //   488bd0               | dec                 eax

        $sequence_1 = { 488d4c0422 44896309 e8???????? 8bd0 e9???????? 488d4c0421 e8???????? }
            // n = 7, score = 100
            //   488d4c0422           | cmp                 dword ptr [edi + 0x1bd8], 0
            //   44896309             | jne                 0x714
            //   e8????????           |                     
            //   8bd0                 | mov                 edx, eax
            //   e9????????           |                     
            //   488d4c0421           | dec                 eax
            //   e8????????           |                     

        $sequence_2 = { 44396818 0f84b7010000 488d1de463ffff beffff0000 bd00010000 e9???????? 4439af90000000 }
            // n = 7, score = 100
            //   44396818             | dec                 eax
            //   0f84b7010000         | mov                 dword ptr [esp + 0x40], ebx
            //   488d1de463ffff       | mov                 dword ptr [esp + 0x58], edi
            //   beffff0000           | dec                 eax
            //   bd00010000           | lea                 ecx, [esp + 0x40]
            //   e9????????           |                     
            //   4439af90000000       | mov                 ebx, eax

        $sequence_3 = { 885c247d 488b08 488d542470 ff5058 b9fb010000 488bd8 e8???????? }
            // n = 7, score = 100
            //   885c247d             | lea                 ebx, [esp + 0x110]
            //   488b08               | call                dword ptr [ebx + 0x30]
            //   488d542470           | dec                 eax
            //   ff5058               | mov                 edi, eax
            //   b9fb010000           | dec                 eax
            //   488bd8               | test                eax, eax
            //   e8????????           |                     

        $sequence_4 = { c684242b0100006d 4088bc242c010000 4088b4242d010000 48397308 0f84ae030000 488b05???????? c684249000000073 }
            // n = 7, score = 100
            //   c684242b0100006d     | dec                 eax
            //   4088bc242c010000     | lea                 eax, [esp + 0x54]
            //   4088b4242d010000     | dec                 eax
            //   48397308             | lea                 ecx, [esp + 0x50]
            //   0f84ae030000         | lea                 edx, [ebx + 4]
            //   488b05????????       |                     
            //   c684249000000073     | inc                 ebp

        $sequence_5 = { 33c9 8bd7 41b800300000 ff15???????? 8b5500 }
            // n = 5, score = 100
            //   33c9                 | mov                 eax, esi
            //   8bd7                 | jmp                 0x16cd
            //   41b800300000         | mov                 ecx, dword ptr [edi + 0x4c]
            //   ff15????????         |                     
            //   8b5500               | jne                 0x16cb

        $sequence_6 = { c644243432 c64424352e c644243664 884c2438 488d4c2430 c644243900 }
            // n = 6, score = 100
            //   c644243432           | inc                 ecx
            //   c64424352e           | push                edi
            //   c644243664           | dec                 eax
            //   884c2438             | sub                 esp, 0x8f0
            //   488d4c2430           | mov                 eax, 0x6c
            //   c644243900           | dec                 eax

        $sequence_7 = { 488d8c24e0040000 48894c2420 488b8c24e8040000 4c8bc3 ba01000000 ffd0 488b05???????? }
            // n = 7, score = 100
            //   488d8c24e0040000     | lea                 eax, [edi + 0x39]
            //   48894c2420           | mov                 word ptr [esp + 0x52], ax
            //   488b8c24e8040000     | inc                 esp
            //   4c8bc3               | lea                 ecx, [edi + 0x5b]
            //   ba01000000           | lea                 eax, [edi + 0x6d]
            //   ffd0                 | mov                 word ptr [esp + 0x5a], ax
            //   488b05????????       |                     

        $sequence_8 = { 8a8424c0000000 8b9c24a8000000 488bbc2498000000 88442450 488b8424b8000000 498943e0 8a8424b0000000 }
            // n = 7, score = 100
            //   8a8424c0000000       | dec                 esp
            //   8b9c24a8000000       | mov                 dword ptr [edi + 0x28], esp
            //   488bbc2498000000     | mov                 dword ptr [edi], eax
            //   88442450             | mov                 eax, dword ptr [esp + 0x24]
            //   488b8424b8000000     | add                 ebx, dword ptr [esp + 0x48]
            //   498943e0             | dec                 eax
            //   8a8424b0000000       | arpl                bx, si

        $sequence_9 = { 4883ec38 83fa01 7528 488364242800 8364242000 }
            // n = 5, score = 100
            //   4883ec38             | lea                 ecx, [esp + 0x410]
            //   83fa01               | dec                 eax
            //   7528                 | lea                 ecx, [esp + 0x410]
            //   488364242800         | dec                 eax
            //   8364242000           | lea                 ecx, [esp + 0x312]

    condition:
        7 of them and filesize < 422912
}