rule win_eddiestealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.eddiestealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.eddiestealer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4c3ba42498000000 0f84da010000 498d7c2410 49897f40 488b842488000000 4c8b28 488b842490000000 }
            // n = 7, score = 100
            //   4c3ba42498000000     | dec                 eax
            //   0f84da010000         | mov                 dword ptr [ebx + 8], eax
            //   498d7c2410           | dec                 eax
            //   49897f40             | lea                 eax, [0x3316e]
            //   488b842488000000     | dec                 eax
            //   4c8b28               | lea                 edx, [esp + 0x30]
            //   488b842490000000     | dec                 eax

        $sequence_1 = { b808000000 488d0d6faf0500 48894d00 48895d08 48894510 0f117518 488dbc24500c0000 }
            // n = 7, score = 100
            //   b808000000           | dec                 ebp
            //   488d0d6faf0500       | mov                 dword ptr [eax], ebp
            //   48894d00             | dec                 eax
            //   48895d08             | lea                 eax, [0x7b36f]
            //   48894510             | dec                 eax
            //   0f117518             | mov                 dword ptr [esp + 0x20], eax
            //   488dbc24500c0000     | dec                 eax

        $sequence_2 = { 4d39d3 4c89d1 490f47cb 4584ff 490f45cb 4c0f45d7 4c8b5c2440 }
            // n = 7, score = 100
            //   4d39d3               | mov                 edx, 0x2b
            //   4c89d1               | dec                 ecx
            //   490f47cb             | mov                 dword ptr [eax], eax
            //   4584ff               | inc                 ecx
            //   490f45cb             | mov                 byte ptr [eax + 8], cl
            //   4c0f45d7             | dec                 eax
            //   4c8b5c2440           | lea                 eax, [0x75b57]

        $sequence_3 = { 8b542430 e8???????? 0fb66802 440fb738 4181f7aafa0000 4080f544 b903000000 }
            // n = 7, score = 100
            //   8b542430             | movzx               ebx, byte ptr [ecx + edx]
            //   e8????????           |                     
            //   0fb66802             | inc                 esp
            //   440fb738             | add                 edx, ebx
            //   4181f7aafa0000       | dec                 esp
            //   4080f544             | lea                 edx, [0x77ff]
            //   b903000000           | dec                 eax

        $sequence_4 = { e8???????? 660fefc0 488365f000 660f7f45d0 660f7f45e0 31c9 488d1578820600 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   660fefc0             | inc                 edx
            //   488365f000           | mov                 eax, dword ptr [ecx + ecx*4 - 4]
            //   660f7f45d0           | je                  0xcb5
            //   660f7f45e0           | inc                 ecx
            //   31c9                 | mov                 esp, 0x10
            //   488d1578820600       | dec                 ebp

        $sequence_5 = { 7720 4c8b0411 4c330408 4c89440c30 4883c108 ebe7 488bb42400010000 }
            // n = 7, score = 100
            //   7720                 | mov                 dword ptr [esi], eax
            //   4c8b0411             | mov                 edi, 2
            //   4c330408             | dec                 eax
            //   4c89440c30           | mov                 dword ptr [esi + 8], edi
            //   4883c108             | dec                 eax
            //   ebe7                 | and                 dword ptr [esi + 0x20], 0
            //   488bb42400010000     | dec                 esp

        $sequence_6 = { e8???????? 668932 4889842488000000 4889942490000000 48c784249800000002000000 c68424a000000005 0f108424b0020000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   668932               | jae                 0x3b1
            //   4889842488000000     | je                  0x352
            //   4889942490000000     | mov                 ecx, esi
            //   48c784249800000002000000     | inc    ecx
            //   c68424a000000005     | or                  esi, 0xffffffff
            //   0f108424b0020000     | dec                 eax

        $sequence_7 = { e8???????? e8???????? 488b4808 48898c2448010000 488b4010 4889842438010000 488d055e330300 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   e8????????           |                     
            //   488b4808             | shl                 eax, 0x10
            //   48898c2448010000     | movzx               ecx, word ptr [esp + 0x275]
            //   488b4010             | or                  ecx, eax
            //   4889842438010000     | jne                 0x197e
            //   488d055e330300       | dec                 eax

        $sequence_8 = { c1e80c 31d0 89c2 c1ea10 31c2 69c2fad30000 0fb7c0 }
            // n = 7, score = 100
            //   c1e80c               | dec                 ebp
            //   31d0                 | test                edi, edi
            //   89c2                 | je                  0x2b5
            //   c1ea10               | dec                 eax
            //   31c2                 | mov                 dword ptr [ebp + 0x50], edi
            //   69c2fad30000         | inc                 ebp
            //   0fb7c0               | xor                 ebp, ebp

        $sequence_9 = { 31d2 488d0d72810400 49b8001927cf2367fead 41f6c101 741c 440fb60c0a 4d09c1 }
            // n = 7, score = 100
            //   31d2                 | dec                 eax
            //   488d0d72810400       | mov                 dword ptr [ebp + 0x5c8], eax
            //   49b8001927cf2367fead     | dec    eax
            //   41f6c101             | mov                 dword ptr [ebp + 0x5d0], 3
            //   741c                 | dec                 eax
            //   440fb60c0a           | lea                 eax, [ebp + 0x5c0]
            //   4d09c1               | push                0x28

    condition:
        7 of them and filesize < 1316864
}