rule win_edr_silencer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.edr_silencer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.edr_silencer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 898524030000 83bd2403000000 0f84b1000000 83bd2403000005 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   898524030000         | lea                 ecx, [0xf2a0]
            //   83bd2403000000       | dec                 eax
            //   0f84b1000000         | lea                 ecx, [0xc9a3]
            //   83bd2403000005       | dec                 eax

        $sequence_1 = { e8???????? 85c0 0f84b7000000 4183ee57 4189fd 6690 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   85c0                 | add                 dword ptr [eax], edx
            //   0f84b7000000         | add                 byte ptr [eax], al
            //   4183ee57             | mov                 dword ptr [ebp - 0x50], 0xd78e1e87
            //   4189fd               | mov                 word ptr [ebp + 0x66], 0x4c33
            //   6690                 | dec                 eax

        $sequence_2 = { 488d154a7b0000 89442420 488d4c243e 480f44da 4c89e2 }
            // n = 5, score = 100
            //   488d154a7b0000       | cmp                 dword ptr [ebp + 0x20], eax
            //   89442420             | jbe                 0x5bd
            //   488d4c243e           | dec                 eax
            //   480f44da             | mov                 eax, dword ptr [ebp - 8]
            //   4c89e2               | dec                 eax

        $sequence_3 = { 4889c1 488b05???????? ffd0 b801000000 4883c450 }
            // n = 5, score = 100
            //   4889c1               | lea                 eax, [ebp + 0x310]
            //   488b05????????       |                     
            //   ffd0                 | test                eax, eax
            //   b801000000           | je                  0x93f
            //   4883c450             | dec                 eax

        $sequence_4 = { 488b85d8010000 488b00 488b4008 4885c0 }
            // n = 4, score = 100
            //   488b85d8010000       | mov                 eax, dword ptr [eax + 8]
            //   488b00               | dec                 eax
            //   488b4008             | lea                 edx, [ebp - 0x60]
            //   4885c0               | dec                 ecx

        $sequence_5 = { e8???????? b801000000 e9???????? e8???????? 85c0 750a b801000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   b801000000           | lea                 ebp, [esp + 0x80]
            //   e9????????           |                     
            //   e8????????           |                     
            //   85c0                 | dec                 eax
            //   750a                 | mov                 dword ptr [ebp + 0x200], ecx
            //   b801000000           | dec                 eax

        $sequence_6 = { 4889c1 e8???????? 8945f8 837df800 7416 8b45f8 }
            // n = 6, score = 100
            //   4889c1               | dec                 eax
            //   e8????????           |                     
            //   8945f8               | lea                 eax, [esp + 0x48]
            //   837df800             | dec                 eax
            //   7416                 | lea                 ecx, [0x8b0b]
            //   8b45f8               | and                 ecx, 0x8000

        $sequence_7 = { b900000000 e8???????? 8945f8 837df800 7416 8b45f8 }
            // n = 6, score = 100
            //   b900000000           | mov                 ecx, ebx
            //   e8????????           |                     
            //   8945f8               | dec                 eax
            //   837df800             | lea                 edx, [0xc17a]
            //   7416                 | movsd               qword ptr [esp + 0x28], xmm7
            //   8b45f8               | dec                 eax

        $sequence_8 = { 48894558 488b8518030000 488d4db0 488d5510 4989c9 }
            // n = 5, score = 100
            //   48894558             | lea                 eax, [ebp + 0x460]
            //   488b8518030000       | dec                 eax
            //   488d4db0             | mov                 dword ptr [esp + 0x20], eax
            //   488d5510             | inc                 ecx
            //   4989c9               | mov                 ecx, 0

        $sequence_9 = { 488b05???????? ffd0 89c2 488d0d5fc70000 }
            // n = 4, score = 100
            //   488b05????????       |                     
            //   ffd0                 | lea                 edx, [ebp - 0x20]
            //   89c2                 | dec                 eax
            //   488d0d5fc70000       | mov                 dword ptr [esp + 0x20], ecx

    condition:
        7 of them and filesize < 744448
}