rule win_ehdevel_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ehdevel."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ehdevel"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c5 8945fc 57 8bf9 8d85ece7ffff 50 8d8dfcf7ffff }
            // n = 7, score = 100
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   57                   | push                edi
            //   8bf9                 | mov                 edi, ecx
            //   8d85ece7ffff         | lea                 eax, [ebp - 0x1814]
            //   50                   | push                eax
            //   8d8dfcf7ffff         | lea                 ecx, [ebp - 0x804]

        $sequence_1 = { 85c0 7524 a1???????? a3???????? a1???????? c705????????d22f0110 8935???????? }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   7524                 | jne                 0x26
            //   a1????????           |                     
            //   a3????????           |                     
            //   a1????????           |                     
            //   c705????????d22f0110     |     
            //   8935????????         |                     

        $sequence_2 = { 51 e8???????? 83c40c 56 8d95e8fbffff 6804010000 }
            // n = 6, score = 100
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   56                   | push                esi
            //   8d95e8fbffff         | lea                 edx, [ebp - 0x418]
            //   6804010000           | push                0x104

        $sequence_3 = { 8b3d???????? c60301 ffd7 56 ff15???????? 56 ffd7 }
            // n = 7, score = 100
            //   8b3d????????         |                     
            //   c60301               | mov                 byte ptr [ebx], 1
            //   ffd7                 | call                edi
            //   56                   | push                esi
            //   ff15????????         |                     
            //   56                   | push                esi
            //   ffd7                 | call                edi

        $sequence_4 = { 8985e8f7ffff 897e10 897e14 c645fc03 399d94f7ffff 720f 8b8d80f7ffff }
            // n = 7, score = 100
            //   8985e8f7ffff         | mov                 dword ptr [ebp - 0x818], eax
            //   897e10               | mov                 dword ptr [esi + 0x10], edi
            //   897e14               | mov                 dword ptr [esi + 0x14], edi
            //   c645fc03             | mov                 byte ptr [ebp - 4], 3
            //   399d94f7ffff         | cmp                 dword ptr [ebp - 0x86c], ebx
            //   720f                 | jb                  0x11
            //   8b8d80f7ffff         | mov                 ecx, dword ptr [ebp - 0x880]

        $sequence_5 = { 8d8dfcf7ffff 51 e8???????? 83c410 84c0 7502 32db }
            // n = 7, score = 100
            //   8d8dfcf7ffff         | lea                 ecx, [ebp - 0x804]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   84c0                 | test                al, al
            //   7502                 | jne                 4
            //   32db                 | xor                 bl, bl

        $sequence_6 = { 8b8dd48bffff 6a00 6880000000 6a04 6a00 6a00 6a04 }
            // n = 7, score = 100
            //   8b8dd48bffff         | mov                 ecx, dword ptr [ebp - 0x742c]
            //   6a00                 | push                0
            //   6880000000           | push                0x80
            //   6a04                 | push                4
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a04                 | push                4

        $sequence_7 = { eb19 8b4c2414 8b4904 8b440c4c 8d4c0c14 f7d8 }
            // n = 6, score = 100
            //   eb19                 | jmp                 0x1b
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   8b4904               | mov                 ecx, dword ptr [ecx + 4]
            //   8b440c4c             | mov                 eax, dword ptr [esp + ecx + 0x4c]
            //   8d4c0c14             | lea                 ecx, [esp + ecx + 0x14]
            //   f7d8                 | neg                 eax

        $sequence_8 = { 33d2 8955fc 3bca 7458 33f6 52 c7411407000000 }
            // n = 7, score = 100
            //   33d2                 | xor                 edx, edx
            //   8955fc               | mov                 dword ptr [ebp - 4], edx
            //   3bca                 | cmp                 ecx, edx
            //   7458                 | je                  0x5a
            //   33f6                 | xor                 esi, esi
            //   52                   | push                edx
            //   c7411407000000       | mov                 dword ptr [ecx + 0x14], 7

        $sequence_9 = { c745f463006f00 c745f86d000000 e8???????? 3c01 7441 }
            // n = 5, score = 100
            //   c745f463006f00       | mov                 dword ptr [ebp - 0xc], 0x6f0063
            //   c745f86d000000       | mov                 dword ptr [ebp - 8], 0x6d
            //   e8????????           |                     
            //   3c01                 | cmp                 al, 1
            //   7441                 | je                  0x43

    condition:
        7 of them and filesize < 524288
}