rule win_enfal_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.enfal."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.enfal"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8d8648020000 68???????? 50 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   8d8648020000         | lea                 eax, [esi + 0x248]
            //   68????????           |                     
            //   50                   | push                eax

        $sequence_1 = { bffe010000 eb05 bff4010000 8bc7 5e eb02 }
            // n = 6, score = 200
            //   bffe010000           | mov                 edi, 0x1fe
            //   eb05                 | jmp                 7
            //   bff4010000           | mov                 edi, 0x1f4
            //   8bc7                 | mov                 eax, edi
            //   5e                   | pop                 esi
            //   eb02                 | jmp                 4

        $sequence_2 = { 51 8d8de8fcffff 51 53 ff505c 85c0 }
            // n = 6, score = 200
            //   51                   | push                ecx
            //   8d8de8fcffff         | lea                 ecx, [ebp - 0x318]
            //   51                   | push                ecx
            //   53                   | push                ebx
            //   ff505c               | call                dword ptr [eax + 0x5c]
            //   85c0                 | test                eax, eax

        $sequence_3 = { 8d85b4fdffff 68???????? 50 e8???????? 8d85b4fdffff 57 }
            // n = 6, score = 200
            //   8d85b4fdffff         | lea                 eax, [ebp - 0x24c]
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d85b4fdffff         | lea                 eax, [ebp - 0x24c]
            //   57                   | push                edi

        $sequence_4 = { 8bec 81eccc040000 53 56 8b35???????? 57 }
            // n = 6, score = 200
            //   8bec                 | mov                 ebp, esp
            //   81eccc040000         | sub                 esp, 0x4cc
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8b35????????         |                     
            //   57                   | push                edi

        $sequence_5 = { 89430c ffd6 8b4b1c 68???????? 57 }
            // n = 5, score = 200
            //   89430c               | mov                 dword ptr [ebx + 0xc], eax
            //   ffd6                 | call                esi
            //   8b4b1c               | mov                 ecx, dword ptr [ebx + 0x1c]
            //   68????????           |                     
            //   57                   | push                edi

        $sequence_6 = { 50 e8???????? 8d8628020000 68???????? }
            // n = 4, score = 200
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d8628020000         | lea                 eax, [esi + 0x228]
            //   68????????           |                     

        $sequence_7 = { 0fb645da 8d0480 8dbc0059020000 eb54 8b8548ffffff }
            // n = 5, score = 200
            //   0fb645da             | movzx               eax, byte ptr [ebp - 0x26]
            //   8d0480               | lea                 eax, [eax + eax*4]
            //   8dbc0059020000       | lea                 edi, [eax + eax + 0x259]
            //   eb54                 | jmp                 0x56
            //   8b8548ffffff         | mov                 eax, dword ptr [ebp - 0xb8]

        $sequence_8 = { 6a01 57 ff15???????? 8bf0 85f6 0f848e000000 8b4624 }
            // n = 7, score = 200
            //   6a01                 | push                1
            //   57                   | push                edi
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   0f848e000000         | je                  0x94
            //   8b4624               | mov                 eax, dword ptr [esi + 0x24]

        $sequence_9 = { 57 8901 ffd6 8b4b1c 68???????? 57 }
            // n = 6, score = 200
            //   57                   | push                edi
            //   8901                 | mov                 dword ptr [ecx], eax
            //   ffd6                 | call                esi
            //   8b4b1c               | mov                 ecx, dword ptr [ebx + 0x1c]
            //   68????????           |                     
            //   57                   | push                edi

    condition:
        7 of them and filesize < 65536
}