rule win_erbium_stealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.erbium_stealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.erbium_stealer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 75f8 ba???????? b926000000 2bd0 }
            // n = 4, score = 100
            //   75f8                 | jne                 0xfffffffa
            //   ba????????           |                     
            //   b926000000           | mov                 ecx, 0x26
            //   2bd0                 | sub                 edx, eax

        $sequence_1 = { 7409 83c002 66833800 75f7 668b4c2450 6685c9 7418 }
            // n = 7, score = 100
            //   7409                 | je                  0xb
            //   83c002               | add                 eax, 2
            //   66833800             | cmp                 word ptr [eax], 0
            //   75f7                 | jne                 0xfffffff9
            //   668b4c2450           | mov                 cx, word ptr [esp + 0x50]
            //   6685c9               | test                cx, cx
            //   7418                 | je                  0x1a

        $sequence_2 = { 6a04 6800200000 23f0 56 6a00 ff15???????? }
            // n = 6, score = 100
            //   6a04                 | push                4
            //   6800200000           | push                0x2000
            //   23f0                 | and                 esi, eax
            //   56                   | push                esi
            //   6a00                 | push                0
            //   ff15????????         |                     

        $sequence_3 = { ff15???????? 8945bc 68???????? 8b55f4 52 }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   8945bc               | mov                 dword ptr [ebp - 0x44], eax
            //   68????????           |                     
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   52                   | push                edx

        $sequence_4 = { eb96 6a04 6800300000 6a18 6a00 8b4508 50 }
            // n = 7, score = 100
            //   eb96                 | jmp                 0xffffff98
            //   6a04                 | push                4
            //   6800300000           | push                0x3000
            //   6a18                 | push                0x18
            //   6a00                 | push                0
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   50                   | push                eax

        $sequence_5 = { 52 8b4508 50 ff55bc 33c9 }
            // n = 5, score = 100
            //   52                   | push                edx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   50                   | push                eax
            //   ff55bc               | call                dword ptr [ebp - 0x44]
            //   33c9                 | xor                 ecx, ecx

        $sequence_6 = { 668b8c24a0020000 6685c9 741b 8d9424a0020000 0fb7c9 2bd0 668908 }
            // n = 7, score = 100
            //   668b8c24a0020000     | mov                 cx, word ptr [esp + 0x2a0]
            //   6685c9               | test                cx, cx
            //   741b                 | je                  0x1d
            //   8d9424a0020000       | lea                 edx, [esp + 0x2a0]
            //   0fb7c9               | movzx               ecx, cx
            //   2bd0                 | sub                 edx, eax
            //   668908               | mov                 word ptr [eax], cx

        $sequence_7 = { ff55b8 c745cc00000000 837dcc00 0f85a2000000 c745c400000000 8d4dc4 51 }
            // n = 7, score = 100
            //   ff55b8               | call                dword ptr [ebp - 0x48]
            //   c745cc00000000       | mov                 dword ptr [ebp - 0x34], 0
            //   837dcc00             | cmp                 dword ptr [ebp - 0x34], 0
            //   0f85a2000000         | jne                 0xa8
            //   c745c400000000       | mov                 dword ptr [ebp - 0x3c], 0
            //   8d4dc4               | lea                 ecx, [ebp - 0x3c]
            //   51                   | push                ecx

        $sequence_8 = { 75f8 668b8c24a0020000 6685c9 741b 8d9424a0020000 }
            // n = 5, score = 100
            //   75f8                 | jne                 0xfffffffa
            //   668b8c24a0020000     | mov                 cx, word ptr [esp + 0x2a0]
            //   6685c9               | test                cx, cx
            //   741b                 | je                  0x1d
            //   8d9424a0020000       | lea                 edx, [esp + 0x2a0]

        $sequence_9 = { 8b55f8 8b45fc 0302 8b4de0 0fb711 81e2ff0f0000 }
            // n = 6, score = 100
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   0302                 | add                 eax, dword ptr [edx]
            //   8b4de0               | mov                 ecx, dword ptr [ebp - 0x20]
            //   0fb711               | movzx               edx, word ptr [ecx]
            //   81e2ff0f0000         | and                 edx, 0xfff

    condition:
        7 of them and filesize < 33792
}