rule win_erebus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.erebus."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.erebus"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 51 53 50 52 8bcf e8???????? 837d1c08 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   53                   | push                ebx
            //   50                   | push                eax
            //   52                   | push                edx
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   837d1c08             | cmp                 dword ptr [ebp + 0x1c], 8

        $sequence_1 = { 32db eb02 b301 57 e8???????? 83c404 c7442420ffffffff }
            // n = 7, score = 100
            //   32db                 | xor                 bl, bl
            //   eb02                 | jmp                 4
            //   b301                 | mov                 bl, 1
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   c7442420ffffffff     | mov                 dword ptr [esp + 0x20], 0xffffffff

        $sequence_2 = { 83c430 837dec10 720b ff75d8 e8???????? 83c404 837d1c10 }
            // n = 7, score = 100
            //   83c430               | add                 esp, 0x30
            //   837dec10             | cmp                 dword ptr [ebp - 0x14], 0x10
            //   720b                 | jb                  0xd
            //   ff75d8               | push                dword ptr [ebp - 0x28]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   837d1c10             | cmp                 dword ptr [ebp + 0x1c], 0x10

        $sequence_3 = { 55 57 8bf9 3bfa 7412 8d049d00000000 50 }
            // n = 7, score = 100
            //   55                   | push                ebp
            //   57                   | push                edi
            //   8bf9                 | mov                 edi, ecx
            //   3bfa                 | cmp                 edi, edx
            //   7412                 | je                  0x14
            //   8d049d00000000       | lea                 eax, [ebx*4]
            //   50                   | push                eax

        $sequence_4 = { 732f 8a80c4244f00 8d4da8 88857cfeffff ffb57cfeffff 6a01 e8???????? }
            // n = 7, score = 100
            //   732f                 | jae                 0x31
            //   8a80c4244f00         | mov                 al, byte ptr [eax + 0x4f24c4]
            //   8d4da8               | lea                 ecx, [ebp - 0x58]
            //   88857cfeffff         | mov                 byte ptr [ebp - 0x184], al
            //   ffb57cfeffff         | push                dword ptr [ebp - 0x184]
            //   6a01                 | push                1
            //   e8????????           |                     

        $sequence_5 = { 8d4e38 e8???????? 8d87e4000000 50 8d8ee4000000 e8???????? 5f }
            // n = 7, score = 100
            //   8d4e38               | lea                 ecx, [esi + 0x38]
            //   e8????????           |                     
            //   8d87e4000000         | lea                 eax, [edi + 0xe4]
            //   50                   | push                eax
            //   8d8ee4000000         | lea                 ecx, [esi + 0xe4]
            //   e8????????           |                     
            //   5f                   | pop                 edi

        $sequence_6 = { 8b542410 f30f6f40f0 83c708 8d4920 8d4020 660f380005???????? f30f7f41e0 }
            // n = 7, score = 100
            //   8b542410             | mov                 edx, dword ptr [esp + 0x10]
            //   f30f6f40f0           | movdqu              xmm0, xmmword ptr [eax - 0x10]
            //   83c708               | add                 edi, 8
            //   8d4920               | lea                 ecx, [ecx + 0x20]
            //   8d4020               | lea                 eax, [eax + 0x20]
            //   660f380005????????     |     
            //   f30f7f41e0           | movdqu              xmmword ptr [ecx - 0x20], xmm0

        $sequence_7 = { 83c40c 8b4610 89442444 8b542450 33c0 8b742454 8bca }
            // n = 7, score = 100
            //   83c40c               | add                 esp, 0xc
            //   8b4610               | mov                 eax, dword ptr [esi + 0x10]
            //   89442444             | mov                 dword ptr [esp + 0x44], eax
            //   8b542450             | mov                 edx, dword ptr [esp + 0x50]
            //   33c0                 | xor                 eax, eax
            //   8b742454             | mov                 esi, dword ptr [esp + 0x54]
            //   8bca                 | mov                 ecx, edx

        $sequence_8 = { 83f905 7d10 668b444b0c 6689044d0c775200 41 ebe8 8bce }
            // n = 7, score = 100
            //   83f905               | cmp                 ecx, 5
            //   7d10                 | jge                 0x12
            //   668b444b0c           | mov                 ax, word ptr [ebx + ecx*2 + 0xc]
            //   6689044d0c775200     | mov                 word ptr [ecx*2 + 0x52770c], ax
            //   41                   | inc                 ecx
            //   ebe8                 | jmp                 0xffffffea
            //   8bce                 | mov                 ecx, esi

        $sequence_9 = { bd20000000 83c6fc 2be9 03f2 8b16 8d76fc }
            // n = 6, score = 100
            //   bd20000000           | mov                 ebp, 0x20
            //   83c6fc               | add                 esi, -4
            //   2be9                 | sub                 ebp, ecx
            //   03f2                 | add                 esi, edx
            //   8b16                 | mov                 edx, dword ptr [esi]
            //   8d76fc               | lea                 esi, [esi - 4]

    condition:
        7 of them and filesize < 2564096
}