rule win_eternal_petya_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.eternal_petya."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.eternal_petya"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d4644 50 53 6a02 }
            // n = 4, score = 400
            //   8d4644               | lea                 eax, [esi + 0x44]
            //   50                   | push                eax
            //   53                   | push                ebx
            //   6a02                 | push                2

        $sequence_1 = { 8bec 51 57 68000000f0 6a18 33ff }
            // n = 6, score = 400
            //   8bec                 | mov                 ebp, esp
            //   51                   | push                ecx
            //   57                   | push                edi
            //   68000000f0           | push                0xf0000000
            //   6a18                 | push                0x18
            //   33ff                 | xor                 edi, edi

        $sequence_2 = { 68f0000000 6a40 ff15???????? 8bd8 }
            // n = 4, score = 400
            //   68f0000000           | push                0xf0
            //   6a40                 | push                0x40
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax

        $sequence_3 = { 57 68000000f0 6a18 33ff }
            // n = 4, score = 400
            //   57                   | push                edi
            //   68000000f0           | push                0xf0000000
            //   6a18                 | push                0x18
            //   33ff                 | xor                 edi, edi

        $sequence_4 = { 55 8bec 51 57 68000000f0 }
            // n = 5, score = 400
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   51                   | push                ecx
            //   57                   | push                edi
            //   68000000f0           | push                0xf0000000

        $sequence_5 = { 55 8bec 51 57 68000000f0 6a18 }
            // n = 6, score = 400
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   51                   | push                ecx
            //   57                   | push                edi
            //   68000000f0           | push                0xf0000000
            //   6a18                 | push                0x18

        $sequence_6 = { 53 8d4644 50 53 }
            // n = 4, score = 400
            //   53                   | push                ebx
            //   8d4644               | lea                 eax, [esi + 0x44]
            //   50                   | push                eax
            //   53                   | push                ebx

        $sequence_7 = { 55 8bec 51 57 68000000f0 6a18 33ff }
            // n = 7, score = 400
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   51                   | push                ecx
            //   57                   | push                edi
            //   68000000f0           | push                0xf0000000
            //   6a18                 | push                0x18
            //   33ff                 | xor                 edi, edi

        $sequence_8 = { 51 57 68000000f0 6a18 }
            // n = 4, score = 400
            //   51                   | push                ecx
            //   57                   | push                edi
            //   68000000f0           | push                0xf0000000
            //   6a18                 | push                0x18

        $sequence_9 = { 53 68f0000000 6a40 ff15???????? }
            // n = 4, score = 400
            //   53                   | push                ebx
            //   68f0000000           | push                0xf0
            //   6a40                 | push                0x40
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 851968
}