rule win_evilbunny_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.evilbunny."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.evilbunny"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb37 6a00 8b4df4 2b4d0c 51 8b55fc 8b4218 }
            // n = 7, score = 200
            //   eb37                 | jmp                 0x39
            //   6a00                 | push                0
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   2b4d0c               | sub                 ecx, dword ptr [ebp + 0xc]
            //   51                   | push                ecx
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8b4218               | mov                 eax, dword ptr [edx + 0x18]

        $sequence_1 = { 2b45e4 1b55e8 8945a0 8955a4 eb0e c745a000000000 c745a400000000 }
            // n = 7, score = 200
            //   2b45e4               | sub                 eax, dword ptr [ebp - 0x1c]
            //   1b55e8               | sbb                 edx, dword ptr [ebp - 0x18]
            //   8945a0               | mov                 dword ptr [ebp - 0x60], eax
            //   8955a4               | mov                 dword ptr [ebp - 0x5c], edx
            //   eb0e                 | jmp                 0x10
            //   c745a000000000       | mov                 dword ptr [ebp - 0x60], 0
            //   c745a400000000       | mov                 dword ptr [ebp - 0x5c], 0

        $sequence_2 = { 8b55f8 8b4218 8b550c 891401 8b450c 0fb64805 83e103 }
            // n = 7, score = 200
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   8b4218               | mov                 eax, dword ptr [edx + 0x18]
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   891401               | mov                 dword ptr [ecx + eax], edx
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   0fb64805             | movzx               ecx, byte ptr [eax + 5]
            //   83e103               | and                 ecx, 3

        $sequence_3 = { 8b5518 c1e20e 0bc2 50 8b4508 50 e8???????? }
            // n = 7, score = 200
            //   8b5518               | mov                 edx, dword ptr [ebp + 0x18]
            //   c1e20e               | shl                 edx, 0xe
            //   0bc2                 | or                  eax, edx
            //   50                   | push                eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_4 = { 8d8c3a4b661aa8 894df8 8b95ccfeffff c1ea02 8b85ccfeffff c1e01e 0bd0 }
            // n = 7, score = 200
            //   8d8c3a4b661aa8       | lea                 ecx, [edx + edi - 0x57e599b5]
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   8b95ccfeffff         | mov                 edx, dword ptr [ebp - 0x134]
            //   c1ea02               | shr                 edx, 2
            //   8b85ccfeffff         | mov                 eax, dword ptr [ebp - 0x134]
            //   c1e01e               | shl                 eax, 0x1e
            //   0bd0                 | or                  edx, eax

        $sequence_5 = { 55 8bec 51 8b4508 8b4824 034d0c 894dfc }
            // n = 7, score = 200
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   51                   | push                ecx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b4824               | mov                 ecx, dword ptr [eax + 0x24]
            //   034d0c               | add                 ecx, dword ptr [ebp + 0xc]
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx

        $sequence_6 = { e8???????? 8b55f8 c782060c000001000000 33c0 52 8bcd 50 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   c782060c000001000000     | mov    dword ptr [edx + 0xc06], 1
            //   33c0                 | xor                 eax, eax
            //   52                   | push                edx
            //   8bcd                 | mov                 ecx, ebp
            //   50                   | push                eax

        $sequence_7 = { e8???????? 8b858cfeffff 52 8bcd 50 8d1540f91000 e8???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8b858cfeffff         | mov                 eax, dword ptr [ebp - 0x174]
            //   52                   | push                edx
            //   8bcd                 | mov                 ecx, ebp
            //   50                   | push                eax
            //   8d1540f91000         | lea                 edx, [0x10f940]
            //   e8????????           |                     

        $sequence_8 = { e8???????? 83c408 8b4dfc 51 8b95e4fdffff 52 8d85e8fdffff }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   51                   | push                ecx
            //   8b95e4fdffff         | mov                 edx, dword ptr [ebp - 0x21c]
            //   52                   | push                edx
            //   8d85e8fdffff         | lea                 eax, [ebp - 0x218]

        $sequence_9 = { 8b5508 8b4238 89413c 8b4d08 8a5510 885136 b801000000 }
            // n = 7, score = 200
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b4238               | mov                 eax, dword ptr [edx + 0x38]
            //   89413c               | mov                 dword ptr [ecx + 0x3c], eax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8a5510               | mov                 dl, byte ptr [ebp + 0x10]
            //   885136               | mov                 byte ptr [ecx + 0x36], dl
            //   b801000000           | mov                 eax, 1

    condition:
        7 of them and filesize < 1695744
}