rule win_evilconwi_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.evilconwi."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.evilconwi"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c8ff eb07 8b04cd54e14000 5f 5e 5b }
            // n = 6, score = 100
            //   83c8ff               | or                  eax, 0xffffffff
            //   eb07                 | jmp                 9
            //   8b04cd54e14000       | mov                 eax, dword ptr [ecx*8 + 0x40e154]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_1 = { eb3d 8b0b 894dfc 8d048dac1b4100 8b30 90 }
            // n = 6, score = 100
            //   eb3d                 | jmp                 0x3f
            //   8b0b                 | mov                 ecx, dword ptr [ebx]
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   8d048dac1b4100       | lea                 eax, [ecx*4 + 0x411bac]
            //   8b30                 | mov                 esi, dword ptr [eax]
            //   90                   | nop                 

        $sequence_2 = { c700???????? 8b4508 898850030000 8b4508 59 c7404898134100 8b4508 }
            // n = 7, score = 100
            //   c700????????         |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   898850030000         | mov                 dword ptr [eax + 0x350], ecx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   59                   | pop                 ecx
            //   c7404898134100       | mov                 dword ptr [eax + 0x48], 0x411398
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_3 = { 56 57 8d1c85f01e4100 8b03 8b15???????? 83cfff }
            // n = 6, score = 100
            //   56                   | push                esi
            //   57                   | push                edi
            //   8d1c85f01e4100       | lea                 ebx, [eax*4 + 0x411ef0]
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   8b15????????         |                     
            //   83cfff               | or                  edi, 0xffffffff

        $sequence_4 = { 72eb 6a00 ff75e4 ff15???????? ff75d0 }
            // n = 5, score = 100
            //   72eb                 | jb                  0xffffffed
            //   6a00                 | push                0
            //   ff75e4               | push                dword ptr [ebp - 0x1c]
            //   ff15????????         |                     
            //   ff75d0               | push                dword ptr [ebp - 0x30]

        $sequence_5 = { 50 6a00 6a0b ff75f8 ffd7 85c0 0f84a6000000 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6a0b                 | push                0xb
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax
            //   0f84a6000000         | je                  0xac

        $sequence_6 = { 660f58e0 660fc5c400 25f0070000 660f28a060f74000 660f28b850f34000 }
            // n = 5, score = 100
            //   660f58e0             | addpd               xmm4, xmm0
            //   660fc5c400           | pextrw              eax, xmm4, 0
            //   25f0070000           | and                 eax, 0x7f0
            //   660f28a060f74000     | movapd              xmm4, xmmword ptr [eax + 0x40f760]
            //   660f28b850f34000     | movapd              xmm7, xmmword ptr [eax + 0x40f350]

        $sequence_7 = { 8b45fc 03148d781f4100 8b00 894218 8a03 884228 }
            // n = 6, score = 100
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   03148d781f4100       | add                 edx, dword ptr [ecx*4 + 0x411f78]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   894218               | mov                 dword ptr [edx + 0x18], eax
            //   8a03                 | mov                 al, byte ptr [ebx]
            //   884228               | mov                 byte ptr [edx + 0x28], al

        $sequence_8 = { 50 8d45fc c745dc04000000 50 6a00 6a0b }
            // n = 6, score = 100
            //   50                   | push                eax
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   c745dc04000000       | mov                 dword ptr [ebp - 0x24], 4
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6a0b                 | push                0xb

        $sequence_9 = { 8b04bd781f4100 807c302900 7504 32c0 eb1a 8d45fc 50 }
            // n = 7, score = 100
            //   8b04bd781f4100       | mov                 eax, dword ptr [edi*4 + 0x411f78]
            //   807c302900           | cmp                 byte ptr [eax + esi + 0x29], 0
            //   7504                 | jne                 6
            //   32c0                 | xor                 al, al
            //   eb1a                 | jmp                 0x1c
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax

    condition:
        7 of them and filesize < 172032
}