rule win_evilgrab_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.evilgrab."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.evilgrab"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b08 50 ff5108 83c8ff e9???????? 8b442410 50 }
            // n = 7, score = 200
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   50                   | push                eax
            //   ff5108               | call                dword ptr [ecx + 8]
            //   83c8ff               | or                  eax, 0xffffffff
            //   e9????????           |                     
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   50                   | push                eax

        $sequence_1 = { ff15???????? 894320 83f8ff 741e c785dce6ffff00000000 c6431601 6a46 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   894320               | mov                 dword ptr [ebx + 0x20], eax
            //   83f8ff               | cmp                 eax, -1
            //   741e                 | je                  0x20
            //   c785dce6ffff00000000     | mov    dword ptr [ebp - 0x1924], 0
            //   c6431601             | mov                 byte ptr [ebx + 0x16], 1
            //   6a46                 | push                0x46

        $sequence_2 = { 0f8437feffff 8b442418 50 ff15???????? 5f 5e }
            // n = 6, score = 200
            //   0f8437feffff         | je                  0xfffffe3d
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_3 = { 68ff000000 e8???????? 8bd0 b93f000000 33c0 8bfa f3ab }
            // n = 7, score = 200
            //   68ff000000           | push                0xff
            //   e8????????           |                     
            //   8bd0                 | mov                 edx, eax
            //   b93f000000           | mov                 ecx, 0x3f
            //   33c0                 | xor                 eax, eax
            //   8bfa                 | mov                 edi, edx
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

        $sequence_4 = { 55 56 3bc2 57 bd01000000 0f84ef010000 }
            // n = 6, score = 200
            //   55                   | push                ebp
            //   56                   | push                esi
            //   3bc2                 | cmp                 eax, edx
            //   57                   | push                edi
            //   bd01000000           | mov                 ebp, 1
            //   0f84ef010000         | je                  0x1f5

        $sequence_5 = { c78514f6ffff00000000 b8???????? c3 8b8df0f5ffff 8b5124 89951cf6ffff b8???????? }
            // n = 7, score = 200
            //   c78514f6ffff00000000     | mov    dword ptr [ebp - 0x9ec], 0
            //   b8????????           |                     
            //   c3                   | ret                 
            //   8b8df0f5ffff         | mov                 ecx, dword ptr [ebp - 0xa10]
            //   8b5124               | mov                 edx, dword ptr [ecx + 0x24]
            //   89951cf6ffff         | mov                 dword ptr [ebp - 0x9e4], edx
            //   b8????????           |                     

        $sequence_6 = { ff8db4adffff 0f856dffffff 8d8dc0d2ffff 51 8bcb e8???????? e9???????? }
            // n = 7, score = 200
            //   ff8db4adffff         | dec                 dword ptr [ebp - 0x524c]
            //   0f856dffffff         | jne                 0xffffff73
            //   8d8dc0d2ffff         | lea                 ecx, [ebp - 0x2d40]
            //   51                   | push                ecx
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   e9????????           |                     

        $sequence_7 = { 57 8d8de8adffff 51 8d95dcadffff 52 8d85e0adffff 50 }
            // n = 7, score = 200
            //   57                   | push                edi
            //   8d8de8adffff         | lea                 ecx, [ebp - 0x5218]
            //   51                   | push                ecx
            //   8d95dcadffff         | lea                 edx, [ebp - 0x5224]
            //   52                   | push                edx
            //   8d85e0adffff         | lea                 eax, [ebp - 0x5220]
            //   50                   | push                eax

        $sequence_8 = { 33db 3bfb 7469 8b771c 3bf3 7462 395f20 }
            // n = 7, score = 200
            //   33db                 | xor                 ebx, ebx
            //   3bfb                 | cmp                 edi, ebx
            //   7469                 | je                  0x6b
            //   8b771c               | mov                 esi, dword ptr [edi + 0x1c]
            //   3bf3                 | cmp                 esi, ebx
            //   7462                 | je                  0x64
            //   395f20               | cmp                 dword ptr [edi + 0x20], ebx

        $sequence_9 = { 83f802 0f84ca000000 83f801 7567 3be8 750b 56 }
            // n = 7, score = 200
            //   83f802               | cmp                 eax, 2
            //   0f84ca000000         | je                  0xd0
            //   83f801               | cmp                 eax, 1
            //   7567                 | jne                 0x69
            //   3be8                 | cmp                 ebp, eax
            //   750b                 | jne                 0xd
            //   56                   | push                esi

    condition:
        7 of them and filesize < 327680
}