rule win_evilpony_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.evilpony."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.evilpony"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff74242c ff750c 53 e8???????? 83c418 85c0 7488 }
            // n = 7, score = 200
            //   ff74242c             | push                dword ptr [esp + 0x2c]
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   53                   | push                ebx
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   85c0                 | test                eax, eax
            //   7488                 | je                  0xffffff8a

        $sequence_1 = { 8d442420 50 ff742420 897c242c bbff070000 57 eb50 }
            // n = 7, score = 200
            //   8d442420             | lea                 eax, [esp + 0x20]
            //   50                   | push                eax
            //   ff742420             | push                dword ptr [esp + 0x20]
            //   897c242c             | mov                 dword ptr [esp + 0x2c], edi
            //   bbff070000           | mov                 ebx, 0x7ff
            //   57                   | push                edi
            //   eb50                 | jmp                 0x52

        $sequence_2 = { 897df8 397df4 7654 3bf7 7450 8b4668 6aff }
            // n = 7, score = 200
            //   897df8               | mov                 dword ptr [ebp - 8], edi
            //   397df4               | cmp                 dword ptr [ebp - 0xc], edi
            //   7654                 | jbe                 0x56
            //   3bf7                 | cmp                 esi, edi
            //   7450                 | je                  0x52
            //   8b4668               | mov                 eax, dword ptr [esi + 0x68]
            //   6aff                 | push                -1

        $sequence_3 = { ff15???????? 8bd8 85db 747c 8bc6 }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax
            //   85db                 | test                ebx, ebx
            //   747c                 | je                  0x7e
            //   8bc6                 | mov                 eax, esi

        $sequence_4 = { 837c241c05 750b 53 e8???????? 59 89442428 }
            // n = 6, score = 200
            //   837c241c05           | cmp                 dword ptr [esp + 0x1c], 5
            //   750b                 | jne                 0xd
            //   53                   | push                ebx
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   89442428             | mov                 dword ptr [esp + 0x28], eax

        $sequence_5 = { ff75fc 8bf8 ff15???????? 85c0 7411 56 57 }
            // n = 7, score = 200
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   8bf8                 | mov                 edi, eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7411                 | je                  0x13
            //   56                   | push                esi
            //   57                   | push                edi

        $sequence_6 = { 8d55b8 52 6a10 897dfc 8b08 50 ff510c }
            // n = 7, score = 200
            //   8d55b8               | lea                 edx, [ebp - 0x48]
            //   52                   | push                edx
            //   6a10                 | push                0x10
            //   897dfc               | mov                 dword ptr [ebp - 4], edi
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   50                   | push                eax
            //   ff510c               | call                dword ptr [ecx + 0xc]

        $sequence_7 = { 50 ffd6 83c410 8d8564ffffff 50 ffb500ffffff ffd7 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   83c410               | add                 esp, 0x10
            //   8d8564ffffff         | lea                 eax, [ebp - 0x9c]
            //   50                   | push                eax
            //   ffb500ffffff         | push                dword ptr [ebp - 0x100]
            //   ffd7                 | call                edi

        $sequence_8 = { 85c0 0f8485000000 8365f400 eb06 8b5d08 8b450c 8b0b }
            // n = 7, score = 200
            //   85c0                 | test                eax, eax
            //   0f8485000000         | je                  0x8b
            //   8365f400             | and                 dword ptr [ebp - 0xc], 0
            //   eb06                 | jmp                 8
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8b0b                 | mov                 ecx, dword ptr [ebx]

        $sequence_9 = { 33c5 8945f8 8b450c 8985f0f7ffff }
            // n = 4, score = 200
            //   33c5                 | xor                 eax, ebp
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8985f0f7ffff         | mov                 dword ptr [ebp - 0x810], eax

    condition:
        7 of them and filesize < 147456
}