rule win_exaramel_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.exaramel."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.exaramel"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 7539 a3???????? c705????????01000000 ff15???????? 8b35???????? 68???????? }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   7539                 | jne                 0x3b
            //   a3????????           |                     
            //   c705????????01000000     |     
            //   ff15????????         |                     
            //   8b35????????         |                     
            //   68????????           |                     

        $sequence_1 = { be05400080 e9???????? 8d8528f8ffff 57 50 }
            // n = 5, score = 100
            //   be05400080           | mov                 esi, 0x80004005
            //   e9????????           |                     
            //   8d8528f8ffff         | lea                 eax, [ebp - 0x7d8]
            //   57                   | push                edi
            //   50                   | push                eax

        $sequence_2 = { ff15???????? 85c0 746d 53 57 ff75fc 8b3d???????? }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   746d                 | je                  0x6f
            //   53                   | push                ebx
            //   57                   | push                edi
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   8b3d????????         |                     

        $sequence_3 = { 8b1d???????? 660f1f440000 8b0d???????? 8d85e4fbffff 6aff 6a00 }
            // n = 6, score = 100
            //   8b1d????????         |                     
            //   660f1f440000         | nop                 word ptr [eax + eax]
            //   8b0d????????         |                     
            //   8d85e4fbffff         | lea                 eax, [ebp - 0x41c]
            //   6aff                 | push                -1
            //   6a00                 | push                0

        $sequence_4 = { 742b 8b01 8d55f8 52 51 8b4068 ffd0 }
            // n = 7, score = 100
            //   742b                 | je                  0x2d
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   8d55f8               | lea                 edx, [ebp - 8]
            //   52                   | push                edx
            //   51                   | push                ecx
            //   8b4068               | mov                 eax, dword ptr [eax + 0x68]
            //   ffd0                 | call                eax

        $sequence_5 = { e8???????? c70021000000 e9???????? 894ddc c745e068a54100 e9???????? c745e064a54100 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   c70021000000         | mov                 dword ptr [eax], 0x21
            //   e9????????           |                     
            //   894ddc               | mov                 dword ptr [ebp - 0x24], ecx
            //   c745e068a54100       | mov                 dword ptr [ebp - 0x20], 0x41a568
            //   e9????????           |                     
            //   c745e064a54100       | mov                 dword ptr [ebp - 0x20], 0x41a564

        $sequence_6 = { c1f806 6bc930 8b048560dd4100 f644082801 7406 8b440818 5d }
            // n = 7, score = 100
            //   c1f806               | sar                 eax, 6
            //   6bc930               | imul                ecx, ecx, 0x30
            //   8b048560dd4100       | mov                 eax, dword ptr [eax*4 + 0x41dd60]
            //   f644082801           | test                byte ptr [eax + ecx + 0x28], 1
            //   7406                 | je                  8
            //   8b440818             | mov                 eax, dword ptr [eax + ecx + 0x18]
            //   5d                   | pop                 ebp

        $sequence_7 = { 744e 85f6 7504 33c0 eb18 56 6a00 }
            // n = 7, score = 100
            //   744e                 | je                  0x50
            //   85f6                 | test                esi, esi
            //   7504                 | jne                 6
            //   33c0                 | xor                 eax, eax
            //   eb18                 | jmp                 0x1a
            //   56                   | push                esi
            //   6a00                 | push                0

        $sequence_8 = { 57 e8???????? 8bf0 83c428 85f6 0f881c010000 }
            // n = 6, score = 100
            //   57                   | push                edi
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   83c428               | add                 esp, 0x28
            //   85f6                 | test                esi, esi
            //   0f881c010000         | js                  0x122

        $sequence_9 = { 33c0 668945e8 8b45d4 886de5 8b148560dd4100 }
            // n = 5, score = 100
            //   33c0                 | xor                 eax, eax
            //   668945e8             | mov                 word ptr [ebp - 0x18], ax
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]
            //   886de5               | mov                 byte ptr [ebp - 0x1b], ch
            //   8b148560dd4100       | mov                 edx, dword ptr [eax*4 + 0x41dd60]

    condition:
        7 of them and filesize < 294912
}