rule win_excalibur_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.excalibur."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.excalibur"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4d08 33c0 663b88e4954300 740d 83c002 83f814 72ef }
            // n = 7, score = 100
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   33c0                 | xor                 eax, eax
            //   663b88e4954300       | cmp                 cx, word ptr [eax + 0x4395e4]
            //   740d                 | je                  0xf
            //   83c002               | add                 eax, 2
            //   83f814               | cmp                 eax, 0x14
            //   72ef                 | jb                  0xfffffff1

        $sequence_1 = { eb44 8d0492 c1e003 50 8b450c 50 8b00 }
            // n = 7, score = 100
            //   eb44                 | jmp                 0x46
            //   8d0492               | lea                 eax, [edx + edx*4]
            //   c1e003               | shl                 eax, 3
            //   50                   | push                eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   50                   | push                eax
            //   8b00                 | mov                 eax, dword ptr [eax]

        $sequence_2 = { ffd0 83c408 894734 85c0 74de 8b5f14 }
            // n = 6, score = 100
            //   ffd0                 | call                eax
            //   83c408               | add                 esp, 8
            //   894734               | mov                 dword ptr [edi + 0x34], eax
            //   85c0                 | test                eax, eax
            //   74de                 | je                  0xffffffe0
            //   8b5f14               | mov                 ebx, dword ptr [edi + 0x14]

        $sequence_3 = { 83793800 7503 83cf04 83e717 89790c 857910 7407 }
            // n = 7, score = 100
            //   83793800             | cmp                 dword ptr [ecx + 0x38], 0
            //   7503                 | jne                 5
            //   83cf04               | or                  edi, 4
            //   83e717               | and                 edi, 0x17
            //   89790c               | mov                 dword ptr [ecx + 0xc], edi
            //   857910               | test                dword ptr [ecx + 0x10], edi
            //   7407                 | je                  9

        $sequence_4 = { 33c4 89442420 8b4508 8944240c 8b450c 53 8b5810 }
            // n = 7, score = 100
            //   33c4                 | xor                 eax, esp
            //   89442420             | mov                 dword ptr [esp + 0x20], eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8944240c             | mov                 dword ptr [esp + 0xc], eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   53                   | push                ebx
            //   8b5810               | mov                 ebx, dword ptr [eax + 0x10]

        $sequence_5 = { 0f43c2 8d8d4cffffff 8a0430 8885f8feffff ffb5f8feffff 6a01 }
            // n = 6, score = 100
            //   0f43c2               | cmovae              eax, edx
            //   8d8d4cffffff         | lea                 ecx, [ebp - 0xb4]
            //   8a0430               | mov                 al, byte ptr [eax + esi]
            //   8885f8feffff         | mov                 byte ptr [ebp - 0x108], al
            //   ffb5f8feffff         | push                dword ptr [ebp - 0x108]
            //   6a01                 | push                1

        $sequence_6 = { 6685c0 75f5 56 8d85d8f9ffff 2bd9 }
            // n = 5, score = 100
            //   6685c0               | test                ax, ax
            //   75f5                 | jne                 0xfffffff7
            //   56                   | push                esi
            //   8d85d8f9ffff         | lea                 eax, [ebp - 0x628]
            //   2bd9                 | sub                 ebx, ecx

        $sequence_7 = { 48 894604 8b06 40 8a48ff 8906 84c9 }
            // n = 7, score = 100
            //   48                   | dec                 eax
            //   894604               | mov                 dword ptr [esi + 4], eax
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   40                   | inc                 eax
            //   8a48ff               | mov                 cl, byte ptr [eax - 1]
            //   8906                 | mov                 dword ptr [esi], eax
            //   84c9                 | test                cl, cl

        $sequence_8 = { 8945bc 8b45c8 8955e4 8b4020 c745e800000000 }
            // n = 5, score = 100
            //   8945bc               | mov                 dword ptr [ebp - 0x44], eax
            //   8b45c8               | mov                 eax, dword ptr [ebp - 0x38]
            //   8955e4               | mov                 dword ptr [ebp - 0x1c], edx
            //   8b4020               | mov                 eax, dword ptr [eax + 0x20]
            //   c745e800000000       | mov                 dword ptr [ebp - 0x18], 0

        $sequence_9 = { 8d4c245c e8???????? 84c0 7433 68???????? 8d8c2490000000 e8???????? }
            // n = 7, score = 100
            //   8d4c245c             | lea                 ecx, [esp + 0x5c]
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   7433                 | je                  0x35
            //   68????????           |                     
            //   8d8c2490000000       | lea                 ecx, [esp + 0x90]
            //   e8????????           |                     

    condition:
        7 of them and filesize < 1253376
}