rule win_eyservice_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.eyservice."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.eyservice"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8d4c2408 8bf0 c7842460080000ffffffff e8???????? }
            // n = 5, score = 100
            //   e8????????           |                     
            //   8d4c2408             | lea                 ecx, [esp + 8]
            //   8bf0                 | mov                 esi, eax
            //   c7842460080000ffffffff     | mov    dword ptr [esp + 0x860], 0xffffffff
            //   e8????????           |                     

        $sequence_1 = { 0f85e5000000 c70600000000 c70702000000 e9???????? 83f85a 0f85cb000000 }
            // n = 6, score = 100
            //   0f85e5000000         | jne                 0xeb
            //   c70600000000         | mov                 dword ptr [esi], 0
            //   c70702000000         | mov                 dword ptr [edi], 2
            //   e9????????           |                     
            //   83f85a               | cmp                 eax, 0x5a
            //   0f85cb000000         | jne                 0xd1

        $sequence_2 = { 83bef800000000 747c 8d4c2408 e8???????? a1???????? 8d4c2408 51 }
            // n = 7, score = 100
            //   83bef800000000       | cmp                 dword ptr [esi + 0xf8], 0
            //   747c                 | je                  0x7e
            //   8d4c2408             | lea                 ecx, [esp + 8]
            //   e8????????           |                     
            //   a1????????           |                     
            //   8d4c2408             | lea                 ecx, [esp + 8]
            //   51                   | push                ecx

        $sequence_3 = { 50 b9???????? c7442454ffffffff e8???????? 46 3bf7 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   b9????????           |                     
            //   c7442454ffffffff     | mov                 dword ptr [esp + 0x54], 0xffffffff
            //   e8????????           |                     
            //   46                   | inc                 esi
            //   3bf7                 | cmp                 esi, edi

        $sequence_4 = { 56 8bc8 e8???????? eb02 33c0 89442410 8d442410 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   8d442410             | lea                 eax, [esp + 0x10]

        $sequence_5 = { 5f 5e 59 c21000 53 8bfb 53 }
            // n = 7, score = 100
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   59                   | pop                 ecx
            //   c21000               | ret                 0x10
            //   53                   | push                ebx
            //   8bfb                 | mov                 edi, ebx
            //   53                   | push                ebx

        $sequence_6 = { 83c404 894de8 c645fc01 3bce 7417 e8???????? 8b4df4 }
            // n = 7, score = 100
            //   83c404               | add                 esp, 4
            //   894de8               | mov                 dword ptr [ebp - 0x18], ecx
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1
            //   3bce                 | cmp                 ecx, esi
            //   7417                 | je                  0x19
            //   e8????????           |                     
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]

        $sequence_7 = { ffd3 8d442434 68???????? 50 ff15???????? 68???????? 8d8c2444010000 }
            // n = 7, score = 100
            //   ffd3                 | call                ebx
            //   8d442434             | lea                 eax, [esp + 0x34]
            //   68????????           |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   68????????           |                     
            //   8d8c2444010000       | lea                 ecx, [esp + 0x144]

        $sequence_8 = { 888654720000 66099652720000 3c08 76bc 0fb78652720000 808654720000f8 0fb7c8 }
            // n = 7, score = 100
            //   888654720000         | mov                 byte ptr [esi + 0x7254], al
            //   66099652720000       | or                  word ptr [esi + 0x7252], dx
            //   3c08                 | cmp                 al, 8
            //   76bc                 | jbe                 0xffffffbe
            //   0fb78652720000       | movzx               eax, word ptr [esi + 0x7252]
            //   808654720000f8       | add                 byte ptr [esi + 0x7254], 0xf8
            //   0fb7c8               | movzx               ecx, ax

        $sequence_9 = { 894e0c 8b5010 895610 8b4814 894e14 8b5018 895618 }
            // n = 7, score = 100
            //   894e0c               | mov                 dword ptr [esi + 0xc], ecx
            //   8b5010               | mov                 edx, dword ptr [eax + 0x10]
            //   895610               | mov                 dword ptr [esi + 0x10], edx
            //   8b4814               | mov                 ecx, dword ptr [eax + 0x14]
            //   894e14               | mov                 dword ptr [esi + 0x14], ecx
            //   8b5018               | mov                 edx, dword ptr [eax + 0x18]
            //   895618               | mov                 dword ptr [esi + 0x18], edx

    condition:
        7 of them and filesize < 452608
}