rule win_fancyfilter_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.fancyfilter."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fancyfilter"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 891d???????? 891d???????? b001 5b }
            // n = 4, score = 400
            //   891d????????         |                     
            //   891d????????         |                     
            //   b001                 | mov                 al, 1
            //   5b                   | pop                 ebx

        $sequence_1 = { ff15???????? 83c420 83f803 7409 }
            // n = 4, score = 400
            //   ff15????????         |                     
            //   83c420               | add                 esp, 0x20
            //   83f803               | cmp                 eax, 3
            //   7409                 | je                  0xb

        $sequence_2 = { 66833800 7404 b001 eb02 }
            // n = 4, score = 400
            //   66833800             | cmp                 word ptr [eax], 0
            //   7404                 | je                  6
            //   b001                 | mov                 al, 1
            //   eb02                 | jmp                 4

        $sequence_3 = { 740f 8d4f20 51 50 ff15???????? }
            // n = 5, score = 400
            //   740f                 | je                  0x11
            //   8d4f20               | lea                 ecx, [edi + 0x20]
            //   51                   | push                ecx
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_4 = { 83f80a 7305 83c030 eb03 83c057 8801 }
            // n = 6, score = 400
            //   83f80a               | cmp                 eax, 0xa
            //   7305                 | jae                 7
            //   83c030               | add                 eax, 0x30
            //   eb03                 | jmp                 5
            //   83c057               | add                 eax, 0x57
            //   8801                 | mov                 byte ptr [ecx], al

        $sequence_5 = { 51 50 ff15???????? 8b36 }
            // n = 4, score = 400
            //   51                   | push                ecx
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b36                 | mov                 esi, dword ptr [esi]

        $sequence_6 = { a1???????? 83c012 50 ff15???????? }
            // n = 4, score = 400
            //   a1????????           |                     
            //   83c012               | add                 eax, 0x12
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_7 = { 8d4f20 51 50 ff15???????? 8b36 }
            // n = 5, score = 400
            //   8d4f20               | lea                 ecx, [edi + 0x20]
            //   51                   | push                ecx
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b36                 | mov                 esi, dword ptr [esi]

        $sequence_8 = { b805400080 c20400 56 8b742408 8b4618 85c0 }
            // n = 6, score = 400
            //   b805400080           | mov                 eax, 0x80004005
            //   c20400               | ret                 4
            //   56                   | push                esi
            //   8b742408             | mov                 esi, dword ptr [esp + 8]
            //   8b4618               | mov                 eax, dword ptr [esi + 0x18]
            //   85c0                 | test                eax, eax

        $sequence_9 = { 83c030 eb03 83c057 8801 49 }
            // n = 5, score = 400
            //   83c030               | add                 eax, 0x30
            //   eb03                 | jmp                 5
            //   83c057               | add                 eax, 0x57
            //   8801                 | mov                 byte ptr [ecx], al
            //   49                   | dec                 ecx

    condition:
        7 of them and filesize < 169984
}