rule win_fanny_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.fanny."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fanny"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8d4dd8 e8???????? 8b45b4 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   e8????????           |                     
            //   8b45b4               | mov                 eax, dword ptr [ebp - 0x4c]

        $sequence_1 = { 8b7d0c 8bf7 8b4508 3bc3 0f84b8020000 }
            // n = 5, score = 200
            //   8b7d0c               | mov                 edi, dword ptr [ebp + 0xc]
            //   8bf7                 | mov                 esi, edi
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   3bc3                 | cmp                 eax, ebx
            //   0f84b8020000         | je                  0x2be

        $sequence_2 = { a2???????? 8d45fc 50 8d45f0 a4 6a08 50 }
            // n = 7, score = 200
            //   a2????????           |                     
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   a4                   | movsb               byte ptr es:[edi], byte ptr [esi]
            //   6a08                 | push                8
            //   50                   | push                eax

        $sequence_3 = { 57 895df0 740b c1e809 894df4 c1e009 eb03 }
            // n = 7, score = 200
            //   57                   | push                edi
            //   895df0               | mov                 dword ptr [ebp - 0x10], ebx
            //   740b                 | je                  0xd
            //   c1e809               | shr                 eax, 9
            //   894df4               | mov                 dword ptr [ebp - 0xc], ecx
            //   c1e009               | shl                 eax, 9
            //   eb03                 | jmp                 5

        $sequence_4 = { 5d c3 66c78594fbffff6800 b903000000 8dbd90fbffff 8db5d0fbffff 33d2 }
            // n = 7, score = 200
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   66c78594fbffff6800     | mov    word ptr [ebp - 0x46c], 0x68
            //   b903000000           | mov                 ecx, 3
            //   8dbd90fbffff         | lea                 edi, [ebp - 0x470]
            //   8db5d0fbffff         | lea                 esi, [ebp - 0x430]
            //   33d2                 | xor                 edx, edx

        $sequence_5 = { 8b4c2408 33f6 8901 8bc6 }
            // n = 4, score = 200
            //   8b4c2408             | mov                 ecx, dword ptr [esp + 8]
            //   33f6                 | xor                 esi, esi
            //   8901                 | mov                 dword ptr [ecx], eax
            //   8bc6                 | mov                 eax, esi

        $sequence_6 = { 50 6808100000 56 ffd7 8b0d???????? }
            // n = 5, score = 200
            //   50                   | push                eax
            //   6808100000           | push                0x1008
            //   56                   | push                esi
            //   ffd7                 | call                edi
            //   8b0d????????         |                     

        $sequence_7 = { 83780c00 7422 8b4dfc 83790400 7419 8b55fc 837a0800 }
            // n = 7, score = 200
            //   83780c00             | cmp                 dword ptr [eax + 0xc], 0
            //   7422                 | je                  0x24
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   83790400             | cmp                 dword ptr [ecx + 4], 0
            //   7419                 | je                  0x1b
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   837a0800             | cmp                 dword ptr [edx + 8], 0

        $sequence_8 = { e8???????? 8b45d0 50 8b4d08 51 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   8b45d0               | mov                 eax, dword ptr [ebp - 0x30]
            //   50                   | push                eax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   51                   | push                ecx

        $sequence_9 = { 894508 8b5510 83ea05 895510 eb09 }
            // n = 5, score = 200
            //   894508               | mov                 dword ptr [ebp + 8], eax
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]
            //   83ea05               | sub                 edx, 5
            //   895510               | mov                 dword ptr [ebp + 0x10], edx
            //   eb09                 | jmp                 0xb

        $sequence_10 = { e9???????? 8b5508 0fb602 3d90000000 753b 8b4d08 }
            // n = 6, score = 200
            //   e9????????           |                     
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   0fb602               | movzx               eax, byte ptr [edx]
            //   3d90000000           | cmp                 eax, 0x90
            //   753b                 | jne                 0x3d
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]

        $sequence_11 = { f3ab 66ab aa 8a4508 }
            // n = 4, score = 200
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al
            //   8a4508               | mov                 al, byte ptr [ebp + 8]

        $sequence_12 = { 5b 5d c3 55 8bec 83ec2c 8065ff00 }
            // n = 7, score = 200
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec2c               | sub                 esp, 0x2c
            //   8065ff00             | and                 byte ptr [ebp - 1], 0

        $sequence_13 = { 832700 6800800000 6a00 53 ff15???????? }
            // n = 5, score = 200
            //   832700               | and                 dword ptr [edi], 0
            //   6800800000           | push                0x8000
            //   6a00                 | push                0
            //   53                   | push                ebx
            //   ff15????????         |                     

        $sequence_14 = { 8b45fc 83c012 50 ffd3 8bf0 59 }
            // n = 6, score = 200
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   83c012               | add                 eax, 0x12
            //   50                   | push                eax
            //   ffd3                 | call                ebx
            //   8bf0                 | mov                 esi, eax
            //   59                   | pop                 ecx

        $sequence_15 = { 8913 751b c745fc01000000 ff33 ff15???????? }
            // n = 5, score = 200
            //   8913                 | mov                 dword ptr [ebx], edx
            //   751b                 | jne                 0x1d
            //   c745fc01000000       | mov                 dword ptr [ebp - 4], 1
            //   ff33                 | push                dword ptr [ebx]
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 368640
}