rule win_farseer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.farseer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.farseer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b46f4 8b4804 c74431f49c064200 8b56fc 8b4204 c74430fc???????? 8b4ef4 }
            // n = 7, score = 100
            //   8b46f4               | mov                 eax, dword ptr [esi - 0xc]
            //   8b4804               | mov                 ecx, dword ptr [eax + 4]
            //   c74431f49c064200     | mov                 dword ptr [ecx + esi - 0xc], 0x42069c
            //   8b56fc               | mov                 edx, dword ptr [esi - 4]
            //   8b4204               | mov                 eax, dword ptr [edx + 4]
            //   c74430fc????????     |                     
            //   8b4ef4               | mov                 ecx, dword ptr [esi - 0xc]

        $sequence_1 = { 8b4d0c 8bfb e8???????? 8b4c2414 8b3d???????? }
            // n = 5, score = 100
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   8bfb                 | mov                 edi, ebx
            //   e8????????           |                     
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   8b3d????????         |                     

        $sequence_2 = { 68???????? 8d4c2440 c74424580f000000 c744245400000000 c644244400 e8???????? }
            // n = 6, score = 100
            //   68????????           |                     
            //   8d4c2440             | lea                 ecx, [esp + 0x40]
            //   c74424580f000000     | mov                 dword ptr [esp + 0x58], 0xf
            //   c744245400000000     | mov                 dword ptr [esp + 0x54], 0
            //   c644244400           | mov                 byte ptr [esp + 0x44], 0
            //   e8????????           |                     

        $sequence_3 = { 8b7d14 8bc7 3bc7 7300 8bd7 83ff01 7205 }
            // n = 7, score = 100
            //   8b7d14               | mov                 edi, dword ptr [ebp + 0x14]
            //   8bc7                 | mov                 eax, edi
            //   3bc7                 | cmp                 eax, edi
            //   7300                 | jae                 2
            //   8bd7                 | mov                 edx, edi
            //   83ff01               | cmp                 edi, 1
            //   7205                 | jb                  7

        $sequence_4 = { 51 c78424a000000002000000 e8???????? 68???????? 8d542450 52 }
            // n = 6, score = 100
            //   51                   | push                ecx
            //   c78424a000000002000000     | mov    dword ptr [esp + 0xa0], 2
            //   e8????????           |                     
            //   68????????           |                     
            //   8d542450             | lea                 edx, [esp + 0x50]
            //   52                   | push                edx

        $sequence_5 = { ffd5 85c0 7e2f 03f0 81fe00040000 7ce1 33c0 }
            // n = 7, score = 100
            //   ffd5                 | call                ebp
            //   85c0                 | test                eax, eax
            //   7e2f                 | jle                 0x31
            //   03f0                 | add                 esi, eax
            //   81fe00040000         | cmp                 esi, 0x400
            //   7ce1                 | jl                  0xffffffe3
            //   33c0                 | xor                 eax, eax

        $sequence_6 = { 6a00 51 c684241409000000 e8???????? 83c40c 8dbc2408090000 }
            // n = 6, score = 100
            //   6a00                 | push                0
            //   51                   | push                ecx
            //   c684241409000000     | mov                 byte ptr [esp + 0x914], 0
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8dbc2408090000       | lea                 edi, [esp + 0x908]

        $sequence_7 = { ff15???????? 6804010000 8d54245a b901000000 52 }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   6804010000           | push                0x104
            //   8d54245a             | lea                 edx, [esp + 0x5a]
            //   b901000000           | mov                 ecx, 1
            //   52                   | push                edx

        $sequence_8 = { 8d048520634200 83e31f 8985e4efffff 8b00 c1e306 03c3 8a4824 }
            // n = 7, score = 100
            //   8d048520634200       | lea                 eax, [eax*4 + 0x426320]
            //   83e31f               | and                 ebx, 0x1f
            //   8985e4efffff         | mov                 dword ptr [ebp - 0x101c], eax
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   c1e306               | shl                 ebx, 6
            //   03c3                 | add                 eax, ebx
            //   8a4824               | mov                 cl, byte ptr [eax + 0x24]

        $sequence_9 = { 64890d00000000 59 5f 5e 5d 5b 8b8c24a0020000 }
            // n = 7, score = 100
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx
            //   59                   | pop                 ecx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   5b                   | pop                 ebx
            //   8b8c24a0020000       | mov                 ecx, dword ptr [esp + 0x2a0]

    condition:
        7 of them and filesize < 347328
}