rule win_fatal_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.fatal_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fatal_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 5d c3 55 8bec 8b4508 8b4d0c 2d00803ed5 }
            // n = 7, score = 100
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   2d00803ed5           | sub                 eax, 0xd53e8000

        $sequence_1 = { c3 55 8bec 81ec04020000 53 57 6a7f }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ec04020000         | sub                 esp, 0x204
            //   53                   | push                ebx
            //   57                   | push                edi
            //   6a7f                 | push                0x7f

        $sequence_2 = { 68???????? 89470c ff7508 ffd6 8b4f0c 894710 }
            // n = 6, score = 100
            //   68????????           |                     
            //   89470c               | mov                 dword ptr [edi + 0xc], eax
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ffd6                 | call                esi
            //   8b4f0c               | mov                 ecx, dword ptr [edi + 0xc]
            //   894710               | mov                 dword ptr [edi + 0x10], eax

        $sequence_3 = { ff15???????? 85c0 894508 0f84e9000000 8b35???????? 68???????? 50 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   894508               | mov                 dword ptr [ebp + 8], eax
            //   0f84e9000000         | je                  0xef
            //   8b35????????         |                     
            //   68????????           |                     
            //   50                   | push                eax

        $sequence_4 = { 8d85a4fdffff 56 50 8935???????? ff15???????? 83c40c 6a0a }
            // n = 7, score = 100
            //   8d85a4fdffff         | lea                 eax, [ebp - 0x25c]
            //   56                   | push                esi
            //   50                   | push                eax
            //   8935????????         |                     
            //   ff15????????         |                     
            //   83c40c               | add                 esp, 0xc
            //   6a0a                 | push                0xa

        $sequence_5 = { 59 740d 6a00 68???????? ff15???????? c9 c3 }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   740d                 | je                  0xf
            //   6a00                 | push                0
            //   68????????           |                     
            //   ff15????????         |                     
            //   c9                   | leave               
            //   c3                   | ret                 

        $sequence_6 = { 83c310 ebaf 8d4dc0 c645fc01 }
            // n = 4, score = 100
            //   83c310               | add                 ebx, 0x10
            //   ebaf                 | jmp                 0xffffffb1
            //   8d4dc0               | lea                 ecx, [ebp - 0x40]
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1

        $sequence_7 = { 57 6a00 ff7508 ffd6 }
            // n = 4, score = 100
            //   57                   | push                edi
            //   6a00                 | push                0
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ffd6                 | call                esi

        $sequence_8 = { 750c 57 ff15???????? e9???????? 53 8d45fc }
            // n = 6, score = 100
            //   750c                 | jne                 0xe
            //   57                   | push                edi
            //   ff15????????         |                     
            //   e9????????           |                     
            //   53                   | push                ebx
            //   8d45fc               | lea                 eax, [ebp - 4]

        $sequence_9 = { 50 ff15???????? ff75f4 8946f8 6a00 50 ff15???????? }
            // n = 7, score = 100
            //   50                   | push                eax
            //   ff15????????         |                     
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   8946f8               | mov                 dword ptr [esi - 8], eax
            //   6a00                 | push                0
            //   50                   | push                eax
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 344064
}