rule win_fct_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.fct."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fct"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 803d????????00 753c c705????????60504100 c705????????88534100 c705????????80524100 e8???????? }
            // n = 6, score = 100
            //   803d????????00       |                     
            //   753c                 | jne                 0x3e
            //   c705????????60504100     |     
            //   c705????????88534100     |     
            //   c705????????80524100     |     
            //   e8????????           |                     

        $sequence_1 = { 8365c000 c745c42b2e4000 a1???????? 8d4dc0 33c1 8945c8 8b4518 }
            // n = 7, score = 100
            //   8365c000             | and                 dword ptr [ebp - 0x40], 0
            //   c745c42b2e4000       | mov                 dword ptr [ebp - 0x3c], 0x402e2b
            //   a1????????           |                     
            //   8d4dc0               | lea                 ecx, [ebp - 0x40]
            //   33c1                 | xor                 eax, ecx
            //   8945c8               | mov                 dword ptr [ebp - 0x38], eax
            //   8b4518               | mov                 eax, dword ptr [ebp + 0x18]

        $sequence_2 = { ffb52cfdffff 6a01 e8???????? 8d8d80fdffff }
            // n = 4, score = 100
            //   ffb52cfdffff         | push                dword ptr [ebp - 0x2d4]
            //   6a01                 | push                1
            //   e8????????           |                     
            //   8d8d80fdffff         | lea                 ecx, [ebp - 0x280]

        $sequence_3 = { 0f434dd8 3bc2 772c 8d3400 898544fdffff 83fa08 8dbd34fdffff }
            // n = 7, score = 100
            //   0f434dd8             | cmovae              ecx, dword ptr [ebp - 0x28]
            //   3bc2                 | cmp                 eax, edx
            //   772c                 | ja                  0x2e
            //   8d3400               | lea                 esi, [eax + eax]
            //   898544fdffff         | mov                 dword ptr [ebp - 0x2bc], eax
            //   83fa08               | cmp                 edx, 8
            //   8dbd34fdffff         | lea                 edi, [ebp - 0x2cc]

        $sequence_4 = { 83c8ff eb07 8b04f574204100 5f 5e 5b }
            // n = 6, score = 100
            //   83c8ff               | or                  eax, 0xffffffff
            //   eb07                 | jmp                 9
            //   8b04f574204100       | mov                 eax, dword ptr [esi*8 + 0x412074]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_5 = { 03348d50614100 837e18ff 740c 837e18fe 7406 }
            // n = 5, score = 100
            //   03348d50614100       | add                 esi, dword ptr [ecx*4 + 0x416150]
            //   837e18ff             | cmp                 dword ptr [esi + 0x18], -1
            //   740c                 | je                  0xe
            //   837e18fe             | cmp                 dword ptr [esi + 0x18], -2
            //   7406                 | je                  8

        $sequence_6 = { 83c102 6685c0 75f5 8b5dec }
            // n = 4, score = 100
            //   83c102               | add                 ecx, 2
            //   6685c0               | test                ax, ax
            //   75f5                 | jne                 0xfffffff7
            //   8b5dec               | mov                 ebx, dword ptr [ebp - 0x14]

        $sequence_7 = { 8bc3 d1f9 2bc2 3bc8 772f 83fb08 }
            // n = 6, score = 100
            //   8bc3                 | mov                 eax, ebx
            //   d1f9                 | sar                 ecx, 1
            //   2bc2                 | sub                 eax, edx
            //   3bc8                 | cmp                 ecx, eax
            //   772f                 | ja                  0x31
            //   83fb08               | cmp                 ebx, 8

        $sequence_8 = { eb1e 6a02 68???????? c6854cfdffff00 8d4dbc }
            // n = 5, score = 100
            //   eb1e                 | jmp                 0x20
            //   6a02                 | push                2
            //   68????????           |                     
            //   c6854cfdffff00       | mov                 byte ptr [ebp - 0x2b4], 0
            //   8d4dbc               | lea                 ecx, [ebp - 0x44]

        $sequence_9 = { 33c0 6689047e eb21 6a04 }
            // n = 4, score = 100
            //   33c0                 | xor                 eax, eax
            //   6689047e             | mov                 word ptr [esi + edi*2], ax
            //   eb21                 | jmp                 0x23
            //   6a04                 | push                4

    condition:
        7 of them and filesize < 204800
}