rule win_feed_load_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.feed_load."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.feed_load"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 44393d???????? 742c 4c897c2428 4c8d0578faffff 4533c9 44897c2420 33d2 }
            // n = 7, score = 100
            //   44393d????????       |                     
            //   742c                 | mov                 dword ptr [eax + 0x3a8], edx
            //   4c897c2428           | dec                 eax
            //   4c8d0578faffff       | mov                 eax, dword ptr [ebp - 0x28]
            //   4533c9               | dec                 eax
            //   44897c2420           | mov                 eax, dword ptr [edi + 8]
            //   33d2                 | inc                 ecx

        $sequence_1 = { 48ffc0 4983ef01 75ef 498d5508 488bcd 4c8d4c2458 }
            // n = 6, score = 100
            //   48ffc0               | cmp                 ecx, eax
            //   4983ef01             | cmp                 eax, 1
            //   75ef                 | jne                 0x1d07
            //   498d5508             | dec                 eax
            //   488bcd               | mov                 eax, dword ptr [ebx + 8]
            //   4c8d4c2458           | dec                 eax

        $sequence_2 = { 448bc7 488bd0 488bce 4c8bf0 e8???????? 3bc5 7411 }
            // n = 7, score = 100
            //   448bc7               | je                  0x231
            //   488bd0               | dec                 eax
            //   488bce               | mov                 eax, dword ptr [ecx]
            //   4c8bf0               | mov                 edx, 1
            //   e8????????           |                     
            //   3bc5                 | call                dword ptr [eax]
            //   7411                 | dec                 eax

        $sequence_3 = { 482bca 4883c302 4183e60f 4983fe0f 0f85bd000000 }
            // n = 5, score = 100
            //   482bca               | inc                 ecx
            //   4883c302             | mov                 ecx, esp
            //   4183e60f             | dec                 eax
            //   4983fe0f             | mov                 dword ptr [esp + 0x30], edi
            //   0f85bd000000         | test                ecx, ecx

        $sequence_4 = { e8???????? 8b442450 8905???????? eb17 4c8d442454 e8???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8b442450             | dec                 eax
            //   8905????????         |                     
            //   eb17                 | cmp                 eax, -1
            //   4c8d442454           | inc                 esp
            //   e8????????           |                     

        $sequence_5 = { 488d15a6550200 448bcf 448bc6 ff15???????? 4423e0 0f84ef010000 488b4b18 }
            // n = 7, score = 100
            //   488d15a6550200       | arpl                word ptr [ecx + 0x18], dx
            //   448bcf               | dec                 ecx
            //   448bc6               | mov                 ecx, edx
            //   ff15????????         |                     
            //   4423e0               | dec                 esp
            //   0f84ef010000         | lea                 ecx, [0x25ca9]
            //   488b4b18             | and                 ecx, 0x3f

        $sequence_6 = { 4889742420 4489442418 55 57 4154 4156 4157 }
            // n = 7, score = 100
            //   4889742420           | cwde                
            //   4489442418           | dec                 eax
            //   55                   | add                 eax, eax
            //   57                   | inc                 ecx
            //   4154                 | mov                 eax, dword ptr [edi + eax*8 + 0x23890]
            //   4156                 | jmp                 0xfc2
            //   4157                 | xor                 eax, eax

        $sequence_7 = { 8bc2 c1e81f 03d0 8d4310 03c2 48638c24b0000000 3bc8 }
            // n = 7, score = 100
            //   8bc2                 | mov                 ebx, esp
            //   c1e81f               | inc                 esp
            //   03d0                 | lea                 ebp, [edi - 0x3f]
            //   8d4310               | inc                 ebp
            //   03c2                 | xor                 edi, edi
            //   48638c24b0000000     | inc                 esp
            //   3bc8                 | mov                 dword ptr [esp + 0x30], edi

        $sequence_8 = { e9???????? 488bc3 4c8d3d873affff 498784f798600300 4885c0 7409 }
            // n = 6, score = 100
            //   e9????????           |                     
            //   488bc3               | test                ebp, ebp
            //   4c8d3d873affff       | inc                 esp
            //   498784f798600300     | mov                 ebp, ecx
            //   4885c0               | dec                 ebp
            //   7409                 | mov                 edi, eax

        $sequence_9 = { 410fb608 83e10f 4a0fbe841100050200 428a8c1110050200 }
            // n = 4, score = 100
            //   410fb608             | dec                 eax
            //   83e10f               | mov                 ebx, dword ptr [ebp - 0x71]
            //   4a0fbe841100050200     | dec    esp
            //   428a8c1110050200     | mov                 ecx, ebx

    condition:
        7 of them and filesize < 512000
}