rule win_fickerstealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.fickerstealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fickerstealer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 46 4f ebe7 b001 eb02 31c0 83c404 }
            // n = 7, score = 200
            //   46                   | inc                 esi
            //   4f                   | dec                 edi
            //   ebe7                 | jmp                 0xffffffe9
            //   b001                 | mov                 al, 1
            //   eb02                 | jmp                 4
            //   31c0                 | xor                 eax, eax
            //   83c404               | add                 esp, 4

        $sequence_1 = { ff74240c ff74240c ff74240c 52 51 53 50 }
            // n = 7, score = 200
            //   ff74240c             | push                dword ptr [esp + 0xc]
            //   ff74240c             | push                dword ptr [esp + 0xc]
            //   ff74240c             | push                dword ptr [esp + 0xc]
            //   52                   | push                edx
            //   51                   | push                ecx
            //   53                   | push                ebx
            //   50                   | push                eax

        $sequence_2 = { eb44 88df 80c7d0 80ff0a 7241 8b7df0 3a1f }
            // n = 7, score = 200
            //   eb44                 | jmp                 0x46
            //   88df                 | mov                 bh, bl
            //   80c7d0               | add                 bh, 0xd0
            //   80ff0a               | cmp                 bh, 0xa
            //   7241                 | jb                  0x43
            //   8b7df0               | mov                 edi, dword ptr [ebp - 0x10]
            //   3a1f                 | cmp                 bl, byte ptr [edi]

        $sequence_3 = { c3 8b8424081d0000 f20f108424001d0000 8b7d0c 89442438 f20f11442430 31c0 }
            // n = 7, score = 200
            //   c3                   | ret                 
            //   8b8424081d0000       | mov                 eax, dword ptr [esp + 0x1d08]
            //   f20f108424001d0000     | movsd    xmm0, qword ptr [esp + 0x1d00]
            //   8b7d0c               | mov                 edi, dword ptr [ebp + 0xc]
            //   89442438             | mov                 dword ptr [esp + 0x38], eax
            //   f20f11442430         | movsd               qword ptr [esp + 0x30], xmm0
            //   31c0                 | xor                 eax, eax

        $sequence_4 = { 8d55f0 8902 894a04 6683620800 89f1 e8???????? 83c40c }
            // n = 7, score = 200
            //   8d55f0               | lea                 edx, [ebp - 0x10]
            //   8902                 | mov                 dword ptr [edx], eax
            //   894a04               | mov                 dword ptr [edx + 4], ecx
            //   6683620800           | and                 word ptr [edx + 8], 0
            //   89f1                 | mov                 ecx, esi
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_5 = { f20f114808 f20f1100 8d4dd4 6a02 58 50 e8???????? }
            // n = 7, score = 200
            //   f20f114808           | movsd               qword ptr [eax + 8], xmm1
            //   f20f1100             | movsd               qword ptr [eax], xmm0
            //   8d4dd4               | lea                 ecx, [ebp - 0x2c]
            //   6a02                 | push                2
            //   58                   | pop                 eax
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_6 = { f20f114610 f20f114e08 f20f1116 56 e8???????? 59 83c418 }
            // n = 7, score = 200
            //   f20f114610           | movsd               qword ptr [esi + 0x10], xmm0
            //   f20f114e08           | movsd               qword ptr [esi + 8], xmm1
            //   f20f1116             | movsd               qword ptr [esi], xmm2
            //   56                   | push                esi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   83c418               | add                 esp, 0x18

        $sequence_7 = { 21f2 8d75d4 8b760c 09da bb08080808 21de 09fe }
            // n = 7, score = 200
            //   21f2                 | and                 edx, esi
            //   8d75d4               | lea                 esi, [ebp - 0x2c]
            //   8b760c               | mov                 esi, dword ptr [esi + 0xc]
            //   09da                 | or                  edx, ebx
            //   bb08080808           | mov                 ebx, 0x8080808
            //   21de                 | and                 esi, ebx
            //   09fe                 | or                  esi, edi

        $sequence_8 = { 8d55e4 21c3 8d8518ffffff f20f1000 f20f104808 8d45e4 09fb }
            // n = 7, score = 200
            //   8d55e4               | lea                 edx, [ebp - 0x1c]
            //   21c3                 | and                 ebx, eax
            //   8d8518ffffff         | lea                 eax, [ebp - 0xe8]
            //   f20f1000             | movsd               xmm0, qword ptr [eax]
            //   f20f104808           | movsd               xmm1, qword ptr [eax + 8]
            //   8d45e4               | lea                 eax, [ebp - 0x1c]
            //   09fb                 | or                  ebx, edi

        $sequence_9 = { e8???????? 83c40c 8b542410 6689442422 89f9 6a04 58 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8b542410             | mov                 edx, dword ptr [esp + 0x10]
            //   6689442422           | mov                 word ptr [esp + 0x22], ax
            //   89f9                 | mov                 ecx, edi
            //   6a04                 | push                4
            //   58                   | pop                 eax

    condition:
        7 of them and filesize < 598016
}