rule win_final1stspy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.final1stspy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.final1stspy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 80c27a 80f219 881439 41 3bce 7cef 8bc7 }
            // n = 7, score = 300
            //   80c27a               | add                 dl, 0x7a
            //   80f219               | xor                 dl, 0x19
            //   881439               | mov                 byte ptr [ecx + edi], dl
            //   41                   | inc                 ecx
            //   3bce                 | cmp                 ecx, esi
            //   7cef                 | jl                  0xfffffff1
            //   8bc7                 | mov                 eax, edi

        $sequence_1 = { 8bd6 0f281d???????? 2bd0 0f10040f 0f28ca 660ffcc2 }
            // n = 6, score = 300
            //   8bd6                 | mov                 edx, esi
            //   0f281d????????       |                     
            //   2bd0                 | sub                 edx, eax
            //   0f10040f             | movups              xmm0, xmmword ptr [edi + ecx]
            //   0f28ca               | movaps              xmm1, xmm2
            //   660ffcc2             | paddb               xmm0, xmm2

        $sequence_2 = { 8a4803 c1e206 80f93d 7508 47 83ff03 }
            // n = 6, score = 300
            //   8a4803               | mov                 cl, byte ptr [eax + 3]
            //   c1e206               | shl                 edx, 6
            //   80f93d               | cmp                 cl, 0x3d
            //   7508                 | jne                 0xa
            //   47                   | inc                 edi
            //   83ff03               | cmp                 edi, 3

        $sequence_3 = { 5d c3 2d???????? 78b0 03d0 8b45fc 8a4803 }
            // n = 7, score = 300
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   2d????????           |                     
            //   78b0                 | js                  0xffffffb2
            //   03d0                 | add                 edx, eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8a4803               | mov                 cl, byte ptr [eax + 3]

        $sequence_4 = { 7508 47 83ff03 7d3e }
            // n = 4, score = 300
            //   7508                 | jne                 0xa
            //   47                   | inc                 edi
            //   83ff03               | cmp                 edi, 3
            //   7d3e                 | jge                 0x40

        $sequence_5 = { 7410 8a11 8acb 3aca }
            // n = 4, score = 300
            //   7410                 | je                  0x12
            //   8a11                 | mov                 dl, byte ptr [ecx]
            //   8acb                 | mov                 cl, bl
            //   3aca                 | cmp                 cl, dl

        $sequence_6 = { 81e7ff070080 7908 4f 81cf00f8ffff }
            // n = 4, score = 300
            //   81e7ff070080         | and                 edi, 0x800007ff
            //   7908                 | jns                 0xa
            //   4f                   | dec                 edi
            //   81cf00f8ffff         | or                  edi, 0xfffff800

        $sequence_7 = { 81cf00f8ffff 47 33f6 85ff 7e0a e8???????? }
            // n = 6, score = 300
            //   81cf00f8ffff         | or                  edi, 0xfffff800
            //   47                   | inc                 edi
            //   33f6                 | xor                 esi, esi
            //   85ff                 | test                edi, edi
            //   7e0a                 | jle                 0xc
            //   e8????????           |                     

        $sequence_8 = { 84db 7410 8a11 8acb 3aca 7425 8a4801 }
            // n = 7, score = 300
            //   84db                 | test                bl, bl
            //   7410                 | je                  0x12
            //   8a11                 | mov                 dl, byte ptr [ecx]
            //   8acb                 | mov                 cl, bl
            //   3aca                 | cmp                 cl, dl
            //   7425                 | je                  0x27
            //   8a4801               | mov                 cl, byte ptr [eax + 1]

        $sequence_9 = { c3 2d???????? 78dc 8b55fc b9???????? }
            // n = 5, score = 300
            //   c3                   | ret                 
            //   2d????????           |                     
            //   78dc                 | js                  0xffffffde
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   b9????????           |                     

    condition:
        7 of them and filesize < 557056
}