rule win_fireball_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.fireball."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fireball"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 837c242008 c78424c800000007000000 c78424c400000000000000 66898424b4000000 }
            // n = 4, score = 100
            //   837c242008           | cmp                 dword ptr [esp + 0x20], 8
            //   c78424c800000007000000     | mov    dword ptr [esp + 0xc8], 7
            //   c78424c400000000000000     | mov    dword ptr [esp + 0xc4], 0
            //   66898424b4000000     | mov                 word ptr [esp + 0xb4], ax

        $sequence_1 = { 8d842484000000 50 8d9424d0000000 8d8c24a8010000 c68424cc01000009 e8???????? }
            // n = 6, score = 100
            //   8d842484000000       | lea                 eax, [esp + 0x84]
            //   50                   | push                eax
            //   8d9424d0000000       | lea                 edx, [esp + 0xd0]
            //   8d8c24a8010000       | lea                 ecx, [esp + 0x1a8]
            //   c68424cc01000009     | mov                 byte ptr [esp + 0x1cc], 9
            //   e8????????           |                     

        $sequence_2 = { 83c404 33c0 83bc249800000008 c744246807000000 c744246400000000 }
            // n = 5, score = 100
            //   83c404               | add                 esp, 4
            //   33c0                 | xor                 eax, eax
            //   83bc249800000008     | cmp                 dword ptr [esp + 0x98], 8
            //   c744246807000000     | mov                 dword ptr [esp + 0x68], 7
            //   c744246400000000     | mov                 dword ptr [esp + 0x64], 0

        $sequence_3 = { 83bc24b000000008 c784248000000007000000 c744247c00000000 668944246c 7228 }
            // n = 5, score = 100
            //   83bc24b000000008     | cmp                 dword ptr [esp + 0xb0], 8
            //   c784248000000007000000     | mov    dword ptr [esp + 0x80], 7
            //   c744247c00000000     | mov                 dword ptr [esp + 0x7c], 0
            //   668944246c           | mov                 word ptr [esp + 0x6c], ax
            //   7228                 | jb                  0x2a

        $sequence_4 = { 8b0e e8???????? eb2a ff750c }
            // n = 4, score = 100
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   e8????????           |                     
            //   eb2a                 | jmp                 0x2c
            //   ff750c               | push                dword ptr [ebp + 0xc]

        $sequence_5 = { 5e c3 55 8bec 8b4508 ff34c5a8f52400 }
            // n = 6, score = 100
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   ff34c5a8f52400       | push                dword ptr [eax*8 + 0x24f5a8]

        $sequence_6 = { 3a503a 683a783a7c 3a803a843a98 3a9c3aa03ab83a }
            // n = 4, score = 100
            //   3a503a               | cmp                 dl, byte ptr [eax + 0x3a]
            //   683a783a7c           | push                0x7c3a783a
            //   3a803a843a98         | cmp                 al, byte ptr [eax - 0x67c57bc6]
            //   3a9c3aa03ab83a       | cmp                 bl, byte ptr [edx + edi + 0x3ab83aa0]

        $sequence_7 = { 0f43842480000000 6a00 50 ffd7 8d442464 50 }
            // n = 6, score = 100
            //   0f43842480000000     | cmovae              eax, dword ptr [esp + 0x80]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   ffd7                 | call                edi
            //   8d442464             | lea                 eax, [esp + 0x64]
            //   50                   | push                eax

        $sequence_8 = { e9???????? 8d8d44fbffff e9???????? 8d8d44fbffff e9???????? 8b542408 8d823cfbffff }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8d8d44fbffff         | lea                 ecx, [ebp - 0x4bc]
            //   e9????????           |                     
            //   8d8d44fbffff         | lea                 ecx, [ebp - 0x4bc]
            //   e9????????           |                     
            //   8b542408             | mov                 edx, dword ptr [esp + 8]
            //   8d823cfbffff         | lea                 eax, [edx - 0x4c4]

        $sequence_9 = { 80bda7fdffff00 8b5d1c 8b7d18 8b7508 741d 57 8d4508 }
            // n = 7, score = 100
            //   80bda7fdffff00       | cmp                 byte ptr [ebp - 0x259], 0
            //   8b5d1c               | mov                 ebx, dword ptr [ebp + 0x1c]
            //   8b7d18               | mov                 edi, dword ptr [ebp + 0x18]
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   741d                 | je                  0x1f
            //   57                   | push                edi
            //   8d4508               | lea                 eax, [ebp + 8]

    condition:
        7 of them and filesize < 335872
}