rule win_firechili_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.firechili."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.firechili"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb2d 488b4c2430 8b442440 894110 4533c9 }
            // n = 5, score = 100
            //   eb2d                 | dec                 eax
            //   488b4c2430           | mov                 dword ptr [eax - 0x10], edx
            //   8b442440             | dec                 eax
            //   894110               | mov                 dword ptr [eax - 8], edx
            //   4533c9               | dec                 eax

        $sequence_1 = { 4883ec20 488bda 488bf9 ba30000000 33c9 41b873747600 ff15???????? }
            // n = 7, score = 100
            //   4883ec20             | dec                 eax
            //   488bda               | lea                 eax, [esp + 0x48]
            //   488bf9               | nop                 word ptr [eax + eax]
            //   ba30000000           | dec                 ecx
            //   33c9                 | lea                 ecx, [ecx + edx]
            //   41b873747600         | dec                 eax
            //   ff15????????         |                     

        $sequence_2 = { 4c8d442430 488bcb 41ffd1 eb1b 4c8b05???????? eb23 }
            // n = 6, score = 100
            //   4c8d442430           | dec                 eax
            //   488bcb               | lea                 ecx, [0x21a3]
            //   41ffd1               | dec                 eax
            //   eb1b                 | lea                 edx, [esp + 0x20]
            //   4c8b05????????       |                     
            //   eb23                 | dec                 eax

        $sequence_3 = { 4889bc2488000000 33ff c7450730000000 ba3f000f00 897d67 488d4d77 48897d77 }
            // n = 7, score = 100
            //   4889bc2488000000     | cmp                 dword ptr [eax + 8], ecx
            //   33ff                 | je                  0x1195
            //   c7450730000000       | dec                 esp
            //   ba3f000f00           | lea                 esi, [eax + 0x10]
            //   897d67               | dec                 eax
            //   488d4d77             | lea                 ecx, [0x2573]
            //   48897d77             | dec                 ebp

        $sequence_4 = { 4885d2 7509 4883e802 bb05000080 668938 }
            // n = 5, score = 100
            //   4885d2               | mov                 ebx, dword ptr [esp + 0xc8]
            //   7509                 | dec                 ecx
            //   4883e802             | mov                 eax, dword ptr [esi + 8]
            //   bb05000080           | dec                 esp
            //   668938               | mov                 ebp, dword ptr [esp + 0x70]

        $sequence_5 = { 0f8489000000 4885db 0f8480000000 488d5318 4032ff 4885d2 7462 }
            // n = 7, score = 100
            //   0f8489000000         | sub                 eax, 0x38
            //   4885db               | mov                 dword ptr [esp + 0x20], ebp
            //   0f8480000000         | inc                 ecx
            //   488d5318             | dec                 esp
            //   4032ff               | dec                 ecx
            //   4885d2               | sub                 ebp, 0x20
            //   7462                 | dec                 eax

        $sequence_6 = { e8???????? 488d0d65370000 ff15???????? ff15???????? 33c0 4881c430020000 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   488d0d65370000       | lea                 eax, [ebp + 0x27]
            //   ff15????????         |                     
            //   ff15????????         |                     
            //   33c0                 | mov                 dword ptr [ebp - 0x69], 0x20100
            //   4881c430020000       | dec                 eax

        $sequence_7 = { 84c0 0f84ff000000 0fb77c2420 488b742428 8bc7 48d1e8 }
            // n = 6, score = 100
            //   84c0                 | dec                 eax
            //   0f84ff000000         | test                eax, eax
            //   0fb77c2420           | je                  0x1282
            //   488b742428           | call                eax
            //   8bc7                 | dec                 eax
            //   48d1e8               | mov                 ebx, eax

        $sequence_8 = { 33ff b90d0000c0 4d85d2 0f45cf 7408 488bc2 492bc2 }
            // n = 7, score = 100
            //   33ff                 | mov                 esi, dword ptr [esp + 0x88]
            //   b90d0000c0           | dec                 eax
            //   4d85d2               | lcall               0x8548:0xb8
            //   0f45cf               | fisttp              dword ptr [edi]
            //   7408                 | test                byte ptr [esi - 0x7f000000], dl
            //   488bc2               | jnp                 0x29
            //   492bc2               | sbb                 eax, dword ptr [eax]

        $sequence_9 = { 4889442420 488d55f7 ff15???????? 85c0 8bd8 0f49df }
            // n = 6, score = 100
            //   4889442420           | dec                 ecx
            //   488d55f7             | mov                 ecx, esp
            //   ff15????????         |                     
            //   85c0                 | mov                 eax, ebx
            //   8bd8                 | dec                 eax
            //   0f49df               | add                 esp, 0x40

    condition:
        7 of them and filesize < 91136
}