rule win_fishmaster_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.fishmaster."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fishmaster"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { b9e8030000 ff15???????? 4c89742450 48c74424580f000000 }
            // n = 4, score = 100
            //   b9e8030000           | mov                 dword ptr [ebp + 8], eax
            //   ff15????????         |                     
            //   4c89742450           | dec                 eax
            //   48c74424580f000000     | lea    eax, [ebp + 0xbf0]

        $sequence_1 = { 8d45fd 4863c8 460fbe0401 418d40bf 3c19 7706 }
            // n = 6, score = 100
            //   8d45fd               | lea                 ecx, [eax - 0x60]
            //   4863c8               | dec                 eax
            //   460fbe0401           | mov                 dword ptr [ebx + 0x10], esi
            //   418d40bf             | dec                 eax
            //   3c19                 | mov                 dword ptr [ebx + 0x18], 0xf
            //   7706                 | inc                 eax

        $sequence_2 = { 7203 4c8b03 8d45ff 4863c8 }
            // n = 4, score = 100
            //   7203                 | nop                 
            //   4c8b03               | dec                 ecx
            //   8d45ff               | cmp                 esi, 0x10
            //   4863c8               | dec                 eax

        $sequence_3 = { 488d0d25310000 0f57c0 488d5308 48890b 488d4808 0f1102 ff15???????? }
            // n = 7, score = 100
            //   488d0d25310000       | cmp                 al, 9
            //   0f57c0               | ja                  0xac9
            //   488d5308             | inc                 esp
            //   48890b               | lea                 edi, [ecx + 4]
            //   488d4808             | jmp                 0xada
            //   0f1102               | inc                 esp
            //   ff15????????         |                     

        $sequence_4 = { 488bcb 41ffd5 90 488b5558 4883fa10 7234 }
            // n = 6, score = 100
            //   488bcb               | mov                 eax, dword ptr [ebx]
            //   41ffd5               | lea                 eax, [ebp - 1]
            //   90                   | inc                 ecx
            //   488b5558             | cmove               ebp, edx
            //   4883fa10             | mov                 ecx, ebp
            //   7234                 | sar                 ecx, 4

        $sequence_5 = { ba05000020 488bcb ff15???????? 488bcb ff15???????? c744243000010000 }
            // n = 6, score = 100
            //   ba05000020           | mov                 dword ptr [esp + 0xa8], 2
            //   488bcb               | jmp                 0xe00
            //   ff15????????         |                     
            //   488bcb               | dec                 eax
            //   ff15????????         |                     
            //   c744243000010000     | mov                 ecx, ebx

        $sequence_6 = { 488d054d2a0000 c3 8325????????00 c3 48895c2408 55 }
            // n = 6, score = 100
            //   488d054d2a0000       | inc                 ecx
            //   c3                   | cmp                 al, 0x2f
            //   8325????????00       |                     
            //   c3                   | inc                 ecx
            //   48895c2408           | cmove               edi, edi
            //   55                   | sar                 edi, 2

        $sequence_7 = { 4983f910 7203 4c8b03 8d45ff 4863c8 460fbe0401 418d40bf }
            // n = 7, score = 100
            //   4983f910             | lea                 ecx, [eax + 0x27]
            //   7203                 | dec                 eax
            //   4c8b03               | cmp                 ecx, eax
            //   8d45ff               | jbe                 0x8ef
            //   4863c8               | jmp                 0x802
            //   460fbe0401           | dec                 eax
            //   418d40bf             | mov                 ecx, 0x27

        $sequence_8 = { 83f828 7309 33c9 ff15???????? cc }
            // n = 5, score = 100
            //   83f828               | mov                 ecx, dword ptr [ebx + 0x10]
            //   7309                 | dec                 eax
            //   33c9                 | movsx               ecx, byte ptr [ecx]
            //   ff15????????         |                     
            //   cc                   | and                 ecx, 3

        $sequence_9 = { 4883f801 721c 488d4101 48894310 4883fa10 488bc3 7203 }
            // n = 7, score = 100
            //   4883f801             | lea                 eax, [ecx - 0x30]
            //   721c                 | cmp                 al, 9
            //   488d4101             | ja                  0x2b5
            //   48894310             | cmp                 al, 0x19
            //   4883fa10             | ja                  0x2b9
            //   488bc3               | inc                 esp
            //   7203                 | lea                 esp, [ecx - 0x41]

    condition:
        7 of them and filesize < 812032
}