rule win_flashflood_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.flashflood."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.flashflood"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? eb0c ff7508 ff75fc ff15???????? 3975fc 5e }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   eb0c                 | jmp                 0xe
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff15????????         |                     
            //   3975fc               | cmp                 dword ptr [ebp - 4], esi
            //   5e                   | pop                 esi

        $sequence_1 = { 8b45ec 52 8d55f8 52 8b08 6a10 }
            // n = 6, score = 100
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   52                   | push                edx
            //   8d55f8               | lea                 edx, [ebp - 8]
            //   52                   | push                edx
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   6a10                 | push                0x10

        $sequence_2 = { 8b5508 8b427c 6bc00c 33c9 668b88ec914000 8b5508 }
            // n = 6, score = 100
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b427c               | mov                 eax, dword ptr [edx + 0x7c]
            //   6bc00c               | imul                eax, eax, 0xc
            //   33c9                 | xor                 ecx, ecx
            //   668b88ec914000       | mov                 cx, word ptr [eax + 0x4091ec]
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]

        $sequence_3 = { c21000 b8???????? c3 33c9 394c2408 7e0f }
            // n = 6, score = 100
            //   c21000               | ret                 0x10
            //   b8????????           |                     
            //   c3                   | ret                 
            //   33c9                 | xor                 ecx, ecx
            //   394c2408             | cmp                 dword ptr [esp + 8], ecx
            //   7e0f                 | jle                 0x11

        $sequence_4 = { 8b45f4 25ffff0000 33c9 8a88b0984000 894de8 eb17 8b55f4 }
            // n = 7, score = 100
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   25ffff0000           | and                 eax, 0xffff
            //   33c9                 | xor                 ecx, ecx
            //   8a88b0984000         | mov                 cl, byte ptr [eax + 0x4098b0]
            //   894de8               | mov                 dword ptr [ebp - 0x18], ecx
            //   eb17                 | jmp                 0x19
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]

        $sequence_5 = { 8d853cf9ffff 50 ff15???????? 83c420 }
            // n = 4, score = 100
            //   8d853cf9ffff         | lea                 eax, [ebp - 0x6c4]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   83c420               | add                 esp, 0x20

        $sequence_6 = { 33c0 eb0a 57 ff15???????? 6a01 58 5f }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   eb0a                 | jmp                 0xc
            //   57                   | push                edi
            //   ff15????????         |                     
            //   6a01                 | push                1
            //   58                   | pop                 eax
            //   5f                   | pop                 edi

        $sequence_7 = { 6a01 57 e8???????? 6a01 e8???????? }
            // n = 5, score = 100
            //   6a01                 | push                1
            //   57                   | push                edi
            //   e8????????           |                     
            //   6a01                 | push                1
            //   e8????????           |                     

        $sequence_8 = { 50 e8???????? ff45fc 83c610 }
            // n = 4, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   ff45fc               | inc                 dword ptr [ebp - 4]
            //   83c610               | add                 esi, 0x10

        $sequence_9 = { 8a0406 8ad0 c0ea04 c0e004 02d0 }
            // n = 5, score = 100
            //   8a0406               | mov                 al, byte ptr [esi + eax]
            //   8ad0                 | mov                 dl, al
            //   c0ea04               | shr                 dl, 4
            //   c0e004               | shl                 al, 4
            //   02d0                 | add                 dl, al

    condition:
        7 of them and filesize < 114688
}