rule win_flawedgrace_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.flawedgrace."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.flawedgrace"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bcf e8???????? 83c404 85c0 0f84a8010000 0f31 52 }
            // n = 7, score = 200
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   0f84a8010000         | je                  0x1ae
            //   0f31                 | rdtsc               
            //   52                   | push                edx

        $sequence_1 = { 0fb6c0 894dec 8bcb c1e918 8b0485e0bb4500 33048de0bf4500 894510 }
            // n = 7, score = 200
            //   0fb6c0               | movzx               eax, al
            //   894dec               | mov                 dword ptr [ebp - 0x14], ecx
            //   8bcb                 | mov                 ecx, ebx
            //   c1e918               | shr                 ecx, 0x18
            //   8b0485e0bb4500       | mov                 eax, dword ptr [eax*4 + 0x45bbe0]
            //   33048de0bf4500       | xor                 eax, dword ptr [ecx*4 + 0x45bfe0]
            //   894510               | mov                 dword ptr [ebp + 0x10], eax

        $sequence_2 = { c6853bf5ffff00 c6853cf5ffffff c6853df5ffff25 c6853ef5ffff30 c6853ff5ffff20 c68540f5ffff40 c68541f5ffff00 }
            // n = 7, score = 200
            //   c6853bf5ffff00       | mov                 byte ptr [ebp - 0xac5], 0
            //   c6853cf5ffffff       | mov                 byte ptr [ebp - 0xac4], 0xff
            //   c6853df5ffff25       | mov                 byte ptr [ebp - 0xac3], 0x25
            //   c6853ef5ffff30       | mov                 byte ptr [ebp - 0xac2], 0x30
            //   c6853ff5ffff20       | mov                 byte ptr [ebp - 0xac1], 0x20
            //   c68540f5ffff40       | mov                 byte ptr [ebp - 0xac0], 0x40
            //   c68541f5ffff00       | mov                 byte ptr [ebp - 0xabf], 0

        $sequence_3 = { c6858ddaffff33 c6858edaffff00 c6858fdaffff00 c68590daffff00 c68591daffff00 c68592daffff00 c68593daffff00 }
            // n = 7, score = 200
            //   c6858ddaffff33       | mov                 byte ptr [ebp - 0x2573], 0x33
            //   c6858edaffff00       | mov                 byte ptr [ebp - 0x2572], 0
            //   c6858fdaffff00       | mov                 byte ptr [ebp - 0x2571], 0
            //   c68590daffff00       | mov                 byte ptr [ebp - 0x2570], 0
            //   c68591daffff00       | mov                 byte ptr [ebp - 0x256f], 0
            //   c68592daffff00       | mov                 byte ptr [ebp - 0x256e], 0
            //   c68593daffff00       | mov                 byte ptr [ebp - 0x256d], 0

        $sequence_4 = { c68565f2ffff00 c68566f2ffff85 c68567f2ffffc0 c68568f2ffff74 c68569f2ffff3a c6856af2ffff81 c6856bf2ffff7d }
            // n = 7, score = 200
            //   c68565f2ffff00       | mov                 byte ptr [ebp - 0xd9b], 0
            //   c68566f2ffff85       | mov                 byte ptr [ebp - 0xd9a], 0x85
            //   c68567f2ffffc0       | mov                 byte ptr [ebp - 0xd99], 0xc0
            //   c68568f2ffff74       | mov                 byte ptr [ebp - 0xd98], 0x74
            //   c68569f2ffff3a       | mov                 byte ptr [ebp - 0xd97], 0x3a
            //   c6856af2ffff81       | mov                 byte ptr [ebp - 0xd96], 0x81
            //   c6856bf2ffff7d       | mov                 byte ptr [ebp - 0xd95], 0x7d

        $sequence_5 = { 7416 8b85ccc0ffff 50 6a00 ff15???????? }
            // n = 5, score = 200
            //   7416                 | je                  0x18
            //   8b85ccc0ffff         | mov                 eax, dword ptr [ebp - 0x3f34]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   ff15????????         |                     

        $sequence_6 = { 8b0495b8d34600 f644082801 7421 57 e8???????? 59 50 }
            // n = 7, score = 200
            //   8b0495b8d34600       | mov                 eax, dword ptr [edx*4 + 0x46d3b8]
            //   f644082801           | test                byte ptr [eax + ecx + 0x28], 1
            //   7421                 | je                  0x23
            //   57                   | push                edi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   50                   | push                eax

        $sequence_7 = { c685abfdffff00 c685acfdffff00 c685adfdffff00 c685aefdffff00 c685affdffff00 c685b0fdffff00 c685b1fdffff00 }
            // n = 7, score = 200
            //   c685abfdffff00       | mov                 byte ptr [ebp - 0x255], 0
            //   c685acfdffff00       | mov                 byte ptr [ebp - 0x254], 0
            //   c685adfdffff00       | mov                 byte ptr [ebp - 0x253], 0
            //   c685aefdffff00       | mov                 byte ptr [ebp - 0x252], 0
            //   c685affdffff00       | mov                 byte ptr [ebp - 0x251], 0
            //   c685b0fdffff00       | mov                 byte ptr [ebp - 0x250], 0
            //   c685b1fdffff00       | mov                 byte ptr [ebp - 0x24f], 0

        $sequence_8 = { 3934bdb8d34600 7531 e8???????? 8904bdb8d34600 85c0 7514 6a0c }
            // n = 7, score = 200
            //   3934bdb8d34600       | cmp                 dword ptr [edi*4 + 0x46d3b8], esi
            //   7531                 | jne                 0x33
            //   e8????????           |                     
            //   8904bdb8d34600       | mov                 dword ptr [edi*4 + 0x46d3b8], eax
            //   85c0                 | test                eax, eax
            //   7514                 | jne                 0x16
            //   6a0c                 | push                0xc

        $sequence_9 = { c685d3c8ffff05 c685d4c8ffff00 c685d5c8ffff00 c685d6c8ffff00 c685d7c8ffffe8 c685d8c8ffff48 c685d9c8ffff0f }
            // n = 7, score = 200
            //   c685d3c8ffff05       | mov                 byte ptr [ebp - 0x372d], 5
            //   c685d4c8ffff00       | mov                 byte ptr [ebp - 0x372c], 0
            //   c685d5c8ffff00       | mov                 byte ptr [ebp - 0x372b], 0
            //   c685d6c8ffff00       | mov                 byte ptr [ebp - 0x372a], 0
            //   c685d7c8ffffe8       | mov                 byte ptr [ebp - 0x3729], 0xe8
            //   c685d8c8ffff48       | mov                 byte ptr [ebp - 0x3728], 0x48
            //   c685d9c8ffff0f       | mov                 byte ptr [ebp - 0x3727], 0xf

    condition:
        7 of them and filesize < 966656
}