rule win_flowershop_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.flowershop."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.flowershop"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3b45f0 74e0 8945f0 6a08 8d45f0 6a00 50 }
            // n = 7, score = 500
            //   3b45f0               | cmp                 eax, dword ptr [ebp - 0x10]
            //   74e0                 | je                  0xffffffe2
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   6a08                 | push                8
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   6a00                 | push                0
            //   50                   | push                eax

        $sequence_1 = { 5e c3 56 33f6 8935???????? e8???????? a1???????? }
            // n = 7, score = 500
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   56                   | push                esi
            //   33f6                 | xor                 esi, esi
            //   8935????????         |                     
            //   e8????????           |                     
            //   a1????????           |                     

        $sequence_2 = { ff75e0 e8???????? 83c418 85c0 750e c705????????01000000 33c0 }
            // n = 7, score = 500
            //   ff75e0               | push                dword ptr [ebp - 0x20]
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   85c0                 | test                eax, eax
            //   750e                 | jne                 0x10
            //   c705????????01000000     |     
            //   33c0                 | xor                 eax, eax

        $sequence_3 = { 59 85c0 59 741f 8b07 0105???????? }
            // n = 6, score = 500
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   59                   | pop                 ecx
            //   741f                 | je                  0x21
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   0105????????         |                     

        $sequence_4 = { 51 56 57 33ff 897df8 897dfc c745f898c3fead }
            // n = 7, score = 500
            //   51                   | push                ecx
            //   56                   | push                esi
            //   57                   | push                edi
            //   33ff                 | xor                 edi, edi
            //   897df8               | mov                 dword ptr [ebp - 8], edi
            //   897dfc               | mov                 dword ptr [ebp - 4], edi
            //   c745f898c3fead       | mov                 dword ptr [ebp - 8], 0xadfec398

        $sequence_5 = { 894d0c 76bb 33c0 5f 5e 5b c9 }
            // n = 7, score = 500
            //   894d0c               | mov                 dword ptr [ebp + 0xc], ecx
            //   76bb                 | jbe                 0xffffffbd
            //   33c0                 | xor                 eax, eax
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   c9                   | leave               

        $sequence_6 = { eb71 0fb605???????? 6bc07c 50 8d85f9e0ffff 68???????? 50 }
            // n = 7, score = 500
            //   eb71                 | jmp                 0x73
            //   0fb605????????       |                     
            //   6bc07c               | imul                eax, eax, 0x7c
            //   50                   | push                eax
            //   8d85f9e0ffff         | lea                 eax, [ebp - 0x1f07]
            //   68????????           |                     
            //   50                   | push                eax

        $sequence_7 = { 33c9 83c60c 81fe???????? 72d8 85c9 0f8471ffffff }
            // n = 6, score = 500
            //   33c9                 | xor                 ecx, ecx
            //   83c60c               | add                 esi, 0xc
            //   81fe????????         |                     
            //   72d8                 | jb                  0xffffffda
            //   85c9                 | test                ecx, ecx
            //   0f8471ffffff         | je                  0xffffff77

        $sequence_8 = { 8b7510 8b7dfc 837e0400 750b 817e0818350000 7502 ff17 }
            // n = 7, score = 500
            //   8b7510               | mov                 esi, dword ptr [ebp + 0x10]
            //   8b7dfc               | mov                 edi, dword ptr [ebp - 4]
            //   837e0400             | cmp                 dword ptr [esi + 4], 0
            //   750b                 | jne                 0xd
            //   817e0818350000       | cmp                 dword ptr [esi + 8], 0x3518
            //   7502                 | jne                 4
            //   ff17                 | call                dword ptr [edi]

        $sequence_9 = { 2b01 c3 8b442404 8b542408 8b4804 03ca }
            // n = 6, score = 500
            //   2b01                 | sub                 eax, dword ptr [ecx]
            //   c3                   | ret                 
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   8b542408             | mov                 edx, dword ptr [esp + 8]
            //   8b4804               | mov                 ecx, dword ptr [eax + 4]
            //   03ca                 | add                 ecx, edx

    condition:
        7 of them and filesize < 829440
}