rule win_forest_tiger_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.forest_tiger."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.forest_tiger"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 833f01 0f94c0 84c0 7407 e8???????? eb05 e8???????? }
            // n = 7, score = 200
            //   833f01               | cmp                 dword ptr [edi], 1
            //   0f94c0               | sete                al
            //   84c0                 | test                al, al
            //   7407                 | je                  9
            //   e8????????           |                     
            //   eb05                 | jmp                 7
            //   e8????????           |                     

        $sequence_1 = { 6bc930 8975e0 8db1c0084400 8975e4 }
            // n = 4, score = 100
            //   6bc930               | imul                ecx, ecx, 0x30
            //   8975e0               | mov                 dword ptr [ebp - 0x20], esi
            //   8db1c0084400         | lea                 esi, [ecx + 0x4408c0]
            //   8975e4               | mov                 dword ptr [ebp - 0x1c], esi

        $sequence_2 = { 4c8b4608 498bc0 488b4c2478 482bc1 }
            // n = 4, score = 100
            //   4c8b4608             | mov                 eax, dword ptr [ebp - 1]
            //   498bc0               | mov                 edx, dword ptr [ebp - 0x25]
            //   488b4c2478           | dec                 eax
            //   482bc1               | mov                 ecx, dword ptr [ebp - 0x31]

        $sequence_3 = { 6bc00c 56 ff90f0664300 59 }
            // n = 4, score = 100
            //   6bc00c               | imul                eax, eax, 0xc
            //   56                   | push                esi
            //   ff90f0664300         | call                dword ptr [eax + 0x4366f0]
            //   59                   | pop                 ecx

        $sequence_4 = { 4c8b4608 488b542478 4c2bc2 4983e0fc }
            // n = 4, score = 100
            //   4c8b4608             | cmp                 dword ptr [ebp - 0x30], edx
            //   488b542478           | jne                 0x19
            //   4c2bc2               | dec                 eax
            //   4983e0fc             | cmp                 dword ptr [ebp - 0x28], edx

        $sequence_5 = { 4c8b45c8 4c8b4dc0 f30f7f45d0 4c3955d0 }
            // n = 4, score = 100
            //   4c8b45c8             | dec                 eax
            //   4c8b4dc0             | lea                 edx, [0x23521]
            //   f30f7f45d0           | inc                 esp
            //   4c3955d0             | mov                 ecx, ebx

        $sequence_6 = { 6bc009 0fb68408c0724300 6a08 c1e804 }
            // n = 4, score = 100
            //   6bc009               | imul                eax, eax, 9
            //   0fb68408c0724300     | movzx               eax, byte ptr [eax + ecx + 0x4372c0]
            //   6a08                 | push                8
            //   c1e804               | shr                 eax, 4

        $sequence_7 = { 4c8b4710 488bd7 488bcb 49ffc0 e8???????? eb0a }
            // n = 6, score = 100
            //   4c8b4710             | dec                 eax
            //   488bd7               | mov                 edx, dword ptr [esp + 0x78]
            //   488bcb               | dec                 esp
            //   49ffc0               | sub                 eax, edx
            //   e8????????           |                     
            //   eb0a                 | dec                 ecx

        $sequence_8 = { 4c8b45bf 488d1521350200 448bcb 488bc8 }
            // n = 4, score = 100
            //   4c8b45bf             | dec                 esp
            //   488d1521350200       | mov                 eax, dword ptr [ebp - 0x41]
            //   448bcb               | dec                 eax
            //   488bc8               | lea                 edx, [0x23521]

        $sequence_9 = { 6aff ff15???????? 894604 85c0 7429 }
            // n = 5, score = 100
            //   6aff                 | push                -1
            //   ff15????????         |                     
            //   894604               | mov                 dword ptr [esi + 4], eax
            //   85c0                 | test                eax, eax
            //   7429                 | je                  0x2b

        $sequence_10 = { 4c8b45ff 8b55db 488b4dcf e8???????? }
            // n = 4, score = 100
            //   4c8b45ff             | mov                 ecx, dword ptr [ebp - 0x40]
            //   8b55db               | movdqu              xmmword ptr [ebp - 0x30], xmm0
            //   488b4dcf             | dec                 esp
            //   e8????????           |                     

        $sequence_11 = { 6aff 8d8df4fdffff 51 52 }
            // n = 4, score = 100
            //   6aff                 | push                -1
            //   8d8df4fdffff         | lea                 ecx, [ebp - 0x20c]
            //   51                   | push                ecx
            //   52                   | push                edx

        $sequence_12 = { 4c8b4750 488b33 448b7308 448b6f30 }
            // n = 4, score = 100
            //   4c8b4750             | sub                 eax, edx
            //   488b33               | dec                 ecx
            //   448b7308             | and                 eax, 0xfffffffc
            //   448b6f30             | dec                 ecx

        $sequence_13 = { 6aff 8d8dc8f4ffff 6880000000 51 }
            // n = 4, score = 100
            //   6aff                 | push                -1
            //   8d8dc8f4ffff         | lea                 ecx, [ebp - 0xb38]
            //   6880000000           | push                0x80
            //   51                   | push                ecx

        $sequence_14 = { 6aff 8d942498010000 6880000000 52 }
            // n = 4, score = 100
            //   6aff                 | push                -1
            //   8d942498010000       | lea                 edx, [esp + 0x198]
            //   6880000000           | push                0x80
            //   52                   | push                edx

    condition:
        7 of them and filesize < 709632
}