rule win_formbook_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.formbook."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.formbook"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8be5 5d c3 8d48f8 80f903 771e 8b5518 }
            // n = 7, score = 2200
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8d48f8               | lea                 ecx, [eax - 8]
            //   80f903               | cmp                 cl, 3
            //   771e                 | ja                  0x20
            //   8b5518               | mov                 edx, dword ptr [ebp + 0x18]

        $sequence_1 = { 8bec 8b4508 8b4810 56 6a0d 6a00 }
            // n = 6, score = 2200
            //   8bec                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b4810               | mov                 ecx, dword ptr [eax + 0x10]
            //   56                   | push                esi
            //   6a0d                 | push                0xd
            //   6a00                 | push                0

        $sequence_2 = { 56 e8???????? 56 e8???????? 40 50 8b450c }
            // n = 7, score = 2200
            //   56                   | push                esi
            //   e8????????           |                     
            //   56                   | push                esi
            //   e8????????           |                     
            //   40                   | inc                 eax
            //   50                   | push                eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_3 = { e8???????? 83c418 8986dc020000 85c0 780c 8b4d0c }
            // n = 6, score = 2200
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   8986dc020000         | mov                 dword ptr [esi + 0x2dc], eax
            //   85c0                 | test                eax, eax
            //   780c                 | js                  0xe
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]

        $sequence_4 = { 85ff 7439 8b550c 85d2 7432 8b4d10 33c0 }
            // n = 7, score = 2200
            //   85ff                 | test                edi, edi
            //   7439                 | je                  0x3b
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   85d2                 | test                edx, edx
            //   7432                 | je                  0x34
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   33c0                 | xor                 eax, eax

        $sequence_5 = { 33c0 85d2 741b 8d0c79 53 8d642400 668b1c46 }
            // n = 7, score = 2200
            //   33c0                 | xor                 eax, eax
            //   85d2                 | test                edx, edx
            //   741b                 | je                  0x1d
            //   8d0c79               | lea                 ecx, [ecx + edi*2]
            //   53                   | push                ebx
            //   8d642400             | lea                 esp, [esp]
            //   668b1c46             | mov                 bx, word ptr [esi + eax*2]

        $sequence_6 = { 80fa03 0f862cffffff 3c34 0f8446ffffff 3c35 0f8460ffffff 8d48c8 }
            // n = 7, score = 2200
            //   80fa03               | cmp                 dl, 3
            //   0f862cffffff         | jbe                 0xffffff32
            //   3c34                 | cmp                 al, 0x34
            //   0f8446ffffff         | je                  0xffffff4c
            //   3c35                 | cmp                 al, 0x35
            //   0f8460ffffff         | je                  0xffffff66
            //   8d48c8               | lea                 ecx, [eax - 0x38]

        $sequence_7 = { e8???????? 8b4508 8d4df8 51 8d55f0 52 6a00 }
            // n = 7, score = 2200
            //   e8????????           |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8d4df8               | lea                 ecx, [ebp - 8]
            //   51                   | push                ecx
            //   8d55f0               | lea                 edx, [ebp - 0x10]
            //   52                   | push                edx
            //   6a00                 | push                0

        $sequence_8 = { 53 56 57 8b7d10 8d8768480000 50 8db768080000 }
            // n = 7, score = 2200
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   8b7d10               | mov                 edi, dword ptr [ebp + 0x10]
            //   8d8768480000         | lea                 eax, [edi + 0x4868]
            //   50                   | push                eax
            //   8db768080000         | lea                 esi, [edi + 0x868]

        $sequence_9 = { 51 57 e8???????? 83c410 85c0 7915 8b13 }
            // n = 7, score = 2200
            //   51                   | push                ecx
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   85c0                 | test                eax, eax
            //   7915                 | jns                 0x17
            //   8b13                 | mov                 edx, dword ptr [ebx]

    condition:
        7 of them and filesize < 371712
}